/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.spark.bigquery.BigQueryStreamWriter;
import com.google.cloud.spark.bigquery.BigQueryWriteHelper;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.spark3.DataFrameToRDDConverter;
import com.google.cloud.spark.bigquery.spark3.Spark3DataFrameToRDDConverter;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;

public final class BigQueryStreamWriter$
implements Logging {
    public static BigQueryStreamWriter$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new BigQueryStreamWriter$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void writeBatch(Dataset<Row> data, SQLContext sqlContext, OutputMode outputMode, SparkBigQueryConfig opts, BigQueryClient bigQueryClient) {
        StructType schema = data.schema();
        String sparkVersion = sqlContext.sparkSession().version();
        RDD rowRdd = this.dataFrameToRDDConverterFactory(sparkVersion).convertToRDD(data);
        Dataset dataFrame = sqlContext.createDataFrame(rowRdd, schema);
        Option table = Option$.MODULE$.apply((Object)bigQueryClient.getTable(opts.getTableId()));
        SaveMode saveMode = this.getSaveMode(outputMode);
        BigQueryWriteHelper helper = new BigQueryWriteHelper(bigQueryClient, sqlContext, saveMode, opts, (Dataset<Row>)dataFrame, table.isDefined());
        helper.writeDataFrameToBigQuery();
    }

    private SaveMode getSaveMode(OutputMode outputMode) throws NotImplementedError {
        SaveMode saveMode;
        OutputMode outputMode2 = outputMode;
        OutputMode outputMode3 = OutputMode.Complete();
        if (!(outputMode2 != null ? !outputMode2.equals(outputMode3) : outputMode3 != null)) {
            saveMode = SaveMode.Overwrite;
        } else {
            OutputMode outputMode4 = outputMode;
            OutputMode outputMode5 = OutputMode.Update();
            if (!(outputMode4 != null ? !outputMode4.equals(outputMode5) : outputMode5 != null)) {
                throw new NotImplementedError("Updates are not yet supported");
            }
            saveMode = SaveMode.Append;
        }
        return saveMode;
    }

    public DataFrameToRDDConverter dataFrameToRDDConverterFactory(String sparkVersion) {
        int version = sparkVersion.charAt(0) - 48;
        return version < 3 ? new BigQueryStreamWriter.Spark2DataFrameToRDDConverter() : new Spark3DataFrameToRDDConverter();
    }

    private BigQueryStreamWriter$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

