/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.auth.Credentials;
import com.google.cloud.TransportOptions;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.connector.common.BigQueryProxyConfig;
import com.google.cloud.bigquery.connector.common.BigQueryProxyTransporterBuilder;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Properties$;

public final class BigQueryUtilScala$
implements Logging {
    public static BigQueryUtilScala$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new BigQueryUtilScala$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<String> noneIfEmpty(String s) {
        return Option$.MODULE$.apply((Object)s).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BigQueryUtilScala$.$anonfun$noneIfEmpty$1(x$1)));
    }

    public void validateScalaVersionCompatibility() {
        String runtimeScalaVersion = this.trimVersion(Properties$.MODULE$.versionNumberString());
        Properties buildProperties = new Properties();
        buildProperties.load(this.getClass().getResourceAsStream("/spark-bigquery-connector.properties"));
        String connectorScalaVersion = this.trimVersion(buildProperties.getProperty("scala.version"));
        if (!runtimeScalaVersion.equals(connectorScalaVersion)) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(94).append("\n           |This connector was made for Scala ").append(connectorScalaVersion).append(",\n           |it was not meant to run on Scala ").append(runtimeScalaVersion).toString())).stripMargin().replace('\n', ' '));
        }
    }

    private String trimVersion(String version) {
        return version.substring(0, version.lastIndexOf(46));
    }

    public <T> Seq<T> toSeq(List<T> list) {
        return ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).toSeq();
    }

    public <T> java.util.Iterator<T> toJavaIterator(Iterator<T> it) {
        return (java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(it).asJava();
    }

    public BigQuery createBigQuery(SparkBigQueryConfig options) {
        Credentials credentials = options.createCredentials();
        String parentProjectId = options.getParentProjectId();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("BigQuery client project id is [").append(parentProjectId).append("], derived from the parentProject option").toString());
        BigQueryOptions.Builder bqOptions = (BigQueryOptions.Builder)BigQueryOptions.newBuilder().setProjectId(parentProjectId).setCredentials(credentials).setRetrySettings(options.getBigQueryClientRetrySettings());
        HttpTransportOptions.Builder httpTransportOptionsBuilder = HttpTransportOptions.newBuilder().setConnectTimeout(options.getBigQueryClientConnectTimeout()).setReadTimeout(options.getBigQueryClientReadTimeout());
        BigQueryProxyConfig proxyHttpConfig = options.getBigQueryProxyConfig();
        Object object = proxyHttpConfig.getProxyUri().isPresent() ? httpTransportOptionsBuilder.setHttpTransportFactory(BigQueryProxyTransporterBuilder.createHttpTransportFactory(proxyHttpConfig.getProxyUri(), proxyHttpConfig.getProxyUsername(), proxyHttpConfig.getProxyPassword())) : BoxedUnit.UNIT;
        bqOptions.setTransportOptions((TransportOptions)httpTransportOptionsBuilder.build());
        return (BigQuery)bqOptions.build().getService();
    }

    public <T> Option<T> toOption(Optional<T> javaOptional) {
        return javaOptional.isPresent() ? new Some(javaOptional.get()) : None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$noneIfEmpty$1(String x$1) {
        return x$1.trim().isEmpty();
    }

    private BigQueryUtilScala$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

