/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.Clustering;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.spark.bigquery.BigQueryUtilScala$;
import com.google.cloud.spark.bigquery.BigQueryWriteHelper$;
import com.google.cloud.spark.bigquery.IntermediateDataCleaner;
import com.google.cloud.spark.bigquery.SchemaConverters;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.SparkBigQueryUtil;
import com.google.cloud.spark.bigquery.SupportedCustomDataType;
import com.google.cloud.spark.bigquery.ToIterator;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.StructField;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tme\u0001B\u00193\u0001vB\u0001\"\u0016\u0001\u0003\u0016\u0004%\tA\u0016\u0005\tA\u0002\u0011\t\u0012)A\u0005/\"A\u0011\r\u0001BK\u0002\u0013\u0005!\r\u0003\u0005j\u0001\tE\t\u0015!\u0003d\u0011!Q\u0007A!f\u0001\n\u0003Y\u0007\u0002C8\u0001\u0005#\u0005\u000b\u0011\u00027\t\u0011A\u0004!Q3A\u0005\u0002ED\u0001B\u001e\u0001\u0003\u0012\u0003\u0006IA\u001d\u0005\to\u0002\u0011)\u001a!C\u0001q\"I\u0011q\u0003\u0001\u0003\u0012\u0003\u0006I!\u001f\u0005\u000b\u00033\u0001!Q3A\u0005\u0002\u0005m\u0001BCA\u0012\u0001\tE\t\u0015!\u0003\u0002\u001e!9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0002\"CA\u001c\u0001\t\u0007I\u0011AA\u001d\u0011!\tI\u0005\u0001Q\u0001\n\u0005m\u0002\"CA&\u0001\t\u0007I\u0011AA'\u0011!\tY\u0006\u0001Q\u0001\n\u0005=\u0003bBA/\u0001\u0011\u0005\u0011q\f\u0005\b\u0003O\u0002A\u0011AA5\u0011\u001d\tY\u0007\u0001C\u0001\u0003[Bq!!!\u0001\t\u0003\t\u0019\tC\u0004\u0002\u0016\u0002!\t!a\u0018\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\"9\u0011Q\u0017\u0001\u0005\u0002\u0005}\u0003bBA\\\u0001\u0011%\u0011\u0011\u0018\u0005\b\u0003\u000f\u0004A\u0011AA0\u0011%\tI\rAA\u0001\n\u0003\tY\rC\u0005\u0002Z\u0002\t\n\u0011\"\u0001\u0002\\\"I\u0011\u0011\u001f\u0001\u0012\u0002\u0013\u0005\u00111\u001f\u0005\n\u0003o\u0004\u0011\u0013!C\u0001\u0003sD\u0011\"!@\u0001#\u0003%\t!a@\t\u0013\t\r\u0001!%A\u0005\u0002\t\u0015\u0001\"\u0003B\u0005\u0001E\u0005I\u0011\u0001B\u0006\u0011%\u0011y\u0001AA\u0001\n\u0003\u0012\t\u0002C\u0005\u0003\"\u0001\t\t\u0011\"\u0001\u0003$!I!1\u0006\u0001\u0002\u0002\u0013\u0005!Q\u0006\u0005\n\u0005s\u0001\u0011\u0011!C!\u0005wA\u0011B!\u0013\u0001\u0003\u0003%\tAa\u0013\t\u0013\t=\u0003!!A\u0005B\tE\u0003\"\u0003B*\u0001\u0005\u0005I\u0011\tB+\u0011%\u00119\u0006AA\u0001\n\u0003\u0012IfB\u0005\u0003^I\n\t\u0011#\u0001\u0003`\u0019A\u0011GMA\u0001\u0012\u0003\u0011\t\u0007C\u0004\u0002&-\"\tAa\u001c\t\u0013\tM3&!A\u0005F\tU\u0003\"\u0003B9W\u0005\u0005I\u0011\u0011B:\u0011%\u0011\tiKA\u0001\n\u0003\u0013\u0019\tC\u0005\u0003\u0012.\n\t\u0011\"\u0003\u0003\u0014\n\u0019\")[4Rk\u0016\u0014\u0018p\u0016:ji\u0016DU\r\u001c9fe*\u00111\u0007N\u0001\tE&<\u0017/^3ss*\u0011QGN\u0001\u0006gB\f'o\u001b\u0006\u0003oa\nQa\u00197pk\u0012T!!\u000f\u001e\u0002\r\u001d|wn\u001a7f\u0015\u0005Y\u0014aA2p[\u000e\u00011#\u0002\u0001?\t>\u0013\u0006CA C\u001b\u0005\u0001%\"A!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0003%AB!osJ+g\r\u0005\u0002F\u001b6\taI\u0003\u0002H\u0011\u0006A\u0011N\u001c;fe:\fGN\u0003\u00026\u0013*\u0011!jS\u0001\u0007CB\f7\r[3\u000b\u00031\u000b1a\u001c:h\u0013\tqeIA\u0004M_\u001e<\u0017N\\4\u0011\u0005}\u0002\u0016BA)A\u0005\u001d\u0001&o\u001c3vGR\u0004\"aP*\n\u0005Q\u0003%\u0001D*fe&\fG.\u001b>bE2,\u0017A\u00042jOF+XM]=DY&,g\u000e^\u000b\u0002/B\u0011\u0001LX\u0007\u00023*\u0011!lW\u0001\u0007G>lWn\u001c8\u000b\u0005qk\u0016!C2p]:,7\r^8s\u0015\t\u0019d'\u0003\u0002`3\nq!)[4Rk\u0016\u0014\u0018p\u00117jK:$\u0018a\u00042jOF+XM]=DY&,g\u000e\u001e\u0011\u0002\u0015M\fHnQ8oi\u0016DH/F\u0001d!\t!w-D\u0001f\u0015\t1\u0007*A\u0002tc2L!\u0001[3\u0003\u0015M\u000bFjQ8oi\u0016DH/A\u0006tc2\u001cuN\u001c;fqR\u0004\u0013\u0001C:bm\u0016lu\u000eZ3\u0016\u00031\u0004\"\u0001Z7\n\u00059,'\u0001C*bm\u0016lu\u000eZ3\u0002\u0013M\fg/Z'pI\u0016\u0004\u0013aB8qi&|gn]\u000b\u0002eB\u00111\u000f^\u0007\u0002e%\u0011QO\r\u0002\u0014'B\f'o\u001b\"jOF+XM]=D_:4\u0017nZ\u0001\t_B$\u0018n\u001c8tA\u0005!A-\u0019;b+\u0005I\bc\u0001>\u0002\u00129\u001910!\u0004\u000f\u0007q\fYAD\u0002~\u0003\u0013q1A`A\u0004\u001d\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u0001=\u0003\u0019a$o\\8u}%\tA*\u0003\u0002K\u0017&\u0011Q'S\u0005\u0003M\"K1!a\u0004f\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0005\u0002\u0016\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0004\u0003\u001f)\u0017!\u00023bi\u0006\u0004\u0013a\u0003;bE2,W\t_5tiN,\"!!\b\u0011\u0007}\ny\"C\u0002\u0002\"\u0001\u0013qAQ8pY\u0016\fg.\u0001\u0007uC\ndW-\u0012=jgR\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u000f\u0003S\tY#!\f\u00020\u0005E\u00121GA\u001b!\t\u0019\b\u0001C\u0003V\u001b\u0001\u0007q\u000bC\u0003b\u001b\u0001\u00071\rC\u0003k\u001b\u0001\u0007A\u000eC\u0003q\u001b\u0001\u0007!\u000fC\u0003x\u001b\u0001\u0007\u0011\u0010C\u0004\u0002\u001a5\u0001\r!!\b\u0002\t\r|gNZ\u000b\u0003\u0003w\u0001B!!\u0010\u0002F5\u0011\u0011q\b\u0006\u0005\u0003o\t\tEC\u0002\u0002D%\u000ba\u0001[1e_>\u0004\u0018\u0002BA$\u0003\u007f\u0011QbQ8oM&<WO]1uS>t\u0017!B2p]\u001a\u0004\u0013aB4dgB\u000bG\u000f[\u000b\u0003\u0003\u001f\u0002B!!\u0015\u0002X5\u0011\u00111\u000b\u0006\u0005\u0003+\n\t%\u0001\u0002gg&!\u0011\u0011LA*\u0005\u0011\u0001\u0016\r\u001e5\u0002\u0011\u001d\u001c7\u000fU1uQ\u0002\n\u0001d\u001e:ji\u0016$\u0015\r^1Ge\u0006lW\rV8CS\u001e\fV/\u001a:z+\t\t\t\u0007E\u0002@\u0003GJ1!!\u001aA\u0005\u0011)f.\u001b;\u0002%1|\u0017\r\u001a#bi\u0006$vNQ5h#V,'/\u001f\u000b\u0003\u0003C\n!d]1wK6{G-\u001a+p/JLG/\u001a#jgB|7/\u001b;j_:$B!a\u001c\u0002\u0000A!\u0011\u0011OA=\u001d\u0011\t\u0019(!\u001e\u000e\u0003uK1!a\u001e^\u0003\u001dQuNY%oM>LA!a\u001f\u0002~\t\u0001rK]5uK\u0012K7\u000f]8tSRLwN\u001c\u0006\u0004\u0003oj\u0006\"\u00026\u0015\u0001\u0004a\u0017!\u00054sS\u0016tG\r\\=UC\ndWMT1nKV\u0011\u0011Q\u0011\t\u0005\u0003\u000f\u000byI\u0004\u0003\u0002\n\u0006-\u0005CA@A\u0013\r\ti\tQ\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00151\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u00055\u0005)\u0001\fva\u0012\fG/Z'fi\u0006$\u0017\r^1JM:+W\rZ3e\u00031)\b\u000fZ1uK\u00124\u0015.\u001a7e)\u0019\tY*!)\u0002&B!\u00111OAO\u0013\r\ty*\u0018\u0002\u0006\r&,G\u000e\u001a\u0005\b\u0003G;\u0002\u0019AAN\u0003\u00151\u0017.\u001a7e\u0011\u001d\t9k\u0006a\u0001\u0003S\u000b\u0011\u0002Z1uC\u001aKW\r\u001c3\u0011\t\u0005-\u0016\u0011W\u0007\u0003\u0003[S1!a,f\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t\u0019,!,\u0003\u0017M#(/^2u\r&,G\u000eZ\u0001\u001eG2,\u0017M\u001c+f[B|'/\u0019:z\u000f\u000e\u001c\b+\u0019;i\u0013\u001atU-\u001a3fI\u0006Q2M]3bi\u0016$V-\u001c9pe\u0006\u0014\u0018\u0010U1uQ\u0012+G.\u001a;feV\u0011\u00111\u0018\t\u0006\u007f\u0005u\u0016\u0011Y\u0005\u0004\u0003\u007f\u0003%AB(qi&|g\u000eE\u0002t\u0003\u0007L1!!23\u0005]Ie\u000e^3s[\u0016$\u0017.\u0019;f\t\u0006$\u0018m\u00117fC:,'/\u0001\bwKJLg-_*bm\u0016lu\u000eZ3\u0002\t\r|\u0007/\u001f\u000b\u000f\u0003S\ti-a4\u0002R\u0006M\u0017Q[Al\u0011\u001d)6\u0004%AA\u0002]Cq!Y\u000e\u0011\u0002\u0003\u00071\rC\u0004k7A\u0005\t\u0019\u00017\t\u000fA\\\u0002\u0013!a\u0001e\"9qo\u0007I\u0001\u0002\u0004I\b\"CA\r7A\u0005\t\u0019AA\u000f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!8+\u0007]\u000byn\u000b\u0002\u0002bB!\u00111]Aw\u001b\t\t)O\u0003\u0003\u0002h\u0006%\u0018!C;oG\",7m[3e\u0015\r\tY\u000fQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAx\u0003K\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!>+\u0007\r\fy.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005m(f\u00017\u0002`\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\"TC\u0001B\u0001U\r\u0011\u0018q\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136+\t\u00119AK\u0002z\u0003?\fabY8qs\u0012\"WMZ1vYR$c'\u0006\u0002\u0003\u000e)\"\u0011QDAp\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!1\u0003\t\u0005\u0005+\u0011y\"\u0004\u0002\u0003\u0018)!!\u0011\u0004B\u000e\u0003\u0011a\u0017M\\4\u000b\u0005\tu\u0011\u0001\u00026bm\u0006LA!!%\u0003\u0018\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011!Q\u0005\t\u0004\u007f\t\u001d\u0012b\u0001B\u0015\u0001\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!q\u0006B\u001b!\ry$\u0011G\u0005\u0004\u0005g\u0001%aA!os\"I!q\u0007\u0013\u0002\u0002\u0003\u0007!QE\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tu\u0002C\u0002B \u0005\u000b\u0012y#\u0004\u0002\u0003B)\u0019!1\t!\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003H\t\u0005#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\b\u0003N!I!q\u0007\u0014\u0002\u0002\u0003\u0007!qF\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!QE\u0001\ti>\u001cFO]5oOR\u0011!1C\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005u!1\f\u0005\n\u0005oI\u0013\u0011!a\u0001\u0005_\t1CQ5h#V,'/_,sSR,\u0007*\u001a7qKJ\u0004\"a]\u0016\u0014\t-\u0012\u0019G\u0015\t\u000e\u0005K\u0012YgV2mef\fi\"!\u000b\u000e\u0005\t\u001d$b\u0001B5\u0001\u00069!/\u001e8uS6,\u0017\u0002\u0002B7\u0005O\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c87)\t\u0011y&A\u0003baBd\u0017\u0010\u0006\b\u0002*\tU$q\u000fB=\u0005w\u0012iHa \t\u000bUs\u0003\u0019A,\t\u000b\u0005t\u0003\u0019A2\t\u000b)t\u0003\u0019\u00017\t\u000bAt\u0003\u0019\u0001:\t\u000b]t\u0003\u0019A=\t\u000f\u0005ea\u00061\u0001\u0002\u001e\u00059QO\\1qa2LH\u0003\u0002BC\u0005\u001b\u0003RaPA_\u0005\u000f\u0003\"b\u0010BE/\u000ed'/_A\u000f\u0013\r\u0011Y\t\u0011\u0002\u0007)V\u0004H.\u001a\u001c\t\u0013\t=u&!AA\u0002\u0005%\u0012a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011)\n\u0005\u0003\u0003\u0016\t]\u0015\u0002\u0002BM\u0005/\u0011aa\u00142kK\u000e$\b")
public class BigQueryWriteHelper
implements Logging,
Product,
scala.Serializable {
    private final BigQueryClient bigQueryClient;
    private final SQLContext sqlContext;
    private final SaveMode saveMode;
    private final SparkBigQueryConfig options;
    private final Dataset<Row> data;
    private final boolean tableExists;
    private final Configuration conf;
    private final Path gcsPath;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<Tuple6<BigQueryClient, SQLContext, SaveMode, SparkBigQueryConfig, Dataset<Row>, Object>> unapply(BigQueryWriteHelper bigQueryWriteHelper) {
        return BigQueryWriteHelper$.MODULE$.unapply(bigQueryWriteHelper);
    }

    public static BigQueryWriteHelper apply(BigQueryClient bigQueryClient, SQLContext sQLContext, SaveMode saveMode, SparkBigQueryConfig sparkBigQueryConfig, Dataset<Row> dataset, boolean bl) {
        return BigQueryWriteHelper$.MODULE$.apply(bigQueryClient, sQLContext, saveMode, sparkBigQueryConfig, dataset, bl);
    }

    public static Function1<Tuple6<BigQueryClient, SQLContext, SaveMode, SparkBigQueryConfig, Dataset<Row>, Object>, BigQueryWriteHelper> tupled() {
        return BigQueryWriteHelper$.MODULE$.tupled();
    }

    public static Function1<BigQueryClient, Function1<SQLContext, Function1<SaveMode, Function1<SparkBigQueryConfig, Function1<Dataset<Row>, Function1<Object, BigQueryWriteHelper>>>>>> curried() {
        return BigQueryWriteHelper$.MODULE$.curried();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public BigQueryClient bigQueryClient() {
        return this.bigQueryClient;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public SaveMode saveMode() {
        return this.saveMode;
    }

    public SparkBigQueryConfig options() {
        return this.options;
    }

    public Dataset<Row> data() {
        return this.data;
    }

    public boolean tableExists() {
        return this.tableExists;
    }

    public Configuration conf() {
        return this.conf;
    }

    public Path gcsPath() {
        return this.gcsPath;
    }

    public void writeDataFrameToBigQuery() {
        if (BoxesRunTime.unboxToBoolean((Object)BigQueryUtilScala$.MODULE$.toOption(this.options().getCreateDisposition()).map((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)BigQueryWriteHelper.$anonfun$writeDataFrameToBigQuery$1(this, cd))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))) {
            throw new IOException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(121).append("\n           |For table ").append(this.friendlyTableName()).append(" Create Disposition is CREATE_NEVER and the table does\n           |not exists. Aborting the insert").toString())).stripMargin().replace('\n', ' '));
        }
        try {
            try {
                this.createTemporaryPathDeleter().map((Function1 & Serializable & scala.Serializable)x$1 -> {
                    BigQueryWriteHelper.$anonfun$writeDataFrameToBigQuery$3(x$1);
                    return BoxedUnit.UNIT;
                });
                String format = this.options().getIntermediateFormat().getDataSource();
                this.data().write().format(format).save(this.gcsPath().toString());
                this.loadDataToBigQuery();
                this.updateMetadataIfNeeded();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to write to BigQuery", e);
            }
        }
        finally {
            this.cleanTemporaryGcsPathIfNeeded();
        }
    }

    public void loadDataToBigQuery() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        LazyRef finishedJob$lzy = new LazyRef();
        FileSystem fs = this.gcsPath().getFileSystem(this.conf());
        List<String> sourceUris = SparkBigQueryUtil.optimizeLoadUriListForSpark((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ToIterator(fs.listFiles(this.gcsPath(), false)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getPath().toString()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)BigQueryWriteHelper.$anonfun$loadDataToBigQuery$2(this, x$3))).toList()).asJava());
        LoadJobConfiguration.Builder jobConfigurationBuilder = LoadJobConfiguration.newBuilder((TableId)this.options().getTableId(), sourceUris, (FormatOptions)this.options().getIntermediateFormat().getFormatOptions()).setCreateDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).setWriteDisposition(this.saveModeToWriteDisposition(this.saveMode())).setAutodetect(Predef$.MODULE$.boolean2Boolean(true));
        Object object = this.options().getCreateDisposition().isPresent() ? jobConfigurationBuilder.setCreateDisposition(this.options().getCreateDisposition().get()) : BoxedUnit.UNIT;
        if (this.options().getPartitionField().isPresent() || this.options().getPartitionType().isPresent()) {
            TimePartitioning.Builder timePartitionBuilder = TimePartitioning.newBuilder((TimePartitioning.Type)this.options().getPartitionTypeOrDefault());
            Object object2 = this.options().getPartitionExpirationMs().isPresent() ? timePartitionBuilder.setExpirationMs(Predef$.MODULE$.long2Long(this.options().getPartitionExpirationMs().getAsLong())) : BoxedUnit.UNIT;
            Object object3 = this.options().getPartitionRequireFilter().isPresent() ? timePartitionBuilder.setRequirePartitionFilter(this.options().getPartitionRequireFilter().get()) : BoxedUnit.UNIT;
            Object object4 = this.options().getPartitionField().isPresent() ? timePartitionBuilder.setField(this.options().getPartitionField().get()) : BoxedUnit.UNIT;
            boxedUnit2 = jobConfigurationBuilder.setTimePartitioning(timePartitionBuilder.build());
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.options().getClusteredFields().isPresent()) {
            Clustering clustering = Clustering.newBuilder().setFields((List)this.options().getClusteredFields().get()).build();
            boxedUnit = jobConfigurationBuilder.setClustering(clustering);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object5 = this.options().isUseAvroLogicalTypes() ? jobConfigurationBuilder.setUseAvroLogicalTypes(Predef$.MODULE$.boolean2Boolean(true)) : BoxedUnit.UNIT;
        Object object6 = !this.options().getLoadSchemaUpdateOptions().isEmpty() ? jobConfigurationBuilder.setSchemaUpdateOptions(this.options().getLoadSchemaUpdateOptions()) : BoxedUnit.UNIT;
        LoadJobConfiguration jobConfiguration = jobConfigurationBuilder.build();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Submitted load to ").append(this.options().getTableId()).append(". jobId: ").append(this.finishedJob$1(finishedJob$lzy, jobConfiguration).getJobId()).toString());
        try {
            if (this.finishedJob$1(finishedJob$lzy, jobConfiguration).getStatus().getError() != null) {
                throw new BigQueryException(0, new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(61).append("Failed to load to ").append(this.friendlyTableName()).append(" in job ").append(this.finishedJob$1(finishedJob$lzy, jobConfiguration).getJobId()).append(". BigQuery error\n             |was ").append(this.finishedJob$1(finishedJob$lzy, jobConfiguration).getStatus().getError().getMessage()).toString())).stripMargin().replace('\n', ' '), this.finishedJob$1(finishedJob$lzy, jobConfiguration).getStatus().getError());
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Done loading to ").append(this.friendlyTableName()).append(". jobId: ").append(this.finishedJob$1(finishedJob$lzy, jobConfiguration).getJobId()).toString());
        }
        catch (Exception e) {
            TimePartitioning.Type partitionType = this.options().getPartitionTypeOrDefault();
            if (e.getMessage().equals(new StringBuilder(44).append("Cannot output ").append(partitionType).append(" partitioned data in LegacySQL").toString())) {
                SparkBigQueryConfig.IntermediateFormat intermediateFormat = this.options().getIntermediateFormat();
                SparkBigQueryConfig.IntermediateFormat intermediateFormat2 = SparkBigQueryConfig.IntermediateFormat.PARQUET;
                if (!(intermediateFormat != null ? !((Object)((Object)intermediateFormat)).equals((Object)intermediateFormat2) : intermediateFormat2 != null)) {
                    throw new BigQueryException(0, new StringBuilder(178).append(partitionType).append(" time partitioning is not available ").append("for load jobs from PARQUET in this project yet. Please replace the intermediate ").append("format to AVRO or contact your account manager to enable this.").toString(), (Throwable)e);
                }
            }
            JobId jobId = this.finishedJob$1(finishedJob$lzy, jobConfiguration).getJobId();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Failed to load the data into BigQuery, JobId for debug purposes is ").append("[").append(jobId.getProject()).append(":").append(jobId.getLocation()).append(".").append(jobId.getJob()).append("]").toString());
            throw e;
        }
    }

    public JobInfo.WriteDisposition saveModeToWriteDisposition(SaveMode saveMode) {
        JobInfo.WriteDisposition writeDisposition;
        SaveMode saveMode2 = saveMode;
        if (SaveMode.Append.equals(saveMode2)) {
            writeDisposition = JobInfo.WriteDisposition.WRITE_APPEND;
        } else if (SaveMode.Overwrite.equals(saveMode2)) {
            writeDisposition = JobInfo.WriteDisposition.WRITE_TRUNCATE;
        } else {
            throw new UnsupportedOperationException(new StringBuilder(37).append("SaveMode ").append(saveMode2).append(" is currently not supported.").toString());
        }
        return writeDisposition;
    }

    public String friendlyTableName() {
        return BigQueryUtil.friendlyTableName(this.options().getTableId());
    }

    public void updateMetadataIfNeeded() {
        block0: {
            Map fieldsToUpdate = ((TraversableOnce)((TraversableLike)this.data().schema().filter((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)BigQueryWriteHelper.$anonfun$updateMetadataIfNeeded$1(field)))).map((Function1 & Serializable & scala.Serializable)field -> new Tuple2((Object)field.name(), field), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            if (fieldsToUpdate.isEmpty()) break block0;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("updating schema, found fields to update: ").append(fieldsToUpdate.keySet()).toString());
            TableInfo originalTableInfo = this.bigQueryClient().getTable(this.options().getTableIdWithoutThePartition());
            TableDefinition originalTableDefinition = originalTableInfo.getDefinition();
            Schema originalSchema = originalTableDefinition.getSchema();
            Schema updatedSchema = Schema.of((Iterable)((Iterable)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)originalSchema.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)field -> (Field)fieldsToUpdate.get((Object)field.getName()).map((Function1 & Serializable & scala.Serializable)dataField -> this.updatedField((Field)field, (StructField)dataField)).getOrElse((Function0 & Serializable & scala.Serializable)() -> field), Buffer$.MODULE$.canBuildFrom())).asJava()));
            TableInfo.Builder updatedTableInfo = originalTableInfo.toBuilder().setDefinition(originalTableDefinition.toBuilder().setSchema(updatedSchema).build());
            this.bigQueryClient().update(updatedTableInfo.build());
        }
    }

    public Field updatedField(Field field, StructField dataField) {
        Object object;
        Field.Builder newField = field.toBuilder();
        Optional<String> bqDescription = SchemaConverters.getDescriptionOrCommentOfField(dataField);
        if (bqDescription.isPresent()) {
            object = newField.setDescription(bqDescription.get());
        } else {
            String marker = SupportedCustomDataType.of(dataField.dataType()).get().getTypeMarker();
            String description = field.getDescription();
            object = description == null ? newField.setDescription(marker) : (!description.endsWith(marker) ? newField.setDescription(new StringBuilder(1).append(description).append(" ").append(marker).toString()) : BoxedUnit.UNIT);
        }
        return newField.build();
    }

    public void cleanTemporaryGcsPathIfNeeded() {
        this.createTemporaryPathDeleter().map((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.deletePath();
            return BoxedUnit.UNIT;
        });
    }

    private Option<IntermediateDataCleaner> createTemporaryPathDeleter() {
        return BigQueryUtilScala$.MODULE$.toOption(this.options().getTemporaryGcsBucket()).map((Function1 & Serializable & scala.Serializable)x$5 -> new IntermediateDataCleaner(this.gcsPath(), this.conf()));
    }

    public void verifySaveMode() {
        block3: {
            block2: {
                SaveMode saveMode = this.saveMode();
                SaveMode saveMode2 = SaveMode.ErrorIfExists;
                if (!(saveMode == null ? saveMode2 != null : !saveMode.equals(saveMode2))) break block2;
                SaveMode saveMode3 = this.saveMode();
                SaveMode saveMode4 = SaveMode.Ignore;
                if (saveMode3 != null ? !saveMode3.equals(saveMode4) : saveMode4 != null) break block3;
            }
            throw new UnsupportedOperationException(new StringBuilder(26).append("SaveMode ").append(this.saveMode()).append(" is not supported").toString());
        }
    }

    public BigQueryWriteHelper copy(BigQueryClient bigQueryClient, SQLContext sqlContext, SaveMode saveMode, SparkBigQueryConfig options, Dataset<Row> data, boolean tableExists) {
        return new BigQueryWriteHelper(bigQueryClient, sqlContext, saveMode, options, data, tableExists);
    }

    public BigQueryClient copy$default$1() {
        return this.bigQueryClient();
    }

    public SQLContext copy$default$2() {
        return this.sqlContext();
    }

    public SaveMode copy$default$3() {
        return this.saveMode();
    }

    public SparkBigQueryConfig copy$default$4() {
        return this.options();
    }

    public Dataset<Row> copy$default$5() {
        return this.data();
    }

    public boolean copy$default$6() {
        return this.tableExists();
    }

    public String productPrefix() {
        return "BigQueryWriteHelper";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.bigQueryClient();
                break;
            }
            case 1: {
                object = this.sqlContext();
                break;
            }
            case 2: {
                object = this.saveMode();
                break;
            }
            case 3: {
                object = this.options();
                break;
            }
            case 4: {
                object = this.data();
                break;
            }
            case 5: {
                object = BoxesRunTime.boxToBoolean((boolean)this.tableExists());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BigQueryWriteHelper;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.bigQueryClient()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sqlContext()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.saveMode()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.options()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.data()));
        n = Statics.mix((int)n, (int)(this.tableExists() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)6);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BigQueryWriteHelper)) return false;
        boolean bl = true;
        if (!bl) return false;
        BigQueryWriteHelper bigQueryWriteHelper = (BigQueryWriteHelper)x$1;
        BigQueryClient bigQueryClient = this.bigQueryClient();
        BigQueryClient bigQueryClient2 = bigQueryWriteHelper.bigQueryClient();
        if (bigQueryClient == null) {
            if (bigQueryClient2 != null) {
                return false;
            }
        } else if (!bigQueryClient.equals(bigQueryClient2)) return false;
        SQLContext sQLContext = this.sqlContext();
        SQLContext sQLContext2 = bigQueryWriteHelper.sqlContext();
        if (sQLContext == null) {
            if (sQLContext2 != null) {
                return false;
            }
        } else if (!sQLContext.equals(sQLContext2)) return false;
        SaveMode saveMode = this.saveMode();
        SaveMode saveMode2 = bigQueryWriteHelper.saveMode();
        if (saveMode == null) {
            if (saveMode2 != null) {
                return false;
            }
        } else if (!saveMode.equals(saveMode2)) return false;
        SparkBigQueryConfig sparkBigQueryConfig = this.options();
        SparkBigQueryConfig sparkBigQueryConfig2 = bigQueryWriteHelper.options();
        if (sparkBigQueryConfig == null) {
            if (sparkBigQueryConfig2 != null) {
                return false;
            }
        } else if (!sparkBigQueryConfig.equals(sparkBigQueryConfig2)) return false;
        Dataset<Row> dataset = this.data();
        Dataset<Row> dataset2 = bigQueryWriteHelper.data();
        if (dataset == null) {
            if (dataset2 != null) {
                return false;
            }
        } else if (!dataset.equals(dataset2)) return false;
        if (this.tableExists() != bigQueryWriteHelper.tableExists()) return false;
        if (!bigQueryWriteHelper.canEqual(this)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$writeDataFrameToBigQuery$1(BigQueryWriteHelper $this, JobInfo.CreateDisposition cd) {
        if ($this.tableExists()) return false;
        JobInfo.CreateDisposition createDisposition = cd;
        JobInfo.CreateDisposition createDisposition2 = JobInfo.CreateDisposition.CREATE_NEVER;
        if (createDisposition != null) {
            if (!createDisposition.equals(createDisposition2)) return false;
            return true;
        }
        if (createDisposition2 == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$writeDataFrameToBigQuery$3(IntermediateDataCleaner x$1) {
        Runtime.getRuntime().addShutdownHook(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$loadDataToBigQuery$2(BigQueryWriteHelper $this, String x$3) {
        return x$3.toLowerCase().endsWith(new StringBuilder(1).append(".").append($this.options().getIntermediateFormat().getFormatOptions().getType().toLowerCase()).toString());
    }

    private final /* synthetic */ Job finishedJob$lzycompute$1(LazyRef finishedJob$lzy$1, LoadJobConfiguration jobConfiguration$1) {
        Job job;
        LazyRef lazyRef = finishedJob$lzy$1;
        synchronized (lazyRef) {
            job = finishedJob$lzy$1.initialized() ? (Job)finishedJob$lzy$1.value() : (Job)finishedJob$lzy$1.initialize((Object)this.bigQueryClient().createAndWaitFor((JobConfiguration)jobConfiguration$1));
        }
        return job;
    }

    private final Job finishedJob$1(LazyRef finishedJob$lzy$1, LoadJobConfiguration jobConfiguration$1) {
        return finishedJob$lzy$1.initialized() ? (Job)finishedJob$lzy$1.value() : this.finishedJob$lzycompute$1(finishedJob$lzy$1, jobConfiguration$1);
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadataIfNeeded$1(StructField field) {
        return SupportedCustomDataType.of(field.dataType()).isPresent() || SchemaConverters.getDescriptionOrCommentOfField(field).isPresent();
    }

    /*
     * Unable to fully structure code
     */
    public BigQueryWriteHelper(BigQueryClient bigQueryClient, SQLContext sqlContext, SaveMode saveMode, SparkBigQueryConfig options, Dataset<Row> data, boolean tableExists) {
        this.bigQueryClient = bigQueryClient;
        this.sqlContext = sqlContext;
        this.saveMode = saveMode;
        this.options = options;
        this.data = data;
        this.tableExists = tableExists;
        super();
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        this.conf = sqlContext.sparkContext().hadoopConfiguration();
        needNewPath = true;
        gcsPath = null;
        applicationId = sqlContext.sparkContext().applicationId();
        uuid = UUID.randomUUID();
        while (needNewPath) {
            block6: {
                block5: {
                    temporaryGcsBucketOption = BigQueryUtilScala$.MODULE$.toOption(options.getTemporaryGcsBucket());
                    var14_14 = false;
                    var15_15 = null;
                    var16_16 = temporaryGcsBucketOption;
                    if (!(var16_16 instanceof Some)) break block5;
                    var17_17 = (Some)var16_16;
                    bucket = (String)var17_17.value();
                    var7_11 = new StringBuilder(23).append("gs://").append(bucket).append("/.spark-bigquery-").append(applicationId).append("-").append(uuid).toString();
                    break block6;
                }
                if (!None$.MODULE$.equals(var16_16)) ** GOTO lbl-1000
                var14_14 = true;
                var15_15 = var16_16;
                if (options.getPersistentGcsBucket().isPresent() && options.getPersistentGcsPath().isPresent()) {
                    var7_11 = new StringBuilder(6).append("gs://").append((Object)options.getPersistentGcsBucket().get()).append("/").append((Object)options.getPersistentGcsPath().get()).toString();
                } else if (var14_14 && options.getPersistentGcsBucket().isPresent()) {
                    var7_11 = new StringBuilder(23).append("gs://").append((Object)options.getPersistentGcsBucket().get()).append("/.spark-bigquery-").append(applicationId).append("-").append(uuid).toString();
                } else {
                    throw new IllegalArgumentException("Temporary or persistent GCS bucket must be informed.");
                }
            }
            gcsPathOption = var7_11;
            gcsPath = new Path(gcsPathOption);
            fs = gcsPath.getFileSystem(this.conf());
            needNewPath = fs.exists(gcsPath);
        }
        this.gcsPath = gcsPath;
    }
}

