/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.storage.v1beta2.ProtoRows;
import com.google.cloud.bigquery.storage.v1beta2.ProtoSchema;
import com.google.cloud.bigquery.storage.v1beta2.ProtoSchemaConverter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.util.ArrayList;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufUtils {
    static final Logger logger = LoggerFactory.getLogger(ProtobufUtils.class);
    private static final int MAX_BIGQUERY_NESTED_DEPTH = 15;
    private static final String RESERVED_NESTED_TYPE_NAME = "STRUCT";
    private static final String MAPTYPE_ERROR_MESSAGE = "MapType is unsupported.";

    public static ProtoSchema toProtoSchema(Schema schema) throws IllegalArgumentException {
        try {
            Descriptors.Descriptor descriptor = ProtobufUtils.toDescriptor(schema);
            ProtoSchema protoSchema = ProtoSchemaConverter.convert((Descriptors.Descriptor)descriptor);
            return protoSchema;
        }
        catch (Descriptors.DescriptorValidationException descriptorValidationException) {
            throw new IllegalArgumentException("Could not build Proto-Schema from Spark schema.", descriptorValidationException);
        }
    }

    private static Descriptors.Descriptor toDescriptor(Schema schema) throws Descriptors.DescriptorValidationException {
        DescriptorProtos.DescriptorProto.Builder builder = DescriptorProtos.DescriptorProto.newBuilder().setName("Schema");
        FieldList fieldList = schema.getFields();
        int n = 0;
        DescriptorProtos.DescriptorProto descriptorProto = ProtobufUtils.buildDescriptorProtoWithFields(builder, fieldList, n);
        return ProtobufUtils.createDescriptorFromProto(descriptorProto);
    }

    private static Descriptors.Descriptor createDescriptorFromProto(DescriptorProtos.DescriptorProto descriptorProto) throws Descriptors.DescriptorValidationException {
        DescriptorProtos.FileDescriptorProto fileDescriptorProto = DescriptorProtos.FileDescriptorProto.newBuilder().addMessageType(descriptorProto).build();
        Descriptors.Descriptor descriptor = (Descriptors.Descriptor)Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDescriptorProto, (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0]).getMessageTypes().get(0);
        return descriptor;
    }

    @VisibleForTesting
    protected static DescriptorProtos.DescriptorProto buildDescriptorProtoWithFields(DescriptorProtos.DescriptorProto.Builder builder, FieldList fieldList, int n) {
        Preconditions.checkArgument((n < 15 ? 1 : 0) != 0, (Object)"Tried to convert a BigQuery schema that exceeded BigQuery maximum nesting depth");
        int n2 = 1;
        for (Field field : fieldList) {
            Object object;
            String string = field.getName();
            DescriptorProtos.FieldDescriptorProto.Label label = ProtobufUtils.toProtoFieldLabel(field.getMode());
            FieldList fieldList2 = field.getSubFields();
            if (field.getType() == LegacySQLTypeName.RECORD) {
                object = RESERVED_NESTED_TYPE_NAME + n2;
                DescriptorProtos.DescriptorProto.Builder builder2 = builder.addNestedTypeBuilder();
                builder2.setName((String)object);
                DescriptorProtos.DescriptorProto descriptorProto = ProtobufUtils.buildDescriptorProtoWithFields(builder2, fieldList2, n + 1);
                builder.addField(ProtobufUtils.createProtoFieldBuilder(string, label, n2).setTypeName((String)object));
            } else {
                object = ProtobufUtils.toProtoFieldType(field.getType());
                builder.addField(ProtobufUtils.createProtoFieldBuilder(string, label, n2, object));
            }
            ++n2;
        }
        return builder.build();
    }

    private static DescriptorProtos.FieldDescriptorProto.Builder createProtoFieldBuilder(String string, DescriptorProtos.FieldDescriptorProto.Label label, int n) {
        return DescriptorProtos.FieldDescriptorProto.newBuilder().setName(string).setLabel(label).setNumber(n);
    }

    @VisibleForTesting
    protected static DescriptorProtos.FieldDescriptorProto.Builder createProtoFieldBuilder(String string, DescriptorProtos.FieldDescriptorProto.Label label, int n, DescriptorProtos.FieldDescriptorProto.Type type) {
        return ProtobufUtils.createProtoFieldBuilder(string, label, n).setType(type);
    }

    private static DescriptorProtos.FieldDescriptorProto.Label toProtoFieldLabel(Field.Mode mode) {
        switch (mode) {
            case NULLABLE: {
                return DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL;
            }
            case REPEATED: {
                return DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED;
            }
            case REQUIRED: {
                return DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED;
            }
        }
        throw new IllegalArgumentException("A BigQuery Field Mode was invalid: " + mode.name());
    }

    private static DescriptorProtos.FieldDescriptorProto.Type toProtoFieldType(LegacySQLTypeName legacySQLTypeName) {
        if (LegacySQLTypeName.INTEGER.equals((Object)legacySQLTypeName) || LegacySQLTypeName.DATE.equals((Object)legacySQLTypeName) || LegacySQLTypeName.DATETIME.equals((Object)legacySQLTypeName) || LegacySQLTypeName.TIMESTAMP.equals((Object)legacySQLTypeName)) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64;
        }
        if (LegacySQLTypeName.BOOLEAN.equals((Object)legacySQLTypeName)) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL;
        }
        if (LegacySQLTypeName.STRING.equals((Object)legacySQLTypeName)) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING;
        }
        if (LegacySQLTypeName.GEOGRAPHY.equals((Object)legacySQLTypeName) || LegacySQLTypeName.BYTES.equals((Object)legacySQLTypeName) || LegacySQLTypeName.NUMERIC.equals((Object)legacySQLTypeName)) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES;
        }
        if (LegacySQLTypeName.FLOAT.equals((Object)legacySQLTypeName)) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE;
        }
        if (LegacySQLTypeName.RECORD.equals((Object)legacySQLTypeName)) {
            throw new IllegalStateException("Program attempted to return an atomic data-type for a RECORD");
        }
        throw new IllegalArgumentException("Unexpected type: " + legacySQLTypeName.name());
    }

    public static ProtoRows toProtoRows(StructType structType, InternalRow[] internalRowArray) {
        try {
            Descriptors.Descriptor descriptor = ProtobufUtils.toDescriptor(structType);
            ProtoRows.Builder builder = ProtoRows.newBuilder();
            for (InternalRow internalRow : internalRowArray) {
                DynamicMessage dynamicMessage = ProtobufUtils.buildSingleRowMessage(structType, descriptor, internalRow);
                builder.addSerializedRows(dynamicMessage.toByteString());
            }
            return builder.build();
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not convert Internal Rows to Proto Rows.", exception);
        }
    }

    public static DynamicMessage buildSingleRowMessage(StructType structType, Descriptors.Descriptor descriptor, InternalRow internalRow) {
        DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
        for (int i = 0; i < descriptor.getFields().size(); ++i) {
            int n = i + 1;
            StructField structField = structType.fields()[i];
            DataType dataType = structField.dataType();
            Object object = internalRow.get(i, dataType);
            boolean bl = structField.nullable();
            Descriptors.Descriptor descriptor2 = descriptor.findNestedTypeByName(RESERVED_NESTED_TYPE_NAME + n);
            Object object2 = ProtobufUtils.convertToProtoRowValue(dataType, object, bl, descriptor2);
            logger.debug("Converted value {} to proto-value: {}", object, object2);
            if (object2 == null) continue;
            builder.setField(descriptor.findFieldByNumber(n), object2);
        }
        return builder.build();
    }

    public static Descriptors.Descriptor toDescriptor(StructType structType) throws Descriptors.DescriptorValidationException {
        DescriptorProtos.DescriptorProto.Builder builder = DescriptorProtos.DescriptorProto.newBuilder().setName("Schema");
        int n = 0;
        DescriptorProtos.DescriptorProto descriptorProto = ProtobufUtils.buildDescriptorProtoWithFields(builder, structType.fields(), n);
        return ProtobufUtils.createDescriptorFromProto(descriptorProto);
    }

    private static Object convertToProtoRowValue(DataType dataType, Object object, boolean bl, Descriptors.Descriptor descriptor) {
        logger.debug("Converting type: {}", (Object)dataType.json());
        if (object == null) {
            if (!bl) {
                throw new IllegalArgumentException("Non-nullable field was null.");
            }
            return null;
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType dataType2 = arrayType.elementType();
            Object[] objectArray = ((ArrayData)object).toObjectArray(dataType2);
            boolean bl2 = arrayType.containsNull();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Object object2 : objectArray) {
                Object object3 = ProtobufUtils.convertToProtoRowValue(dataType2, object2, bl2, descriptor);
                if (object3 == null) continue;
                arrayList.add(object3);
            }
            return arrayList;
        }
        if (dataType instanceof StructType) {
            return ProtobufUtils.buildSingleRowMessage((StructType)dataType, descriptor, (InternalRow)object);
        }
        if (dataType instanceof ByteType || dataType instanceof ShortType || dataType instanceof IntegerType || dataType instanceof LongType || dataType instanceof TimestampType || dataType instanceof DateType) {
            return ((Number)object).longValue();
        }
        if (dataType instanceof FloatType || dataType instanceof DoubleType) {
            return ((Number)object).doubleValue();
        }
        if (dataType instanceof DecimalType) {
            return ((Decimal)object).toDouble();
        }
        if (dataType instanceof BooleanType || dataType instanceof BinaryType) {
            return object;
        }
        if (dataType instanceof StringType) {
            return new String(((UTF8String)object).getBytes());
        }
        if (dataType instanceof MapType) {
            throw new IllegalArgumentException(MAPTYPE_ERROR_MESSAGE);
        }
        throw new IllegalStateException("Unexpected type: " + dataType);
    }

    private static DescriptorProtos.DescriptorProto buildDescriptorProtoWithFields(DescriptorProtos.DescriptorProto.Builder builder, StructField[] structFieldArray, int n) {
        Preconditions.checkArgument((n < 15 ? 1 : 0) != 0, (Object)"Spark Schema exceeds BigQuery maximum nesting depth.");
        int n2 = 1;
        for (StructField structField : structFieldArray) {
            StructType structType;
            ArrayType arrayType;
            String string = structField.name();
            DescriptorProtos.FieldDescriptorProto.Label label = structField.nullable() ? DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL : DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED;
            DataType dataType = structField.dataType();
            if (dataType instanceof ArrayType) {
                arrayType = (ArrayType)dataType;
                dataType = arrayType.elementType();
                label = DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED;
            }
            if (dataType instanceof StructType) {
                structType = (StructType)dataType;
                String string2 = RESERVED_NESTED_TYPE_NAME + n2;
                StructField[] structFieldArray2 = structType.fields();
                DescriptorProtos.DescriptorProto.Builder builder2 = builder.addNestedTypeBuilder().setName(string2);
                ProtobufUtils.buildDescriptorProtoWithFields(builder2, structFieldArray2, n + 1);
                arrayType = ProtobufUtils.createProtoFieldBuilder(string, label, n2).setTypeName(string2);
            } else {
                structType = ProtobufUtils.sparkAtomicTypeToProtoFieldType(dataType);
                arrayType = ProtobufUtils.createProtoFieldBuilder(string, label, n2, (DescriptorProtos.FieldDescriptorProto.Type)structType);
            }
            builder.addField((DescriptorProtos.FieldDescriptorProto.Builder)arrayType);
            ++n2;
        }
        return builder.build();
    }

    private static DescriptorProtos.FieldDescriptorProto.Type sparkAtomicTypeToProtoFieldType(DataType dataType) {
        if (dataType instanceof ByteType || dataType instanceof ShortType || dataType instanceof IntegerType || dataType instanceof LongType || dataType instanceof TimestampType || dataType instanceof DateType) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64;
        }
        if (dataType instanceof FloatType || dataType instanceof DoubleType || dataType instanceof DecimalType) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE;
        }
        if (dataType instanceof BooleanType) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL;
        }
        if (dataType instanceof BinaryType) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES;
        }
        if (dataType instanceof StringType) {
            return DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING;
        }
        if (dataType instanceof MapType) {
            throw new IllegalArgumentException(MAPTYPE_ERROR_MESSAGE);
        }
        throw new IllegalStateException("Unexpected type: " + dataType);
    }
}

