/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.spark.bigquery.ArrowBinaryIterator;
import com.google.cloud.spark.bigquery.AvroBinaryIterator;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.avro.Schema;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;

public interface ReadRowsResponseToInternalRowIteratorConverter {
    public static ReadRowsResponseToInternalRowIteratorConverter avro(Schema schema, List<String> list, String string, Optional<StructType> optional) {
        return new Avro(schema, list, string, (com.google.common.base.Optional<StructType>)com.google.common.base.Optional.fromJavaUtil(optional));
    }

    public static ReadRowsResponseToInternalRowIteratorConverter arrow(List<String> list, ByteString byteString, Optional<StructType> optional) {
        return new Arrow(list, byteString, (com.google.common.base.Optional<StructType>)com.google.common.base.Optional.fromJavaUtil(optional));
    }

    public Iterator<InternalRow> convert(ReadRowsResponse var1);

    public static class Arrow
    implements ReadRowsResponseToInternalRowIteratorConverter,
    Serializable {
        private final List<String> columnsInOrder;
        private final ByteString arrowSchema;
        private final com.google.common.base.Optional<StructType> userProvidedSchema;

        public Arrow(List<String> list, ByteString byteString, com.google.common.base.Optional<StructType> optional) {
            this.columnsInOrder = list;
            this.arrowSchema = byteString;
            this.userProvidedSchema = optional;
        }

        @Override
        public Iterator<InternalRow> convert(ReadRowsResponse readRowsResponse) {
            return new ArrowBinaryIterator(this.columnsInOrder, this.arrowSchema, readRowsResponse.getArrowRecordBatch().getSerializedRecordBatch(), this.userProvidedSchema.toJavaUtil());
        }
    }

    public static class Avro
    implements ReadRowsResponseToInternalRowIteratorConverter,
    Serializable {
        private final Schema bqSchema;
        private final List<String> columnsInOrder;
        private final String rawAvroSchema;
        private final com.google.common.base.Optional<StructType> userProvidedSchema;

        public Avro(Schema schema, List<String> list, String string, com.google.common.base.Optional<StructType> optional) {
            this.bqSchema = schema;
            this.columnsInOrder = list;
            this.rawAvroSchema = string;
            this.userProvidedSchema = optional;
        }

        @Override
        public Iterator<InternalRow> convert(ReadRowsResponse readRowsResponse) {
            return new AvroBinaryIterator(this.bqSchema, this.columnsInOrder, new Schema.Parser().parse(this.rawAvroSchema), readRowsResponse.getAvroRows().getSerializedBinaryRows(), this.userProvidedSchema.toJavaUtil());
        }
    }
}

