/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.api.gax.retrying.RetrySettings;
import com.google.auth.Credentials;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.bigquery.connector.common.BigQueryConfig;
import com.google.cloud.bigquery.connector.common.BigQueryCredentialsSupplier;
import com.google.cloud.bigquery.connector.common.BigQueryProxyConfig;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.bigquery.connector.common.ReadSessionCreatorConfig;
import com.google.cloud.bigquery.connector.common.ReadSessionCreatorConfigBuilder;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.cloud.spark.bigquery.SparkBigQueryProxyAndHttpConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructType;
import org.threeten.bp.Duration;
import scala.util.Properties;

public class SparkBigQueryConfig
implements BigQueryConfig,
Serializable {
    public static final String VIEWS_ENABLED_OPTION = "viewsEnabled";
    public static final String USE_AVRO_LOGICAL_TYPES_OPTION = "useAvroLogicalTypes";
    public static final String DATE_PARTITION_PARAM = "datePartition";
    public static final String VALIDATE_SPARK_AVRO_PARAM = "validateSparkAvroInternalParam";
    public static final String INTERMEDIATE_FORMAT_OPTION = "intermediateFormat";
    public static final int DEFAULT_MATERIALIZATION_EXPRIRATION_TIME_IN_MINUTES = 1440;
    @VisibleForTesting
    static final DataFormat DEFAULT_READ_DATA_FORMAT = DataFormat.ARROW;
    @VisibleForTesting
    static final IntermediateFormat DEFAULT_INTERMEDIATE_FORMAT = IntermediateFormat.PARQUET;
    static final String GCS_CONFIG_CREDENTIALS_FILE_PROPERTY = "google.cloud.auth.service.account.json.keyfile";
    static final String GCS_CONFIG_PROJECT_ID_PROPERTY = "fs.gs.project.id";
    private static final String READ_DATA_FORMAT_OPTION = "readDataFormat";
    private static final ImmutableList<String> PERMITTED_READ_DATA_FORMATS = ImmutableList.of((Object)DataFormat.ARROW.toString(), (Object)DataFormat.AVRO.toString());
    private static final Supplier<com.google.common.base.Optional<String>> DEFAULT_FALLBACK = () -> SparkBigQueryConfig.empty();
    private static final String CONF_PREFIX = "spark.datasource.bigquery.";
    private static final int DEFAULT_BIGQUERY_CLIENT_CONNECT_TIMEOUT = 60000;
    private static final int DEFAULT_BIGQUERY_CLIENT_READ_TIMEOUT = 60000;
    private static final Pattern LOWERCASE_QUERY_PATTERN = Pattern.compile("^(select|with)\\s+.*$");
    public static final int MIN_BUFFERED_RESPONSES_PER_STREAM = 1;
    public static final int MIN_STREAMS_PER_PARTITION = 1;
    private static final int DEFAULT_BIGQUERY_CLIENT_RETRIES = 10;
    TableId tableId;
    com.google.common.base.Optional<String> query = SparkBigQueryConfig.empty();
    String parentProjectId;
    com.google.common.base.Optional<String> credentialsKey;
    com.google.common.base.Optional<String> credentialsFile;
    com.google.common.base.Optional<String> accessToken;
    com.google.common.base.Optional<String> filter = SparkBigQueryConfig.empty();
    com.google.common.base.Optional<StructType> schema = SparkBigQueryConfig.empty();
    Integer maxParallelism = null;
    int defaultParallelism = 1;
    com.google.common.base.Optional<String> temporaryGcsBucket = SparkBigQueryConfig.empty();
    com.google.common.base.Optional<String> persistentGcsBucket = SparkBigQueryConfig.empty();
    com.google.common.base.Optional<String> persistentGcsPath = SparkBigQueryConfig.empty();
    IntermediateFormat intermediateFormat = DEFAULT_INTERMEDIATE_FORMAT;
    DataFormat readDataFormat = DEFAULT_READ_DATA_FORMAT;
    boolean combinePushedDownFilters = true;
    boolean viewsEnabled = false;
    com.google.common.base.Optional<String> materializationProject = SparkBigQueryConfig.empty();
    com.google.common.base.Optional<String> materializationDataset = SparkBigQueryConfig.empty();
    com.google.common.base.Optional<String> partitionField = SparkBigQueryConfig.empty();
    Long partitionExpirationMs = null;
    com.google.common.base.Optional<Boolean> partitionRequireFilter = SparkBigQueryConfig.empty();
    com.google.common.base.Optional<TimePartitioning.Type> partitionType = SparkBigQueryConfig.empty();
    com.google.common.base.Optional<String[]> clusteredFields = SparkBigQueryConfig.empty();
    com.google.common.base.Optional<JobInfo.CreateDisposition> createDisposition = SparkBigQueryConfig.empty();
    boolean optimizedEmptyProjection = true;
    boolean useAvroLogicalTypes = false;
    ImmutableList<JobInfo.SchemaUpdateOption> loadSchemaUpdateOptions = ImmutableList.of();
    int materializationExpirationTimeInMinutes = 1440;
    int maxReadRowsRetries = 3;
    boolean pushAllFilters = true;
    private com.google.common.base.Optional<String> encodedCreateReadSessionRequest = SparkBigQueryConfig.empty();
    private com.google.common.base.Optional<String> storageReadEndpoint = SparkBigQueryConfig.empty();
    private int numBackgroundThreadsPerStream = 0;
    private int numPrebufferReadRowsResponses = 1;
    private int numStreamsPerPartition = 1;
    private SparkBigQueryProxyAndHttpConfig sparkBigQueryProxyAndHttpConfig;

    @VisibleForTesting
    SparkBigQueryConfig() {
    }

    @VisibleForTesting
    public static SparkBigQueryConfig from(Map<String, String> map, ImmutableMap<String, String> immutableMap, Configuration configuration, int n, SQLConf sQLConf, String string3, Optional<StructType> optional) {
        SparkBigQueryConfig sparkBigQueryConfig = new SparkBigQueryConfig();
        ImmutableMap<String, String> immutableMap2 = SparkBigQueryConfig.normalizeConf(immutableMap);
        sparkBigQueryConfig.sparkBigQueryProxyAndHttpConfig = SparkBigQueryProxyAndHttpConfig.from(map, immutableMap2, configuration);
        sparkBigQueryConfig.viewsEnabled = SparkBigQueryConfig.getAnyBooleanOption(immutableMap2, map, VIEWS_ENABLED_OPTION, false);
        sparkBigQueryConfig.materializationProject = SparkBigQueryConfig.getAnyOption(immutableMap2, map, (Collection<String>)ImmutableList.of((Object)"materializationProject", (Object)"viewMaterializationProject"));
        sparkBigQueryConfig.materializationDataset = SparkBigQueryConfig.getAnyOption(immutableMap2, map, (Collection<String>)ImmutableList.of((Object)"materializationDataset", (Object)"viewMaterializationDataset"));
        sparkBigQueryConfig.materializationExpirationTimeInMinutes = (Integer)SparkBigQueryConfig.getAnyOption(immutableMap2, map, "materializationExpirationTimeInMinutes").transform(Integer::parseInt).or((Object)1440);
        if (sparkBigQueryConfig.materializationExpirationTimeInMinutes < 1) {
            throw new IllegalArgumentException("materializationExpirationTimeInMinutes must have a positive value, the configured value is " + sparkBigQueryConfig.materializationExpirationTimeInMinutes);
        }
        Optional optional2 = SparkBigQueryConfig.getOptionFromMultipleParams(map, (Collection<String>)ImmutableList.of((Object)"table", (Object)"path"), DEFAULT_FALLBACK).toJavaUtil();
        Optional optional3 = SparkBigQueryConfig.getOption(map, "dataset").or(sparkBigQueryConfig.materializationDataset).toJavaUtil();
        Optional<String> optional4 = BigQueryUtil.firstPresent(SparkBigQueryConfig.getOption(map, "project").toJavaUtil(), com.google.common.base.Optional.fromNullable((Object)configuration.get(GCS_CONFIG_PROJECT_ID_PROPERTY)).toJavaUtil());
        sparkBigQueryConfig.partitionType = SparkBigQueryConfig.getOption(map, "partitionType").transform(TimePartitioning.Type::valueOf);
        Optional optional5 = SparkBigQueryConfig.getOption(map, DATE_PARTITION_PARAM).toJavaUtil();
        optional5.ifPresent(string -> SparkBigQueryConfig.validateDateFormat(string, sparkBigQueryConfig.getPartitionTypeOrDefault(), DATE_PARTITION_PARAM));
        if (optional2.isPresent()) {
            String string4 = ((String)optional2.get()).trim().replaceAll("\\s+", " ");
            if (SparkBigQueryConfig.isQuery(string4)) {
                sparkBigQueryConfig.query = com.google.common.base.Optional.of((Object)string4);
                sparkBigQueryConfig.tableId = BigQueryUtil.parseTableId("QUERY", optional3, optional4, optional5);
            } else {
                sparkBigQueryConfig.tableId = BigQueryUtil.parseTableId(string4, optional3, optional4, optional5);
            }
        } else {
            sparkBigQueryConfig.query = SparkBigQueryConfig.getOption(map, "query").transform(String::trim);
            if (sparkBigQueryConfig.query.isPresent()) {
                sparkBigQueryConfig.tableId = BigQueryUtil.parseTableId("QUERY", optional3, optional4, optional5);
            } else {
                throw new IllegalArgumentException("No table has been specified");
            }
        }
        sparkBigQueryConfig.parentProjectId = (String)SparkBigQueryConfig.getAnyOption(immutableMap2, map, "parentProject").or(SparkBigQueryConfig.defaultBilledProject());
        sparkBigQueryConfig.credentialsKey = SparkBigQueryConfig.getAnyOption(immutableMap2, map, "credentials");
        sparkBigQueryConfig.credentialsFile = SparkBigQueryConfig.fromJavaUtil(BigQueryUtil.firstPresent(SparkBigQueryConfig.getAnyOption(immutableMap2, map, "credentialsFile").toJavaUtil(), com.google.common.base.Optional.fromNullable((Object)configuration.get(GCS_CONFIG_CREDENTIALS_FILE_PROPERTY)).toJavaUtil()));
        sparkBigQueryConfig.accessToken = SparkBigQueryConfig.getAnyOption(immutableMap2, map, "gcpAccessToken");
        sparkBigQueryConfig.filter = SparkBigQueryConfig.getOption(map, "filter");
        sparkBigQueryConfig.schema = SparkBigQueryConfig.fromJavaUtil(optional);
        sparkBigQueryConfig.maxParallelism = (Integer)SparkBigQueryConfig.getOptionFromMultipleParams(map, (Collection<String>)ImmutableList.of((Object)"maxParallelism", (Object)"parallelism"), DEFAULT_FALLBACK).transform(Integer::valueOf).orNull();
        sparkBigQueryConfig.defaultParallelism = n;
        sparkBigQueryConfig.temporaryGcsBucket = SparkBigQueryConfig.getAnyOption(immutableMap2, map, "temporaryGcsBucket");
        sparkBigQueryConfig.persistentGcsBucket = SparkBigQueryConfig.getAnyOption(immutableMap2, map, "persistentGcsBucket");
        sparkBigQueryConfig.persistentGcsPath = SparkBigQueryConfig.getOption(map, "persistentGcsPath");
        boolean bl = Boolean.valueOf(SparkBigQueryConfig.getRequiredOption(map, VALIDATE_SPARK_AVRO_PARAM, (com.google.common.base.Supplier<String>)((com.google.common.base.Supplier)() -> "true")));
        sparkBigQueryConfig.intermediateFormat = (IntermediateFormat)((Object)SparkBigQueryConfig.getAnyOption(immutableMap2, map, INTERMEDIATE_FORMAT_OPTION).transform(String::toLowerCase).transform(string2 -> IntermediateFormat.from(string2, string3, sQLConf, bl)).or((Object)DEFAULT_INTERMEDIATE_FORMAT));
        String string5 = (String)SparkBigQueryConfig.getAnyOption(immutableMap2, map, READ_DATA_FORMAT_OPTION).transform(String::toUpperCase).or((Object)DEFAULT_READ_DATA_FORMAT.toString());
        if (!PERMITTED_READ_DATA_FORMATS.contains((Object)string5)) {
            throw new IllegalArgumentException(String.format("Data read format '%s' is not supported. Supported formats are '%s'", string5, String.join((CharSequence)",", PERMITTED_READ_DATA_FORMATS)));
        }
        sparkBigQueryConfig.useAvroLogicalTypes = SparkBigQueryConfig.getAnyBooleanOption(immutableMap2, map, USE_AVRO_LOGICAL_TYPES_OPTION, false);
        sparkBigQueryConfig.readDataFormat = DataFormat.valueOf((String)string5);
        sparkBigQueryConfig.combinePushedDownFilters = SparkBigQueryConfig.getAnyBooleanOption(immutableMap2, map, "combinePushedDownFilters", true);
        sparkBigQueryConfig.partitionField = SparkBigQueryConfig.getOption(map, "partitionField");
        sparkBigQueryConfig.partitionExpirationMs = (Long)SparkBigQueryConfig.getOption(map, "partitionExpirationMs").transform(Long::valueOf).orNull();
        sparkBigQueryConfig.partitionRequireFilter = SparkBigQueryConfig.getOption(map, "partitionRequireFilter").transform(Boolean::valueOf);
        sparkBigQueryConfig.clusteredFields = SparkBigQueryConfig.getOption(map, "clusteredFields").transform(string -> string.split(","));
        sparkBigQueryConfig.createDisposition = SparkBigQueryConfig.getOption(map, "createDisposition").transform(String::toUpperCase).transform(JobInfo.CreateDisposition::valueOf);
        sparkBigQueryConfig.optimizedEmptyProjection = SparkBigQueryConfig.getAnyBooleanOption(immutableMap2, map, "optimizedEmptyProjection", true);
        boolean bl2 = SparkBigQueryConfig.getAnyBooleanOption(immutableMap2, map, "allowFieldAddition", false);
        boolean bl3 = SparkBigQueryConfig.getAnyBooleanOption(immutableMap2, map, "allowFieldRelaxation", false);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (bl2) {
            builder.add((Object)JobInfo.SchemaUpdateOption.ALLOW_FIELD_ADDITION);
        }
        if (bl3) {
            builder.add((Object)JobInfo.SchemaUpdateOption.ALLOW_FIELD_RELAXATION);
        }
        sparkBigQueryConfig.loadSchemaUpdateOptions = builder.build();
        sparkBigQueryConfig.storageReadEndpoint = SparkBigQueryConfig.getAnyOption(immutableMap2, map, "bqStorageReadEndpoint");
        sparkBigQueryConfig.encodedCreateReadSessionRequest = SparkBigQueryConfig.getAnyOption(immutableMap2, map, "bqEncodedCreateReadSessionRequest");
        sparkBigQueryConfig.numBackgroundThreadsPerStream = (Integer)SparkBigQueryConfig.getAnyOption(immutableMap2, map, "bqBackgroundThreadsPerStream").transform(Integer::parseInt).or((Object)0);
        sparkBigQueryConfig.pushAllFilters = SparkBigQueryConfig.getAnyBooleanOption(immutableMap2, map, "pushAllFilters", true);
        sparkBigQueryConfig.numPrebufferReadRowsResponses = (Integer)SparkBigQueryConfig.getAnyOption(immutableMap2, map, "bqPrebufferResponsesPerStream").transform(Integer::parseInt).or((Object)1);
        sparkBigQueryConfig.numStreamsPerPartition = (Integer)SparkBigQueryConfig.getAnyOption(immutableMap2, map, "bqNumStreamsPerPartition").transform(Integer::parseInt).or((Object)1);
        return sparkBigQueryConfig;
    }

    @VisibleForTesting
    static boolean isQuery(String string) {
        String string2 = string.toLowerCase().replace('\n', ' ');
        return LOWERCASE_QUERY_PATTERN.matcher(string2).matches();
    }

    private static void validateDateFormat(String string, TimePartitioning.Type type, String string2) {
        try {
            ImmutableMap immutableMap = ImmutableMap.of((Object)TimePartitioning.Type.HOUR, (Object)DateTimeFormatter.ofPattern("yyyyMMddHH"), (Object)TimePartitioning.Type.DAY, (Object)DateTimeFormatter.BASIC_ISO_DATE, (Object)TimePartitioning.Type.MONTH, (Object)DateTimeFormatter.ofPattern("yyyyMM"), (Object)TimePartitioning.Type.YEAR, (Object)DateTimeFormatter.ofPattern("yyyy"));
            DateTimeFormatter dateTimeFormatter = (DateTimeFormatter)immutableMap.get(type);
            dateTimeFormatter.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new IllegalArgumentException(String.format("Invalid argument for option %s, format is YYYYMMDD", string2));
        }
    }

    private static com.google.common.base.Supplier<String> defaultBilledProject() {
        return () -> BigQueryOptions.getDefaultInstance().getProjectId();
    }

    private static String getRequiredOption(Map<String, String> map, String string) {
        return (String)SparkBigQueryConfig.getOption(map, string, DEFAULT_FALLBACK).toJavaUtil().orElseThrow(() -> new IllegalArgumentException(String.format("Option %s required.", string)));
    }

    private static String getRequiredOption(Map<String, String> map, String string, com.google.common.base.Supplier<String> supplier) {
        return (String)SparkBigQueryConfig.getOption(map, string, DEFAULT_FALLBACK).or(supplier);
    }

    private static com.google.common.base.Optional<String> getOption(Map<String, String> map, String string) {
        return SparkBigQueryConfig.getOption(map, string, DEFAULT_FALLBACK);
    }

    private static com.google.common.base.Optional<String> getOption(Map<String, String> map, String string, Supplier<com.google.common.base.Optional<String>> supplier) {
        return SparkBigQueryConfig.fromJavaUtil(BigQueryUtil.firstPresent(Optional.ofNullable(map.get(string.toLowerCase())), supplier.get().toJavaUtil()));
    }

    private static com.google.common.base.Optional<String> getOptionFromMultipleParams(Map<String, String> map, Collection<String> collection, Supplier<com.google.common.base.Optional<String>> supplier) {
        return collection.stream().map(string -> SparkBigQueryConfig.getOption(map, string)).filter(com.google.common.base.Optional::isPresent).findFirst().orElseGet(supplier);
    }

    private static com.google.common.base.Optional<String> getAnyOption(ImmutableMap<String, String> immutableMap, Map<String, String> map, String string) {
        return com.google.common.base.Optional.fromNullable((Object)map.get(string.toLowerCase())).or(com.google.common.base.Optional.fromNullable((Object)immutableMap.get((Object)string)));
    }

    private static com.google.common.base.Optional<String> getAnyOption(ImmutableMap<String, String> immutableMap, Map<String, String> map, Collection<String> collection) {
        return collection.stream().map(string -> SparkBigQueryConfig.getAnyOption(immutableMap, map, string)).filter(optional -> optional.isPresent()).findFirst().orElse(SparkBigQueryConfig.empty());
    }

    private static boolean getAnyBooleanOption(ImmutableMap<String, String> immutableMap, Map<String, String> map, String string, boolean bl) {
        return (Boolean)SparkBigQueryConfig.getAnyOption(immutableMap, map, string).transform(Boolean::valueOf).or((Object)bl);
    }

    static ImmutableMap<String, String> normalizeConf(Map<String, String> map) {
        Map<String, String> map2 = map.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(CONF_PREFIX)).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring(CONF_PREFIX.length()), entry -> (String)entry.getValue()));
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        hashMap.putAll(map2);
        return ImmutableMap.copyOf(hashMap);
    }

    private static com.google.common.base.Optional empty() {
        return com.google.common.base.Optional.absent();
    }

    private static com.google.common.base.Optional fromJavaUtil(Optional optional) {
        return com.google.common.base.Optional.fromJavaUtil((Optional)optional);
    }

    public Credentials createCredentials() {
        return new BigQueryCredentialsSupplier(this.accessToken.toJavaUtil(), this.credentialsKey.toJavaUtil(), this.credentialsFile.toJavaUtil(), this.sparkBigQueryProxyAndHttpConfig.getProxyUri(), this.sparkBigQueryProxyAndHttpConfig.getProxyUsername(), this.sparkBigQueryProxyAndHttpConfig.getProxyPassword()).getCredentials();
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public TableId getTableIdWithoutThePartition() {
        String string = this.tableId.getTable();
        if (!string.contains("$")) {
            return this.tableId;
        }
        String string2 = string.substring(0, string.indexOf(36));
        return this.tableId.getProject() != null ? TableId.of((String)this.tableId.getProject(), (String)this.tableId.getDataset(), (String)string2) : TableId.of((String)this.tableId.getDataset(), (String)string2);
    }

    public Optional<String> getQuery() {
        return this.query.toJavaUtil();
    }

    @Override
    public String getParentProjectId() {
        return this.parentProjectId;
    }

    @Override
    public Optional<String> getCredentialsKey() {
        return this.credentialsKey.toJavaUtil();
    }

    @Override
    public Optional<String> getCredentialsFile() {
        return this.credentialsFile.toJavaUtil();
    }

    @Override
    public Optional<String> getAccessToken() {
        return this.accessToken.toJavaUtil();
    }

    public Optional<String> getFilter() {
        return this.filter.toJavaUtil();
    }

    public Optional<StructType> getSchema() {
        return this.schema.toJavaUtil();
    }

    public OptionalInt getMaxParallelism() {
        return this.maxParallelism == null ? OptionalInt.empty() : OptionalInt.of(this.maxParallelism);
    }

    public int getDefaultParallelism() {
        return this.defaultParallelism;
    }

    public Optional<String> getTemporaryGcsBucket() {
        return this.temporaryGcsBucket.toJavaUtil();
    }

    public Optional<String> getPersistentGcsBucket() {
        return this.persistentGcsBucket.toJavaUtil();
    }

    public Optional<String> getPersistentGcsPath() {
        return this.persistentGcsPath.toJavaUtil();
    }

    public IntermediateFormat getIntermediateFormat() {
        return this.intermediateFormat;
    }

    public DataFormat getReadDataFormat() {
        return this.readDataFormat;
    }

    public boolean isCombinePushedDownFilters() {
        return this.combinePushedDownFilters;
    }

    public boolean isUseAvroLogicalTypes() {
        return this.useAvroLogicalTypes;
    }

    @Override
    public boolean isViewsEnabled() {
        return this.viewsEnabled;
    }

    @Override
    public Optional<String> getMaterializationProject() {
        return this.materializationProject.toJavaUtil();
    }

    @Override
    public Optional<String> getMaterializationDataset() {
        return this.materializationDataset.toJavaUtil();
    }

    public Optional<String> getPartitionField() {
        return this.partitionField.toJavaUtil();
    }

    public OptionalLong getPartitionExpirationMs() {
        return this.partitionExpirationMs == null ? OptionalLong.empty() : OptionalLong.of(this.partitionExpirationMs);
    }

    public Optional<Boolean> getPartitionRequireFilter() {
        return this.partitionRequireFilter.toJavaUtil();
    }

    public Optional<TimePartitioning.Type> getPartitionType() {
        return this.partitionType.toJavaUtil();
    }

    public TimePartitioning.Type getPartitionTypeOrDefault() {
        return (TimePartitioning.Type)this.partitionType.or((Object)TimePartitioning.Type.DAY);
    }

    public Optional<ImmutableList<String>> getClusteredFields() {
        return this.clusteredFields.transform(stringArray -> ImmutableList.copyOf((Object[])stringArray)).toJavaUtil();
    }

    public Optional<JobInfo.CreateDisposition> getCreateDisposition() {
        return this.createDisposition.toJavaUtil();
    }

    public boolean isOptimizedEmptyProjection() {
        return this.optimizedEmptyProjection;
    }

    public ImmutableList<JobInfo.SchemaUpdateOption> getLoadSchemaUpdateOptions() {
        return this.loadSchemaUpdateOptions;
    }

    public int getMaterializationExpirationTimeInMinutes() {
        return this.materializationExpirationTimeInMinutes;
    }

    public int getMaxReadRowsRetries() {
        return this.maxReadRowsRetries;
    }

    public boolean getPushAllFilters() {
        return this.pushAllFilters;
    }

    @Override
    public int getBigQueryClientConnectTimeout() {
        return this.sparkBigQueryProxyAndHttpConfig.getHttpConnectTimeout().orElse(60000);
    }

    @Override
    public int getBigQueryClientReadTimeout() {
        return this.sparkBigQueryProxyAndHttpConfig.getHttpReadTimeout().orElse(60000);
    }

    @Override
    public BigQueryProxyConfig getBigQueryProxyConfig() {
        return this.sparkBigQueryProxyAndHttpConfig;
    }

    @Override
    public RetrySettings getBigQueryClientRetrySettings() {
        return RetrySettings.newBuilder().setMaxAttempts(this.sparkBigQueryProxyAndHttpConfig.getHttpMaxRetry().orElse(10).intValue()).setTotalTimeout(Duration.ofMinutes((long)10L)).setInitialRpcTimeout(Duration.ofSeconds((long)60L)).setMaxRpcTimeout(Duration.ofMinutes((long)5L)).setRpcTimeoutMultiplier(1.6).setRetryDelayMultiplier(1.6).setInitialRetryDelay(Duration.ofMillis((long)1250L)).setMaxRetryDelay(Duration.ofSeconds((long)5L)).build();
    }

    public ReadSessionCreatorConfig toReadSessionCreatorConfig() {
        return new ReadSessionCreatorConfigBuilder().setViewsEnabled(this.viewsEnabled).setMaterializationProject(this.materializationProject.toJavaUtil()).setMaterializationDataset(this.materializationDataset.toJavaUtil()).setMaterializationExpirationTimeInMinutes(this.materializationExpirationTimeInMinutes).setReadDataFormat(this.readDataFormat).setMaxReadRowsRetries(this.maxReadRowsRetries).setViewEnabledParamName(VIEWS_ENABLED_OPTION).setDefaultParallelism(this.defaultParallelism).setMaxParallelism(this.getMaxParallelism()).setRequestEncodedBase(this.encodedCreateReadSessionRequest.toJavaUtil()).setEndpoint(this.storageReadEndpoint.toJavaUtil()).setBackgroundParsingThreads(this.numBackgroundThreadsPerStream).setPushAllFilters(this.pushAllFilters).setPrebufferReadRowsResponses(this.numPrebufferReadRowsResponses).setStreamsPerPartition(this.numStreamsPerPartition).build();
    }

    public BigQueryClient.ReadTableOptions toReadTableOptions() {
        return new BigQueryClient.ReadTableOptions(){

            @Override
            public TableId tableId() {
                return SparkBigQueryConfig.this.getTableId();
            }

            @Override
            public Optional<String> query() {
                return SparkBigQueryConfig.this.getQuery();
            }

            @Override
            public boolean viewsEnabled() {
                return SparkBigQueryConfig.this.isViewsEnabled();
            }

            @Override
            public String viewEnabledParamName() {
                return SparkBigQueryConfig.VIEWS_ENABLED_OPTION;
            }

            @Override
            public int expirationTimeInMinutes() {
                return SparkBigQueryConfig.this.getMaterializationExpirationTimeInMinutes();
            }
        };
    }

    public static enum IntermediateFormat {
        AVRO("avro", FormatOptions.avro()),
        AVRO_2_3("com.databricks.spark.avro", FormatOptions.avro()),
        ORC("orc", FormatOptions.orc()),
        PARQUET("parquet", FormatOptions.parquet());

        private static Set<String> PERMITTED_DATA_SOURCES;
        private final String dataSource;
        private final FormatOptions formatOptions;

        private IntermediateFormat(String string2, FormatOptions formatOptions) {
            this.dataSource = string2;
            this.formatOptions = formatOptions;
        }

        public static IntermediateFormat from(String string, String string2, SQLConf sQLConf, boolean bl) {
            Preconditions.checkArgument((boolean)PERMITTED_DATA_SOURCES.contains(string.toLowerCase()), (String)"Data write format '%s' is not supported. Supported formats are %s", (Object)string, PERMITTED_DATA_SOURCES);
            if (bl && string.equalsIgnoreCase("avro")) {
                IntermediateFormat intermediateFormat2 = IntermediateFormat.isSpark24OrAbove(string2) ? AVRO : AVRO_2_3;
                try {
                    DataSource.lookupDataSource((String)intermediateFormat2.getDataSource(), (SQLConf)sQLConf);
                }
                catch (Exception exception) {
                    throw IntermediateFormat.missingAvroException(string2, exception);
                }
                return intermediateFormat2;
            }
            return Stream.of(IntermediateFormat.values()).filter(intermediateFormat -> intermediateFormat.getDataSource().equalsIgnoreCase(string)).findFirst().get();
        }

        static boolean isSpark24OrAbove(String string) {
            return string.compareTo("2.4") > 0;
        }

        private static IllegalStateException missingAvroException(String string, Exception exception) {
            String string2;
            String string3;
            if (IntermediateFormat.isSpark24OrAbove(string)) {
                string3 = Properties.versionNumberString();
                String string4 = string3.substring(0, string3.lastIndexOf(46));
                string2 = String.format("org.apache.spark:spark-avro_%s:%s", string4, string);
            } else {
                string2 = "com.databricks:spark-avro_2.11:4.0.0";
            }
            string3 = String.format("Avro writing is not supported, as the spark-avro has not been found. Please re-run spark with the --packages %s parameter", string2);
            return new IllegalStateException(string3, exception);
        }

        public String getDataSource() {
            return this.dataSource;
        }

        public FormatOptions getFormatOptions() {
            return this.formatOptions;
        }

        public String getFileSuffix() {
            return this.getFormatOptions().getType().toLowerCase();
        }

        static {
            PERMITTED_DATA_SOURCES = Stream.of(IntermediateFormat.values()).map(IntermediateFormat::getDataSource).filter(string -> !string.contains(".")).collect(Collectors.toSet());
        }
    }
}

