/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.connector.common.BigQueryProxyConfig;
import com.google.cloud.bigquery.connector.common.BigQueryProxyTransporterBuilder;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;

public class SparkBigQueryProxyAndHttpConfig
implements BigQueryProxyConfig,
Serializable {
    public static final String PROXY_ADDRESS_OPTION = "proxyAddress";
    public static final String PROXY_USERNAME_OPTION = "proxyUsername";
    public static final String PROXY_PASSWORD_OPTION = "proxyPassword";
    public static final String HTTP_MAX_RETRY_OPTION = "httpMaxRetry";
    public static final String HTTP_CONNECT_TIMEOUT_OPTION = "httpConnectTimeout";
    public static final String HTTP_READ_TIMEOUT_OPTION = "httpReadTimeout";
    public static final String GCS_CONFIG_PROXY_ADDRESS_PROPERTY = "fs.gs.proxy.address";
    public static final String GCS_CONFIG_PROXY_USERNAME_PROPERTY = "fs.gs.proxy.username";
    public static final String GCS_CONFIG_PROXY_PASSWORD_PROPERTY = "fs.gs.proxy.password";
    public static final String GCS_CONFIG_HTTP_MAX_RETRY_PROPERTY = "fs.gs.http.max.retry";
    public static final String GCS_CONFIG_HTTP_CONNECT_TIMEOUT_PROPERTY = "fs.gs.http.connect-timeout";
    public static final String GCS_CONFIG_HTTP_READ_TIMEOUT_PROPERTY = "fs.gs.http.read-timeout";
    private com.google.common.base.Optional<URI> proxyUri;
    private com.google.common.base.Optional<String> proxyUsername;
    private com.google.common.base.Optional<String> proxyPassword;
    private com.google.common.base.Optional<Integer> httpMaxRetry;
    private com.google.common.base.Optional<Integer> httpConnectTimeout;
    private com.google.common.base.Optional<Integer> httpReadTimeout;

    @VisibleForTesting
    SparkBigQueryProxyAndHttpConfig() {
    }

    @VisibleForTesting
    public static SparkBigQueryProxyAndHttpConfig from(Map<String, String> map, ImmutableMap<String, String> immutableMap, Configuration configuration) throws IllegalArgumentException {
        SparkBigQueryProxyAndHttpConfig sparkBigQueryProxyAndHttpConfig = new SparkBigQueryProxyAndHttpConfig();
        com.google.common.base.Optional<String> optional = SparkBigQueryProxyAndHttpConfig.getProperty(map, immutableMap, configuration, PROXY_ADDRESS_OPTION, GCS_CONFIG_PROXY_ADDRESS_PROPERTY);
        sparkBigQueryProxyAndHttpConfig.proxyUri = com.google.common.base.Optional.fromNullable((Object)SparkBigQueryProxyAndHttpConfig.parseProxyAddress((String)optional.or((Object)"")));
        sparkBigQueryProxyAndHttpConfig.proxyUsername = SparkBigQueryProxyAndHttpConfig.getProperty(map, immutableMap, configuration, PROXY_USERNAME_OPTION, GCS_CONFIG_PROXY_USERNAME_PROPERTY);
        sparkBigQueryProxyAndHttpConfig.proxyPassword = SparkBigQueryProxyAndHttpConfig.getProperty(map, immutableMap, configuration, PROXY_PASSWORD_OPTION, GCS_CONFIG_PROXY_PASSWORD_PROPERTY);
        SparkBigQueryProxyAndHttpConfig.checkProxyParamsValidity(sparkBigQueryProxyAndHttpConfig);
        sparkBigQueryProxyAndHttpConfig.httpMaxRetry = SparkBigQueryProxyAndHttpConfig.getProperty(map, immutableMap, configuration, HTTP_MAX_RETRY_OPTION, GCS_CONFIG_HTTP_MAX_RETRY_PROPERTY).transform(Integer::valueOf);
        sparkBigQueryProxyAndHttpConfig.httpConnectTimeout = SparkBigQueryProxyAndHttpConfig.getProperty(map, immutableMap, configuration, HTTP_CONNECT_TIMEOUT_OPTION, GCS_CONFIG_HTTP_CONNECT_TIMEOUT_PROPERTY).transform(Integer::valueOf);
        sparkBigQueryProxyAndHttpConfig.httpReadTimeout = SparkBigQueryProxyAndHttpConfig.getProperty(map, immutableMap, configuration, HTTP_READ_TIMEOUT_OPTION, GCS_CONFIG_HTTP_READ_TIMEOUT_PROPERTY).transform(Integer::valueOf);
        SparkBigQueryProxyAndHttpConfig.checkHttpParamsValidity(sparkBigQueryProxyAndHttpConfig);
        return sparkBigQueryProxyAndHttpConfig;
    }

    private static void checkProxyParamsValidity(SparkBigQueryProxyAndHttpConfig sparkBigQueryProxyAndHttpConfig) throws IllegalArgumentException {
        if (!sparkBigQueryProxyAndHttpConfig.proxyUri.isPresent() && (sparkBigQueryProxyAndHttpConfig.proxyUsername.isPresent() || sparkBigQueryProxyAndHttpConfig.proxyPassword.isPresent())) {
            throw new IllegalArgumentException("Please set proxyAddress in order to use a proxy. Setting proxyUsername or proxyPassword is not enough");
        }
        BigQueryProxyTransporterBuilder.checkProxyParamsValidity(sparkBigQueryProxyAndHttpConfig.getProxyUsername(), sparkBigQueryProxyAndHttpConfig.getProxyPassword());
    }

    private static void checkHttpParamsValidity(SparkBigQueryProxyAndHttpConfig sparkBigQueryProxyAndHttpConfig) throws IllegalArgumentException {
        if (sparkBigQueryProxyAndHttpConfig.getHttpMaxRetry().isPresent() && sparkBigQueryProxyAndHttpConfig.getHttpMaxRetry().get() < 0) {
            throw new IllegalArgumentException("Http Max Retry value cannot be negative");
        }
    }

    private static com.google.common.base.Optional<String> getProperty(Map<String, String> map, ImmutableMap<String, String> immutableMap, Configuration configuration, String string, String string2) {
        return com.google.common.base.Optional.fromJavaUtil(BigQueryUtil.firstPresent(SparkBigQueryProxyAndHttpConfig.getFirstOrSecondOption(map, immutableMap, string).toJavaUtil(), com.google.common.base.Optional.fromNullable((Object)configuration.get(string2)).toJavaUtil()));
    }

    private static com.google.common.base.Optional<String> getFirstOrSecondOption(Map<String, String> map, ImmutableMap<String, String> immutableMap, String string) {
        return com.google.common.base.Optional.fromNullable((Object)map.get(string.toLowerCase())).or(com.google.common.base.Optional.fromNullable((Object)immutableMap.get((Object)string)));
    }

    @VisibleForTesting
    static URI parseProxyAddress(String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return null;
        }
        String string2 = (string.contains("//") ? "" : "//") + string;
        try {
            URI uRI = new URI(string2);
            String string3 = uRI.getScheme();
            String string4 = uRI.getHost();
            int n = uRI.getPort();
            Preconditions.checkArgument((Strings.isNullOrEmpty((String)string3) || string3.matches("https?") ? 1 : 0) != 0, (String)"Proxy address '%s' has invalid scheme '%s'.", (Object)string, (Object)string3);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)string4) ? 1 : 0) != 0, (String)"Proxy address '%s' has no host.", (Object)string);
            Preconditions.checkArgument((n != -1 ? 1 : 0) != 0, (String)"Proxy address '%s' has no port.", (Object)string);
            Preconditions.checkArgument((boolean)uRI.equals(new URI(string3, null, string4, n, null, null, null)), (String)"Invalid proxy address '%s'.", (Object)string);
            return uRI;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(String.format("Invalid proxy address '%s'.", string), uRISyntaxException);
        }
    }

    @Override
    public Optional<URI> getProxyUri() {
        return this.proxyUri.toJavaUtil();
    }

    @Override
    public Optional<String> getProxyUsername() {
        return this.proxyUsername.toJavaUtil();
    }

    @Override
    public Optional<String> getProxyPassword() {
        return this.proxyPassword.toJavaUtil();
    }

    Optional<Integer> getHttpMaxRetry() {
        return this.httpMaxRetry.toJavaUtil();
    }

    Optional<Integer> getHttpConnectTimeout() {
        return this.httpConnectTimeout.toJavaUtil();
    }

    Optional<Integer> getHttpReadTimeout() {
        return this.httpReadTimeout.toJavaUtil();
    }
}

