/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Properties;

public class SparkBigQueryUtil {
    static final Properties BUILD_PROPERTIES = SparkBigQueryUtil.loadBuildProperties();
    static final String CONNECTOR_VERSION = BUILD_PROPERTIES.getProperty("connector.version");

    private static Properties loadBuildProperties() {
        try {
            Properties properties = new Properties();
            properties.load(SparkBigQueryUtil.class.getResourceAsStream("/spark-bigquery-connector.properties"));
            return properties;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static List<String> optimizeLoadUriListForSpark(List<String> list) {
        return BigQueryUtil.optimizeLoadUriList(list, ".*/part-", "-[-\\w\\.]+");
    }
}

