/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.common.collect.ImmutableList;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class SparkFilterUtils {
    private SparkFilterUtils() {
    }

    public static boolean isTopLevelFieldHandled(boolean bl, Filter filter, DataFormat dataFormat, Map<String, StructField> map) {
        if (bl) {
            return true;
        }
        if (filter instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter;
            return SparkFilterUtils.isFilterWithNamedFieldHandled(bl, filter, dataFormat, map, equalTo.attribute());
        }
        if (filter instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter;
            return SparkFilterUtils.isFilterWithNamedFieldHandled(bl, filter, dataFormat, map, greaterThan.attribute());
        }
        if (filter instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter;
            return SparkFilterUtils.isFilterWithNamedFieldHandled(bl, filter, dataFormat, map, greaterThanOrEqual.attribute());
        }
        if (filter instanceof LessThan) {
            LessThan lessThan = (LessThan)filter;
            return SparkFilterUtils.isFilterWithNamedFieldHandled(bl, filter, dataFormat, map, lessThan.attribute());
        }
        if (filter instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter;
            return SparkFilterUtils.isFilterWithNamedFieldHandled(bl, filter, dataFormat, map, lessThanOrEqual.attribute());
        }
        if (filter instanceof In) {
            In in = (In)filter;
            return SparkFilterUtils.isFilterWithNamedFieldHandled(bl, filter, dataFormat, map, in.attribute());
        }
        if (filter instanceof IsNull) {
            IsNull isNull = (IsNull)filter;
            return SparkFilterUtils.isFilterWithNamedFieldHandled(bl, filter, dataFormat, map, isNull.attribute());
        }
        if (filter instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter;
            return SparkFilterUtils.isFilterWithNamedFieldHandled(bl, filter, dataFormat, map, isNotNull.attribute());
        }
        if (filter instanceof And) {
            And and = (And)filter;
            return SparkFilterUtils.isTopLevelFieldHandled(bl, and.left(), dataFormat, map) && SparkFilterUtils.isTopLevelFieldHandled(bl, and.right(), dataFormat, map);
        }
        if (filter instanceof Or) {
            Or or = (Or)filter;
            return dataFormat == DataFormat.AVRO && SparkFilterUtils.isTopLevelFieldHandled(bl, or.left(), dataFormat, map) && SparkFilterUtils.isTopLevelFieldHandled(bl, or.right(), dataFormat, map);
        }
        if (filter instanceof Not) {
            Not not = (Not)filter;
            return SparkFilterUtils.isTopLevelFieldHandled(bl, not.child(), dataFormat, map);
        }
        if (filter instanceof StringStartsWith) {
            StringStartsWith stringStartsWith = (StringStartsWith)filter;
            return SparkFilterUtils.isFilterWithNamedFieldHandled(bl, filter, dataFormat, map, stringStartsWith.attribute());
        }
        if (filter instanceof StringEndsWith) {
            StringEndsWith stringEndsWith = (StringEndsWith)filter;
            return SparkFilterUtils.isFilterWithNamedFieldHandled(bl, filter, dataFormat, map, stringEndsWith.attribute());
        }
        if (filter instanceof StringContains) {
            StringContains stringContains = (StringContains)filter;
            return SparkFilterUtils.isFilterWithNamedFieldHandled(bl, filter, dataFormat, map, stringContains.attribute());
        }
        throw new IllegalArgumentException(String.format("Invalid filter: %s", filter));
    }

    static boolean isFilterWithNamedFieldHandled(boolean bl, Filter filter, DataFormat dataFormat, Map<String, StructField> map, String string) {
        return Optional.ofNullable(map.get(string)).filter(structField -> structField.dataType() instanceof StructType || structField.dataType() instanceof ArrayType).map(structField -> false).orElse(SparkFilterUtils.isHandled(bl, filter, dataFormat));
    }

    public static boolean isHandled(boolean bl, Filter filter, DataFormat dataFormat) {
        if (bl) {
            return true;
        }
        if (filter instanceof EqualTo || filter instanceof GreaterThan || filter instanceof GreaterThanOrEqual || filter instanceof LessThan || filter instanceof LessThanOrEqual || filter instanceof In || filter instanceof IsNull || filter instanceof IsNotNull || filter instanceof StringStartsWith || filter instanceof StringEndsWith || filter instanceof StringContains) {
            return true;
        }
        if (filter instanceof EqualNullSafe) {
            return false;
        }
        if (filter instanceof And) {
            And and = (And)filter;
            return SparkFilterUtils.isHandled(bl, and.left(), dataFormat) && SparkFilterUtils.isHandled(bl, and.right(), dataFormat);
        }
        if (filter instanceof Or) {
            Or or = (Or)filter;
            return dataFormat == DataFormat.AVRO && SparkFilterUtils.isHandled(bl, or.left(), dataFormat) && SparkFilterUtils.isHandled(bl, or.right(), dataFormat);
        }
        if (filter instanceof Not) {
            return SparkFilterUtils.isHandled(bl, ((Not)filter).child(), dataFormat);
        }
        return false;
    }

    public static Iterable<Filter> handledFilters(boolean bl, DataFormat dataFormat, Filter ... filterArray) {
        return SparkFilterUtils.handledFilters(bl, dataFormat, (Iterable<Filter>)ImmutableList.copyOf((Object[])filterArray));
    }

    public static Iterable<Filter> handledFilters(boolean bl, DataFormat dataFormat, Iterable<Filter> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).filter(filter -> SparkFilterUtils.isHandled(bl, filter, dataFormat)).collect(Collectors.toList());
    }

    public static Iterable<Filter> unhandledFilters(boolean bl, DataFormat dataFormat, Filter ... filterArray) {
        return SparkFilterUtils.unhandledFilters(bl, dataFormat, (Iterable<Filter>)ImmutableList.copyOf((Object[])filterArray));
    }

    public static Iterable<Filter> unhandledFilters(boolean bl, DataFormat dataFormat, Iterable<Filter> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).filter(filter -> !SparkFilterUtils.isHandled(bl, filter, dataFormat)).collect(Collectors.toList());
    }

    public static String getCompiledFilter(boolean bl, DataFormat dataFormat, Optional<String> optional2, Filter ... filterArray) {
        String string = SparkFilterUtils.compileFilters(SparkFilterUtils.handledFilters(bl, dataFormat, (Iterable<Filter>)ImmutableList.copyOf((Object[])filterArray)));
        return Stream.of(optional2, string.length() == 0 ? Optional.empty() : Optional.of(string)).filter(Optional::isPresent).map(optional -> "(" + optional.get() + ")").collect(Collectors.joining(" AND "));
    }

    public static String compileFilter(Filter filter) {
        if (filter instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter;
            return String.format("%s = %s", SparkFilterUtils.quote(equalTo.attribute()), SparkFilterUtils.compileValue(equalTo.value()));
        }
        if (filter instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter;
            return String.format("%s > %s", SparkFilterUtils.quote(greaterThan.attribute()), SparkFilterUtils.compileValue(greaterThan.value()));
        }
        if (filter instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter;
            return String.format("%s >= %s", SparkFilterUtils.quote(greaterThanOrEqual.attribute()), SparkFilterUtils.compileValue(greaterThanOrEqual.value()));
        }
        if (filter instanceof LessThan) {
            LessThan lessThan = (LessThan)filter;
            return String.format("%s < %s", SparkFilterUtils.quote(lessThan.attribute()), SparkFilterUtils.compileValue(lessThan.value()));
        }
        if (filter instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter;
            return String.format("%s <= %s", SparkFilterUtils.quote(lessThanOrEqual.attribute()), SparkFilterUtils.compileValue(lessThanOrEqual.value()));
        }
        if (filter instanceof In) {
            In in = (In)filter;
            return String.format("%s IN %s", SparkFilterUtils.quote(in.attribute()), SparkFilterUtils.compileValue(in.values(), '(', ')'));
        }
        if (filter instanceof IsNull) {
            IsNull isNull = (IsNull)filter;
            return String.format("%s IS NULL", SparkFilterUtils.quote(isNull.attribute()));
        }
        if (filter instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter;
            return String.format("%s IS NOT NULL", SparkFilterUtils.quote(isNotNull.attribute()));
        }
        if (filter instanceof And) {
            And and = (And)filter;
            return String.format("((%s) AND (%s))", SparkFilterUtils.compileFilter(and.left()), SparkFilterUtils.compileFilter(and.right()));
        }
        if (filter instanceof Or) {
            Or or = (Or)filter;
            return String.format("((%s) OR (%s))", SparkFilterUtils.compileFilter(or.left()), SparkFilterUtils.compileFilter(or.right()));
        }
        if (filter instanceof Not) {
            Not not = (Not)filter;
            return String.format("(NOT (%s))", SparkFilterUtils.compileFilter(not.child()));
        }
        if (filter instanceof StringStartsWith) {
            StringStartsWith stringStartsWith = (StringStartsWith)filter;
            return String.format("%s LIKE '%s%%'", SparkFilterUtils.quote(stringStartsWith.attribute()), SparkFilterUtils.escape(stringStartsWith.value()));
        }
        if (filter instanceof StringEndsWith) {
            StringEndsWith stringEndsWith = (StringEndsWith)filter;
            return String.format("%s LIKE '%%%s'", SparkFilterUtils.quote(stringEndsWith.attribute()), SparkFilterUtils.escape(stringEndsWith.value()));
        }
        if (filter instanceof StringContains) {
            StringContains stringContains = (StringContains)filter;
            return String.format("%s LIKE '%%%s%%'", SparkFilterUtils.quote(stringContains.attribute()), SparkFilterUtils.escape(stringContains.value()));
        }
        throw new IllegalArgumentException(String.format("Invalid filter: %s", filter));
    }

    public static String compileFilters(Iterable<Filter> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).map(SparkFilterUtils::compileFilter).sorted().collect(Collectors.joining(" AND "));
    }

    static String compileValue(Object object) {
        return SparkFilterUtils.compileValue(object, '[', ']');
    }

    static String compileValue(Object object, char c, char c2) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return "'" + SparkFilterUtils.escape((String)object) + "'";
        }
        if (object instanceof Date) {
            return "DATE '" + object + "'";
        }
        if (object instanceof Timestamp) {
            return "TIMESTAMP '" + object + "'";
        }
        if (object instanceof Object[]) {
            return Arrays.stream((Object[])object).map(SparkFilterUtils::compileValue).collect(Collectors.joining(", ", Character.toString(c), Character.toString(c2)));
        }
        return object.toString();
    }

    static String escape(String string) {
        return string.replace("'", "\\'");
    }

    static String quote(String string) {
        return "`" + string + "`";
    }
}

