/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.direct;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.direct.ArrowConverter;
import com.google.cloud.spark.bigquery.direct.AvroConverter;
import com.google.cloud.spark.bigquery.direct.BigQueryPartition;
import com.google.cloud.spark.bigquery.direct.BigQueryRDD$;
import com.google.cloud.spark.bigquery.direct.ReadRowsClientWrapper;
import com.google.cloud.spark.bigquery.direct.ReadRowsHelper;
import java.io.Serializable;
import org.apache.spark.InterruptibleIterator;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import scala.Function1;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\t\u0013\u0001}A\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\tq\u0001\u0011\t\u0011)A\u0005s!A!\t\u0001B\u0001B\u0003%1\t\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u0011!\t\u0007A!A!\u0002\u0013\u0011\u0007\u0002\u00034\u0001\u0005\u0003\u0005\u000b\u0011B4\t\u0011-\u0004!\u0011!Q\u0001\n1D\u0001B\u001d\u0001\u0003\u0002\u0003\u0006Ia\u001d\u0005\u0006o\u0002!\t\u0001\u001f\u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u0011\u001d\ty\u0002\u0001C)\u0003C9q!a\t\u0013\u0011\u0003\t)C\u0002\u0004\u0012%!\u0005\u0011q\u0005\u0005\u0007o6!\t!!\u000e\t\u000f\u0005]R\u0002\"\u0001\u0002:!I\u0011QK\u0007\u0002\u0002\u0013%\u0011q\u000b\u0002\f\u0005&<\u0017+^3ssJ#EI\u0003\u0002\u0014)\u00051A-\u001b:fGRT!!\u0006\f\u0002\u0011\tLw-];fefT!a\u0006\r\u0002\u000bM\u0004\u0018M]6\u000b\u0005eQ\u0012!B2m_V$'BA\u000e\u001d\u0003\u00199wn\\4mK*\tQ$A\u0002d_6\u001c\u0001a\u0005\u0002\u0001AA\u0019\u0011%K\u0016\u000e\u0003\tR!a\t\u0013\u0002\u0007I$GM\u0003\u0002\u0018K)\u0011aeJ\u0001\u0007CB\f7\r[3\u000b\u0003!\n1a\u001c:h\u0013\tQ#EA\u0002S\t\u0012\u0003\"\u0001L\u0019\u000e\u00035R!AL\u0018\u0002\u0011\r\fG/\u00197zgRT!\u0001\r\u0013\u0002\u0007M\fH.\u0003\u00023[\tY\u0011J\u001c;fe:\fGNU8x\u0003\t\u00198\r\u0005\u00026m5\tA%\u0003\u00028I\ta1\u000b]1sW\u000e{g\u000e^3yi\u0006)\u0001/\u0019:ugB\u0019!(P \u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012Q!\u0011:sCf\u0004\"!\u000e!\n\u0005\u0005##!\u0003)beRLG/[8o\u0003\u001d\u0019Xm]:j_:\u0004\"\u0001\u0012&\u000e\u0003\u0015S!AR$\u0002\u0005Y\f$B\u0001%J\u0003\u001d\u0019Ho\u001c:bO\u0016T!!\u0006\r\n\u0005-+%a\u0003*fC\u0012\u001cVm]:j_:\fabY8mk6t7/\u00138Pe\u0012,'\u000fE\u0002O-fs!a\u0014+\u000f\u0005A\u001bV\"A)\u000b\u0005Is\u0012A\u0002\u001fs_>$h(C\u0001=\u0013\t)6(A\u0004qC\u000e\\\u0017mZ3\n\u0005]C&aA*fc*\u0011Qk\u000f\t\u00035zs!a\u0017/\u0011\u0005A[\u0014BA/<\u0003\u0019\u0001&/\u001a3fM&\u0011q\f\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005u[\u0014\u0001\u00032r'\u000eDW-\\1\u0011\u0005\r$W\"A%\n\u0005\u0015L%AB*dQ\u0016l\u0017-A\u0004paRLwN\\:\u0011\u0005!LW\"\u0001\u000b\n\u0005)$\"aE*qCJ\\')[4Rk\u0016\u0014\u0018pQ8oM&<\u0017!C4fi\u000ec\u0017.\u001a8u!\u0011QTnZ8\n\u00059\\$!\u0003$v]\u000e$\u0018n\u001c82!\t!\u0005/\u0003\u0002r\u000b\n\u0011\")[4Rk\u0016\u0014\u0018PU3bI\u000ec\u0017.\u001a8u\u00039\u0011\u0017nZ)vKJL8\t\\5f]R\u0004BAO7hiB\u00111-^\u0005\u0003m&\u0013\u0001BQ5h#V,'/_\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0019e\\H0 @\u0000\u0003\u0003\t\u0019!!\u0002\u0011\u0005i\u0004Q\"\u0001\n\t\u000bMJ\u0001\u0019\u0001\u001b\t\u000baJ\u0001\u0019A\u001d\t\u000b\tK\u0001\u0019A\"\t\u000b1K\u0001\u0019A'\t\u000b\u0005L\u0001\u0019\u00012\t\u000b\u0019L\u0001\u0019A4\t\u000b-L\u0001\u0019\u00017\t\u000bIL\u0001\u0019A:\u0002\u000f\r|W\u000e];uKR1\u00111BA\t\u0003+\u0001BATA\u0007W%\u0019\u0011q\u0002-\u0003\u0011%#XM]1u_JDa!a\u0005\u000b\u0001\u0004y\u0014!B:qY&$\bbBA\f\u0015\u0001\u0007\u0011\u0011D\u0001\bG>tG/\u001a=u!\r)\u00141D\u0005\u0004\u0003;!#a\u0003+bg.\u001cuN\u001c;fqR\fQbZ3u!\u0006\u0014H/\u001b;j_:\u001cX#A\u001d\u0002\u0017\tKw-U;fef\u0014F\t\u0012\t\u0003u6\u0019R!DA\u0015\u0003_\u00012AOA\u0016\u0013\r\tic\u000f\u0002\u0007\u0003:L(+\u001a4\u0011\u0007i\n\t$C\u0002\u00024m\u0012AbU3sS\u0006d\u0017N_1cY\u0016$\"!!\n\u0002\u0013M\u001c\u0017M\u001c+bE2,G#E=\u0002<\u0005\u001d\u0013\u0011JA&\u0003\u001b\ny%!\u0015\u0002T!9\u0011QH\bA\u0002\u0005}\u0012AC:rY\u000e{g\u000e^3yiB!\u0011\u0011IA\"\u001b\u0005y\u0013bAA#_\tQ1+\u0015'D_:$X\r\u001f;\t\u000baz\u0001\u0019A\u001d\t\u000b\t{\u0001\u0019A\"\t\u000b\u0005|\u0001\u0019\u00012\t\u000b1{\u0001\u0019A'\t\u000b\u0019|\u0001\u0019A4\t\u000b-|\u0001\u0019\u00017\t\u000bI|\u0001\u0019A:\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u00033\u0002B!a\u0017\u0002f5\u0011\u0011Q\f\u0006\u0005\u0003?\n\t'\u0001\u0003mC:<'BAA2\u0003\u0011Q\u0017M^1\n\t\u0005\u001d\u0014Q\f\u0002\u0007\u001f\nTWm\u0019;")
public class BigQueryRDD
extends RDD<InternalRow> {
    private final Partition[] parts;
    private final ReadSession session;
    private final Seq<String> columnsInOrder;
    private final Schema bqSchema;
    private final SparkBigQueryConfig options;
    private final Function1<SparkBigQueryConfig, BigQueryReadClient> getClient;

    public static BigQueryRDD scanTable(SQLContext sQLContext, Partition[] partitionArray, ReadSession readSession, Schema schema, Seq<String> seq, SparkBigQueryConfig sparkBigQueryConfig, Function1<SparkBigQueryConfig, BigQueryReadClient> function1, Function1<SparkBigQueryConfig, BigQuery> function12) {
        return BigQueryRDD$.MODULE$.scanTable(sQLContext, partitionArray, readSession, schema, seq, sparkBigQueryConfig, function1, function12);
    }

    public Iterator<InternalRow> compute(Partition split, TaskContext context) {
        BigQueryPartition bqPartition = (BigQueryPartition)split;
        ReadRowsRequest.Builder request = ReadRowsRequest.newBuilder().setReadStream(bqPartition.stream());
        BigQueryReadClient client = (BigQueryReadClient)this.getClient.apply((Object)this.options);
        context.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)ctx -> {
            client.close();
            return ctx;
        });
        Iterator<ReadRowsResponse> readRowResponses = new ReadRowsHelper(new ReadRowsClientWrapper(client), request, this.options.getMaxReadRowsRetries()).readRows();
        Iterator<InternalRow> it = this.options.getReadDataFormat().equals((Object)DataFormat.AVRO) ? new AvroConverter(this.bqSchema, this.columnsInOrder, this.session.getAvroSchema().getSchema(), readRowResponses, this.options.getSchema()).getIterator() : new ArrowConverter(this.columnsInOrder, this.session.getArrowSchema().getSerializedSchema(), readRowResponses, this.options.getSchema()).getIterator();
        return new InterruptibleIterator(context, it);
    }

    public Partition[] getPartitions() {
        return this.parts;
    }

    public BigQueryRDD(SparkContext sc, Partition[] parts, ReadSession session, Seq<String> columnsInOrder, Schema bqSchema, SparkBigQueryConfig options, Function1<SparkBigQueryConfig, BigQueryReadClient> getClient, Function1<SparkBigQueryConfig, BigQuery> bigQueryClient) {
        this.parts = parts;
        this.session = session;
        this.columnsInOrder = columnsInOrder;
        this.bqSchema = bqSchema;
        this.options = options;
        this.getClient = getClient;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(InternalRow.class));
    }
}

