/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.direct;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.connector.common.BigQueryProxyConfig;
import com.google.cloud.bigquery.connector.common.BigQueryProxyTransporterBuilder;
import com.google.cloud.bigquery.connector.common.ReadSessionCreatorConfig;
import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.BigQueryReadSettings;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.cloud.spark.bigquery.BigQueryUtilScala$;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.SparkBigQueryConnectorUserAgentProvider;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class DirectBigQueryRelation$
implements scala.Serializable {
    public static DirectBigQueryRelation$ MODULE$;
    private int emptyRowRDDsCreated;

    static {
        new DirectBigQueryRelation$();
    }

    public Function1<SparkBigQueryConfig, BigQueryReadClient> $lessinit$greater$default$3() {
        return (Function1 & Serializable & scala.Serializable)options -> MODULE$.createReadClient((SparkBigQueryConfig)options);
    }

    public Function1<SparkBigQueryConfig, BigQuery> $lessinit$greater$default$4() {
        return (Function1 & Serializable & scala.Serializable)options -> BigQueryUtilScala$.MODULE$.createBigQuery((SparkBigQueryConfig)options);
    }

    public int emptyRowRDDsCreated() {
        return this.emptyRowRDDsCreated;
    }

    public void emptyRowRDDsCreated_$eq(int x$1) {
        this.emptyRowRDDsCreated = x$1;
    }

    public BigQueryReadClient createReadClient(SparkBigQueryConfig options) {
        BigQueryProxyConfig proxyHttpConfig = options.getBigQueryProxyConfig();
        InstantiatingGrpcChannelProvider.Builder settingsBuilder = BigQueryReadSettings.defaultGrpcTransportProviderBuilder();
        Object object = proxyHttpConfig.getProxyUri().isPresent() ? settingsBuilder.setChannelConfigurator(BigQueryProxyTransporterBuilder.createGrpcChannelConfigurator(proxyHttpConfig.getProxyUri(), proxyHttpConfig.getProxyUsername(), proxyHttpConfig.getProxyPassword())) : BoxedUnit.UNIT;
        settingsBuilder.setHeaderProvider((HeaderProvider)this.headerProvider());
        ReadSessionCreatorConfig readSessionConfig = options.toReadSessionCreatorConfig();
        Object object2 = readSessionConfig.endpoint().isPresent() ? settingsBuilder.setEndpoint(readSessionConfig.endpoint().get()) : BoxedUnit.UNIT;
        BigQueryReadSettings.Builder clientSettings = (BigQueryReadSettings.Builder)BigQueryReadSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)settingsBuilder.build());
        clientSettings.setCredentialsProvider(new CredentialsProvider(options){
            private final SparkBigQueryConfig options$1;

            public Credentials getCredentials() {
                return this.options$1.createCredentials();
            }
            {
                this.options$1 = options$1;
            }
        });
        return BigQueryReadClient.create((BigQueryReadSettings)clientSettings.build());
    }

    private FixedHeaderProvider headerProvider() {
        return FixedHeaderProvider.create((String[])new String[]{"user-agent", new SparkBigQueryConnectorUserAgentProvider("v1").getUserAgent()});
    }

    public boolean isTopLevelFieldFilterHandled(boolean pushAllFilters, Filter filter, DataFormat readDataFormat, Map<String, StructField> fields) {
        boolean bl;
        block20: {
            Filter filter2;
            while (true) {
                Filter child;
                if (pushAllFilters) {
                    return true;
                }
                filter2 = filter;
                if (filter2 instanceof EqualTo) {
                    EqualTo equalTo = (EqualTo)filter2;
                    String attr = equalTo.attribute();
                    bl = this.isFilterWithNamedFieldHandled(filter, readDataFormat, fields, attr);
                    break block20;
                }
                if (filter2 instanceof GreaterThan) {
                    GreaterThan greaterThan = (GreaterThan)filter2;
                    String attr = greaterThan.attribute();
                    bl = this.isFilterWithNamedFieldHandled(filter, readDataFormat, fields, attr);
                    break block20;
                }
                if (filter2 instanceof GreaterThanOrEqual) {
                    GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
                    String attr = greaterThanOrEqual.attribute();
                    bl = this.isFilterWithNamedFieldHandled(filter, readDataFormat, fields, attr);
                    break block20;
                }
                if (filter2 instanceof LessThan) {
                    LessThan lessThan = (LessThan)filter2;
                    String attr = lessThan.attribute();
                    bl = this.isFilterWithNamedFieldHandled(filter, readDataFormat, fields, attr);
                    break block20;
                }
                if (filter2 instanceof LessThanOrEqual) {
                    LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
                    String attr = lessThanOrEqual.attribute();
                    bl = this.isFilterWithNamedFieldHandled(filter, readDataFormat, fields, attr);
                    break block20;
                }
                if (filter2 instanceof In) {
                    In in = (In)filter2;
                    String attr = in.attribute();
                    bl = this.isFilterWithNamedFieldHandled(filter, readDataFormat, fields, attr);
                    break block20;
                }
                if (filter2 instanceof IsNull) {
                    IsNull isNull = (IsNull)filter2;
                    String attr = isNull.attribute();
                    bl = this.isFilterWithNamedFieldHandled(filter, readDataFormat, fields, attr);
                    break block20;
                }
                if (filter2 instanceof IsNotNull) {
                    IsNotNull isNotNull = (IsNotNull)filter2;
                    String attr = isNotNull.attribute();
                    bl = this.isFilterWithNamedFieldHandled(filter, readDataFormat, fields, attr);
                    break block20;
                }
                if (filter2 instanceof And) {
                    And and = (And)filter2;
                    Filter lhs = and.left();
                    Filter rhs = and.right();
                    if (this.isTopLevelFieldFilterHandled(pushAllFilters, lhs, readDataFormat, fields)) {
                        filter = rhs;
                        continue;
                    }
                    bl = false;
                    break block20;
                }
                if (filter2 instanceof Or) {
                    Or or = (Or)filter2;
                    Filter lhs = or.left();
                    Filter rhs = or.right();
                    DataFormat dataFormat = readDataFormat;
                    DataFormat dataFormat2 = DataFormat.AVRO;
                    if (!(dataFormat != null ? !dataFormat.equals(dataFormat2) : dataFormat2 != null) && this.isTopLevelFieldFilterHandled(pushAllFilters, lhs, readDataFormat, fields)) {
                        filter = rhs;
                        continue;
                    }
                    bl = false;
                    break block20;
                }
                if (!(filter2 instanceof Not)) break;
                Not not = (Not)filter2;
                filter = child = not.child();
            }
            if (filter2 instanceof StringStartsWith) {
                StringStartsWith stringStartsWith = (StringStartsWith)filter2;
                String attr = stringStartsWith.attribute();
                bl = this.isFilterWithNamedFieldHandled(filter, readDataFormat, fields, attr);
            } else if (filter2 instanceof StringEndsWith) {
                StringEndsWith stringEndsWith = (StringEndsWith)filter2;
                String attr = stringEndsWith.attribute();
                bl = this.isFilterWithNamedFieldHandled(filter, readDataFormat, fields, attr);
            } else if (filter2 instanceof StringContains) {
                StringContains stringContains = (StringContains)filter2;
                String attr = stringContains.attribute();
                bl = this.isFilterWithNamedFieldHandled(filter, readDataFormat, fields, attr);
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isFilterWithNamedFieldHandled(Filter filter, DataFormat readDataFormat, Map<String, StructField> fields, String fieldName) {
        return BoxesRunTime.unboxToBoolean((Object)fields.get((Object)fieldName).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)DirectBigQueryRelation$.$anonfun$isFilterWithNamedFieldHandled$1(f))).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DirectBigQueryRelation$.$anonfun$isFilterWithNamedFieldHandled$2(x$4))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> MODULE$.isHandled(filter, readDataFormat)));
    }

    public boolean isHandled(Filter filter, DataFormat readDataFormat) {
        boolean bl;
        block14: {
            Filter filter2;
            while (true) {
                Filter child;
                if ((filter2 = filter) instanceof EqualTo) {
                    bl = true;
                    break block14;
                }
                if (filter2 instanceof EqualNullSafe) {
                    bl = false;
                    break block14;
                }
                if (filter2 instanceof GreaterThan) {
                    bl = true;
                    break block14;
                }
                if (filter2 instanceof GreaterThanOrEqual) {
                    bl = true;
                    break block14;
                }
                if (filter2 instanceof LessThan) {
                    bl = true;
                    break block14;
                }
                if (filter2 instanceof LessThanOrEqual) {
                    bl = true;
                    break block14;
                }
                if (filter2 instanceof In) {
                    bl = true;
                    break block14;
                }
                if (filter2 instanceof IsNull) {
                    bl = true;
                    break block14;
                }
                if (filter2 instanceof IsNotNull) {
                    bl = true;
                    break block14;
                }
                if (filter2 instanceof And) {
                    And and = (And)filter2;
                    Filter lhs = and.left();
                    Filter rhs = and.right();
                    if (this.isHandled(lhs, readDataFormat)) {
                        filter = rhs;
                        continue;
                    }
                    bl = false;
                    break block14;
                }
                if (filter2 instanceof Or) {
                    Or or = (Or)filter2;
                    Filter lhs = or.left();
                    Filter rhs = or.right();
                    DataFormat dataFormat = readDataFormat;
                    DataFormat dataFormat2 = DataFormat.AVRO;
                    if (!(dataFormat != null ? !dataFormat.equals(dataFormat2) : dataFormat2 != null) && this.isHandled(lhs, readDataFormat)) {
                        filter = rhs;
                        continue;
                    }
                    bl = false;
                    break block14;
                }
                if (!(filter2 instanceof Not)) break;
                Not not = (Not)filter2;
                filter = child = not.child();
            }
            bl = filter2 instanceof StringStartsWith ? true : (filter2 instanceof StringEndsWith ? true : filter2 instanceof StringContains);
        }
        return bl;
    }

    public String compileFilter(Filter filter2) {
        String string;
        Filter filter3 = filter2;
        if (filter3 instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter3;
            String attr = equalTo.attribute();
            Object value = equalTo.value();
            string = new StringBuilder(3).append(this.quote(attr)).append(" = ").append(this.compileValue(value)).toString();
        } else if (filter3 instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter3;
            String attr = greaterThan.attribute();
            Object value = greaterThan.value();
            string = new StringBuilder(3).append(attr).append(" > ").append(this.compileValue(value)).toString();
        } else if (filter3 instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter3;
            String attr = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            string = new StringBuilder(4).append(this.quote(attr)).append(" >= ").append(this.compileValue(value)).toString();
        } else if (filter3 instanceof LessThan) {
            LessThan lessThan = (LessThan)filter3;
            String attr = lessThan.attribute();
            Object value = lessThan.value();
            string = new StringBuilder(3).append(this.quote(attr)).append(" < ").append(this.compileValue(value)).toString();
        } else if (filter3 instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter3;
            String attr = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            string = new StringBuilder(4).append(this.quote(attr)).append(" <= ").append(this.compileValue(value)).toString();
        } else if (filter3 instanceof In) {
            In in = (In)filter3;
            String attr = in.attribute();
            Object[] values = in.values();
            string = new StringBuilder(12).append(this.quote(attr)).append(" IN UNNEST(").append(this.compileValue(values)).append(")").toString();
        } else if (filter3 instanceof IsNull) {
            IsNull isNull = (IsNull)filter3;
            String attr = isNull.attribute();
            string = new StringBuilder(8).append(this.quote(attr)).append(" IS NULL").toString();
        } else if (filter3 instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter3;
            String attr = isNotNull.attribute();
            string = new StringBuilder(12).append(this.quote(attr)).append(" IS NOT NULL").toString();
        } else if (filter3 instanceof And) {
            And and = (And)filter3;
            Filter lhs = and.left();
            Filter rhs = and.right();
            string = ((TraversableOnce)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{lhs, rhs}))).map((Function1 & Serializable & scala.Serializable)filter -> MODULE$.compileFilter((Filter)filter), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(2).append("(").append((String)p).append(")").toString(), Seq$.MODULE$.canBuildFrom())).mkString("(", " AND ", ")");
        } else if (filter3 instanceof Or) {
            Or or = (Or)filter3;
            Filter lhs = or.left();
            Filter rhs = or.right();
            string = ((TraversableOnce)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{lhs, rhs}))).map((Function1 & Serializable & scala.Serializable)filter -> MODULE$.compileFilter((Filter)filter), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(2).append("(").append((String)p).append(")").toString(), Seq$.MODULE$.canBuildFrom())).mkString("(", " OR ", ")");
        } else if (filter3 instanceof Not) {
            Not not = (Not)filter3;
            Filter child = not.child();
            string = ((TraversableOnce)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{child}))).map((Function1 & Serializable & scala.Serializable)filter -> MODULE$.compileFilter((Filter)filter), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(8).append("(NOT (").append((String)p).append("))").toString(), Seq$.MODULE$.canBuildFrom())).mkString();
        } else if (filter3 instanceof StringStartsWith) {
            StringStartsWith stringStartsWith = (StringStartsWith)filter3;
            String attr = stringStartsWith.attribute();
            String value = stringStartsWith.value();
            string = new StringBuilder(13).append(this.quote(attr)).append(" LIKE '''").append(value.replace("'", "\\'")).append("%'''").toString();
        } else if (filter3 instanceof StringEndsWith) {
            StringEndsWith stringEndsWith = (StringEndsWith)filter3;
            String attr = stringEndsWith.attribute();
            String value = stringEndsWith.value();
            string = new StringBuilder(13).append(this.quote(attr)).append(" LIKE '''%").append(value.replace("'", "\\'")).append("'''").toString();
        } else if (filter3 instanceof StringContains) {
            StringContains stringContains = (StringContains)filter3;
            String attr = stringContains.attribute();
            String value = stringContains.value();
            string = new StringBuilder(14).append(this.quote(attr)).append(" LIKE '''%").append(value.replace("'", "\\'")).append("%'''").toString();
        } else {
            throw new IllegalArgumentException(new StringBuilder(16).append("Invalid filter: ").append(filter2).toString());
        }
        return string;
    }

    public String compileFilters(Iterable<Filter> filters) {
        return ((TraversableOnce)((TraversableOnce)filters.map((Function1 & Serializable & scala.Serializable)filter -> MODULE$.compileFilter((Filter)filter), Iterable$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString(" AND ");
    }

    private Object compileValue(Object value2) {
        Object object;
        Object object2 = value2;
        if (object2 == null) {
            object = "null";
        } else if (object2 instanceof String) {
            String string = (String)object2;
            object = new StringBuilder(2).append("'").append(string.replace("'", "\\'")).append("'").toString();
        } else if (object2 instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object2;
            object = new StringBuilder(12).append("TIMESTAMP '").append(timestamp).append("'").toString();
        } else if (object2 instanceof Date) {
            Date date = (Date)object2;
            object = new StringBuilder(7).append("DATE '").append(date).append("'").toString();
        } else if (object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object2;
            object = Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps((Object)objectArray).map((Function1 & Serializable & scala.Serializable)value -> MODULE$.compileValue(value), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).mkString("[", ", ", "]");
        } else {
            object = value2;
        }
        return object;
    }

    private String quote(String attr) {
        return new StringBuilder(2).append("`").append(attr).append("`").toString();
    }

    public String toTablePath(TableId tableId) {
        return new StringBuilder(27).append("projects/").append(tableId.getProject()).append("/datasets/").append(tableId.getDataset()).append("/tables/").append(tableId.getTable()).toString();
    }

    public String toSqlTableReference(TableId tableId) {
        return new StringBuilder(2).append(tableId.getProject()).append(".").append(tableId.getDataset()).append(".").append(tableId.getTable()).toString();
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$isFilterWithNamedFieldHandled$1(StructField f) {
        return f.dataType() instanceof StructType || f.dataType() instanceof ArrayType;
    }

    public static final /* synthetic */ boolean $anonfun$isFilterWithNamedFieldHandled$2(StructField x$4) {
        return false;
    }

    private DirectBigQueryRelation$() {
        MODULE$ = this;
        this.emptyRowRDDsCreated = 0;
    }
}

