/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.examples;

import java.io.PrintStream;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;

public class JavaShakespeare {
    public static void main(String[] stringArray) {
        SparkSession sparkSession = SparkSession.builder().appName("spark-bigquery-demo").getOrCreate();
        String string = "wordcount_dataset.wordcount_output";
        if (stringArray.length == 1) {
            string = stringArray[0];
        } else if (stringArray.length > 1) {
            JavaShakespeare.usage();
        }
        String string2 = sparkSession.sparkContext().hadoopConfiguration().get("fs.gs.system.bucket");
        sparkSession.conf().set("temporaryGcsBucket", string2);
        Dataset dataset = sparkSession.read().format("bigquery").option("table", "bigquery-public-data.samples.shakespeare").load().cache();
        dataset.show();
        dataset.printSchema();
        dataset.createOrReplaceTempView("words");
        Dataset dataset2 = sparkSession.sql("SELECT word, SUM(word_count) AS word_count FROM words GROUP BY word");
        dataset2.show();
        dataset2.printSchema();
        dataset2.write().format("bigquery").option("table", string).save();
    }

    private static void usage() {
        PrintStream printStream = System.out;
        printStream.println("usage: spark [OUTPUT_BIGQUERY_TABLE]");
        printStream.println("[OUTPUT_BIGQUERY_TABLE]       Set the output bigquery table to ");
        printStream.println("                              OUTPUT_BIGQUERY_TABLE. By default the location");
        printStream.println("                              is wordcount_dataset.wordcount_output");
        System.exit(1);
    }
}

