/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2;

import com.google.cloud.bigquery.connector.common.ArrowUtil;
import com.google.cloud.bigquery.connector.common.BigQueryStorageReadRowsTracer;
import com.google.cloud.bigquery.connector.common.IteratorMultiplexer;
import com.google.cloud.bigquery.connector.common.NonInterruptibleBlockingBytesChannel;
import com.google.cloud.bigquery.connector.common.ParallelArrowReader;
import com.google.cloud.bigquery.connector.common.ReadRowsHelper;
import com.google.cloud.bigquery.connector.common.ReadRowsResponseInputStreamEnumeration;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.spark.bigquery.ArrowSchemaConverter;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.arrow.compression.CommonsCompressionFactory;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.compression.CompressionCodec;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.sql.sources.v2.reader.InputPartitionReader;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;

class ArrowColumnBatchPartitionColumnBatchReader
implements InputPartitionReader<ColumnarBatch> {
    private static final long maxAllocation = 524288000L;
    private final ReadRowsHelper readRowsHelper;
    private final ArrowReaderAdapter reader;
    private final BufferAllocator allocator;
    private final List<String> namesInOrder;
    private ColumnarBatch currentBatch;
    private final BigQueryStorageReadRowsTracer tracer;
    private boolean closed = false;
    private final Map<String, StructField> userProvidedFieldMap;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();

    ArrowColumnBatchPartitionColumnBatchReader(Iterator<ReadRowsResponse> iterator, ByteString byteString, ReadRowsHelper readRowsHelper, List<String> list, BigQueryStorageReadRowsTracer bigQueryStorageReadRowsTracer, Optional<StructType> optional, int n) {
        this.allocator = ArrowUtil.newRootAllocator(524288000L);
        this.readRowsHelper = readRowsHelper;
        this.namesInOrder = list;
        this.tracer = bigQueryStorageReadRowsTracer;
        this.closeables.add(null);
        List list2 = Arrays.stream(optional.orElse(new StructType()).fields()).collect(Collectors.toList());
        this.userProvidedFieldMap = list2.stream().collect(Collectors.toMap(StructField::name, structField -> structField));
        if (n == 1) {
            InputStream inputStream = this.makeSingleInputStream(iterator, byteString, bigQueryStorageReadRowsTracer);
            this.reader = new ParallelReaderAdapter(this.allocator, (List<ArrowReader>)ImmutableList.of((Object)this.newArrowStreamReader(inputStream)), (ExecutorService)MoreExecutors.newDirectExecutorService(), bigQueryStorageReadRowsTracer.forkWithPrefix("BackgroundReader"), null);
        } else if (n > 1) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, n - 1, 2L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
            IteratorMultiplexer<ReadRowsResponse> iteratorMultiplexer = new IteratorMultiplexer<ReadRowsResponse>(iterator, n);
            ArrayList<ArrowReader> arrayList = new ArrayList<ArrowReader>();
            for (int i = 0; i < n; ++i) {
                BigQueryStorageReadRowsTracer bigQueryStorageReadRowsTracer2 = bigQueryStorageReadRowsTracer.forkWithPrefix("multiplexed-" + i);
                SequenceInputStream sequenceInputStream = new SequenceInputStream(new ReadRowsResponseInputStreamEnumeration(iteratorMultiplexer.getSplit(i), bigQueryStorageReadRowsTracer2));
                SequenceInputStream sequenceInputStream2 = new SequenceInputStream(byteString.newInput(), sequenceInputStream);
                this.closeables.add(bigQueryStorageReadRowsTracer2::finished);
                arrayList.add((ArrowReader)this.newArrowStreamReader(sequenceInputStream2));
            }
            this.reader = new ParallelReaderAdapter(this.allocator, arrayList, threadPoolExecutor, bigQueryStorageReadRowsTracer.forkWithPrefix("MultithreadReader"), iteratorMultiplexer);
        } else {
            InputStream inputStream = this.makeSingleInputStream(iterator, byteString, bigQueryStorageReadRowsTracer);
            this.reader = new SimpleAdapter((ArrowReader)this.newArrowStreamReader(inputStream));
        }
    }

    private InputStream makeSingleInputStream(Iterator<ReadRowsResponse> iterator, ByteString byteString, BigQueryStorageReadRowsTracer bigQueryStorageReadRowsTracer) {
        SequenceInputStream sequenceInputStream = new SequenceInputStream(new ReadRowsResponseInputStreamEnumeration(iterator, bigQueryStorageReadRowsTracer));
        return new SequenceInputStream(byteString.newInput(), sequenceInputStream);
    }

    public boolean next() throws IOException {
        this.tracer.nextBatchNeeded();
        if (this.closed) {
            return false;
        }
        this.tracer.rowsParseStarted();
        boolean bl = this.closed = !this.reader.loadNextBatch();
        if (this.closed) {
            return false;
        }
        VectorSchemaRoot vectorSchemaRoot = this.reader.root();
        if (this.currentBatch == null) {
            ColumnVector[] columnVectorArray = (ColumnVector[])this.namesInOrder.stream().map(arg_0 -> ((VectorSchemaRoot)vectorSchemaRoot).getVector(arg_0)).map(fieldVector -> new ArrowSchemaConverter((ValueVector)fieldVector, this.userProvidedFieldMap.get(fieldVector.getName()))).toArray(ColumnVector[]::new);
            this.currentBatch = new ColumnarBatch(columnVectorArray);
        }
        this.currentBatch.setNumRows(vectorSchemaRoot.getRowCount());
        this.tracer.rowsParseFinished(this.currentBatch.numRows());
        return true;
    }

    public ColumnarBatch get() {
        return this.currentBatch;
    }

    public void close() throws IOException {
        this.closed = true;
        try {
            this.tracer.finished();
            this.closeables.set(0, this.reader);
            this.closeables.add((AutoCloseable)this.allocator);
            AutoCloseables.close(this.closeables);
        }
        catch (Exception exception) {
            throw new IOException("Failure closing arrow components. stream: " + this.readRowsHelper, exception);
        }
        finally {
            try {
                this.readRowsHelper.close();
            }
            catch (Exception exception) {
                throw new IOException("Failure closing stream: " + this.readRowsHelper, exception);
            }
        }
    }

    private ArrowStreamReader newArrowStreamReader(InputStream inputStream) {
        BufferAllocator bufferAllocator = this.allocator.newChildAllocator("readerAllocator" + (this.closeables.size() - 1), 0L, 524288000L);
        this.closeables.add((AutoCloseable)bufferAllocator);
        return new ArrowStreamReader((ReadableByteChannel)new NonInterruptibleBlockingBytesChannel(inputStream), bufferAllocator, (CompressionCodec.Factory)CommonsCompressionFactory.INSTANCE);
    }

    static class ParallelReaderAdapter
    implements ArrowReaderAdapter {
        private final ParallelArrowReader reader;
        private final VectorLoader loader;
        private final VectorSchemaRoot root;
        private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
        private IOException initialException;

        ParallelReaderAdapter(BufferAllocator bufferAllocator, List<ArrowReader> list, ExecutorService executorService, BigQueryStorageReadRowsTracer bigQueryStorageReadRowsTracer, AutoCloseable autoCloseable) {
            Schema schema = null;
            this.closeables.add(autoCloseable);
            try {
                schema = list.get(0).getVectorSchemaRoot().getSchema();
            }
            catch (IOException iOException) {
                this.initialException = iOException;
                this.closeables.addAll(list);
                this.reader = null;
                this.loader = null;
                this.root = null;
                return;
            }
            BufferAllocator bufferAllocator2 = bufferAllocator.newChildAllocator("ParallelReaderAllocator", 0L, 524288000L);
            this.root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)bufferAllocator2);
            this.closeables.add((AutoCloseable)this.root);
            this.loader = new VectorLoader(this.root);
            this.reader = new ParallelArrowReader(list, executorService, this.loader, bigQueryStorageReadRowsTracer);
            this.closeables.add(0, this.reader);
            this.closeables.add((AutoCloseable)bufferAllocator2);
        }

        @Override
        public boolean loadNextBatch() throws IOException {
            if (this.initialException != null) {
                throw new IOException(this.initialException);
            }
            return this.reader.next();
        }

        @Override
        public VectorSchemaRoot root() throws IOException {
            return this.root;
        }

        @Override
        public void close() throws Exception {
            AutoCloseables.close(this.closeables);
        }
    }

    static class SimpleAdapter
    implements ArrowReaderAdapter {
        private final ArrowReader reader;

        SimpleAdapter(ArrowReader arrowReader) {
            this.reader = arrowReader;
        }

        @Override
        public boolean loadNextBatch() throws IOException {
            return this.reader.loadNextBatch();
        }

        @Override
        public VectorSchemaRoot root() throws IOException {
            return this.reader.getVectorSchemaRoot();
        }

        @Override
        public void close() throws Exception {
            this.reader.close(false);
        }
    }

    static interface ArrowReaderAdapter
    extends AutoCloseable {
        public boolean loadNextBatch() throws IOException;

        public VectorSchemaRoot root() throws IOException;
    }
}

