/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2;

import com.google.cloud.bigquery.connector.common.BigQueryReadClientFactory;
import com.google.cloud.bigquery.connector.common.BigQueryStorageReadRowsTracer;
import com.google.cloud.bigquery.connector.common.BigQueryTracerFactory;
import com.google.cloud.bigquery.connector.common.ReadRowsHelper;
import com.google.cloud.bigquery.connector.common.ReadSessionResponse;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.spark.bigquery.v2.ArrowColumnBatchPartitionColumnBatchReader;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.spark.sql.sources.v2.reader.InputPartition;
import org.apache.spark.sql.sources.v2.reader.InputPartitionReader;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public class ArrowInputPartition
implements InputPartition<ColumnarBatch> {
    private final BigQueryReadClientFactory bigQueryReadClientFactory;
    private final BigQueryTracerFactory tracerFactory;
    private final List<String> streamNames;
    private final ReadRowsHelper.Options options;
    private final ImmutableList<String> selectedFields;
    private final ByteString serializedArrowSchema;
    private final com.google.common.base.Optional<StructType> userProvidedSchema;

    public ArrowInputPartition(BigQueryReadClientFactory bigQueryReadClientFactory, BigQueryTracerFactory bigQueryTracerFactory, List<String> list, ReadRowsHelper.Options options, ImmutableList<String> immutableList, ReadSessionResponse readSessionResponse, Optional<StructType> optional) {
        this.bigQueryReadClientFactory = bigQueryReadClientFactory;
        this.streamNames = list;
        this.options = options;
        this.selectedFields = immutableList;
        this.serializedArrowSchema = readSessionResponse.getReadSession().getArrowSchema().getSerializedSchema();
        this.tracerFactory = bigQueryTracerFactory;
        this.userProvidedSchema = com.google.common.base.Optional.fromJavaUtil(optional);
    }

    public InputPartitionReader<ColumnarBatch> createPartitionReader() {
        BigQueryStorageReadRowsTracer bigQueryStorageReadRowsTracer = this.tracerFactory.newReadRowsTracer(Joiner.on((String)",").join(this.streamNames));
        List<ReadRowsRequest.Builder> list = this.streamNames.stream().map(string -> ReadRowsRequest.newBuilder().setReadStream(string)).collect(Collectors.toList());
        ReadRowsHelper readRowsHelper = new ReadRowsHelper(this.bigQueryReadClientFactory, list, this.options);
        bigQueryStorageReadRowsTracer.startStream();
        Iterator<ReadRowsResponse> iterator = readRowsHelper.readRows();
        return new ArrowColumnBatchPartitionColumnBatchReader(iterator, this.serializedArrowSchema, readRowsHelper, (List<String>)this.selectedFields, bigQueryStorageReadRowsTracer, this.userProvidedSchema.toJavaUtil(), this.options.numBackgroundThreads());
    }
}

