/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.bigquery.connector.common.BigQueryReadClientFactory;
import com.google.cloud.bigquery.connector.common.BigQueryTracerFactory;
import com.google.cloud.bigquery.connector.common.ReadSessionCreator;
import com.google.cloud.bigquery.connector.common.ReadSessionCreatorConfig;
import com.google.cloud.bigquery.connector.common.ReadSessionResponse;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.ReadStream;
import com.google.cloud.spark.bigquery.ReadRowsResponseToInternalRowIteratorConverter;
import com.google.cloud.spark.bigquery.SchemaConverters;
import com.google.cloud.spark.bigquery.SparkFilterUtils;
import com.google.cloud.spark.bigquery.v2.ArrowInputPartition;
import com.google.cloud.spark.bigquery.v2.BigQueryEmptyProjectionInputPartition;
import com.google.cloud.spark.bigquery.v2.BigQueryInputPartition;
import com.google.cloud.spark.bigquery.v2.StandardTableStatistics;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.v2.reader.DataSourceReader;
import org.apache.spark.sql.sources.v2.reader.InputPartition;
import org.apache.spark.sql.sources.v2.reader.Statistics;
import org.apache.spark.sql.sources.v2.reader.SupportsPushDownFilters;
import org.apache.spark.sql.sources.v2.reader.SupportsPushDownRequiredColumns;
import org.apache.spark.sql.sources.v2.reader.SupportsReportStatistics;
import org.apache.spark.sql.sources.v2.reader.SupportsScanColumnarBatch;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class BigQueryDataSourceReader
implements DataSourceReader,
SupportsPushDownRequiredColumns,
SupportsPushDownFilters,
SupportsReportStatistics,
SupportsScanColumnarBatch {
    private static final Logger logger = LoggerFactory.getLogger(BigQueryDataSourceReader.class);
    private static Statistics UNKNOWN_STATISTICS = new Statistics(){

        public OptionalLong sizeInBytes() {
            return OptionalLong.empty();
        }

        public OptionalLong numRows() {
            return OptionalLong.empty();
        }
    };
    private final TableInfo table;
    private final TableId tableId;
    private final ReadSessionCreatorConfig readSessionCreatorConfig;
    private final BigQueryClient bigQueryClient;
    private final BigQueryReadClientFactory bigQueryReadClientFactory;
    private final BigQueryTracerFactory bigQueryTracerFactory;
    private final ReadSessionCreator readSessionCreator;
    private final Optional<String> globalFilter;
    private final String applicationId;
    private Optional<StructType> schema;
    private Optional<StructType> userProvidedSchema;
    private Filter[] pushedFilters = new Filter[0];
    private Map<String, StructField> fields;

    public BigQueryDataSourceReader(TableInfo tableInfo, BigQueryClient bigQueryClient, BigQueryReadClientFactory bigQueryReadClientFactory, BigQueryTracerFactory bigQueryTracerFactory, ReadSessionCreatorConfig readSessionCreatorConfig, Optional<String> optional, Optional<StructType> optional2, String string) {
        this.table = tableInfo;
        this.tableId = tableInfo.getTableId();
        this.readSessionCreatorConfig = readSessionCreatorConfig;
        this.bigQueryClient = bigQueryClient;
        this.bigQueryReadClientFactory = bigQueryReadClientFactory;
        this.bigQueryTracerFactory = bigQueryTracerFactory;
        this.readSessionCreator = new ReadSessionCreator(readSessionCreatorConfig, bigQueryClient, bigQueryReadClientFactory);
        this.globalFilter = optional;
        StructType structType = SchemaConverters.toSpark(SchemaConverters.getSchemaWithPseudoColumns(tableInfo));
        if (optional2.isPresent()) {
            this.schema = optional2;
            this.userProvidedSchema = optional2;
        } else {
            this.schema = Optional.of(structType);
            this.userProvidedSchema = Optional.empty();
        }
        this.fields = new LinkedHashMap<String, StructField>();
        for (StructField structField : JavaConversions.seqAsJavaList((Seq)structType)) {
            this.fields.put(structField.name(), structField);
        }
        this.applicationId = string;
    }

    public StructType readSchema() {
        return this.schema.orElse(SchemaConverters.toSpark(SchemaConverters.getSchemaWithPseudoColumns(this.table)));
    }

    public boolean enableBatchRead() {
        return this.readSessionCreatorConfig.getReadDataFormat() == DataFormat.ARROW && !this.isEmptySchema();
    }

    public List<InputPartition<InternalRow>> planInputPartitions() {
        if (this.isEmptySchema()) {
            return this.createEmptyProjectionPartitions();
        }
        ImmutableList immutableList = this.schema.map(structType -> ImmutableList.copyOf((Object[])structType.fieldNames())).orElse(ImmutableList.of());
        Optional<String> optional = this.emptyIfNeeded(SparkFilterUtils.getCompiledFilter(this.readSessionCreatorConfig.getPushAllFilters(), this.readSessionCreatorConfig.getReadDataFormat(), this.globalFilter, this.pushedFilters));
        ReadSessionResponse readSessionResponse = this.readSessionCreator.create(this.tableId, (ImmutableList<String>)immutableList, optional);
        ReadSession readSession = readSessionResponse.getReadSession();
        logger.info("Created read session for {}: {} for application id: {}", new Object[]{this.tableId.toString(), readSession.getName(), this.applicationId});
        return readSession.getStreamsList().stream().map(readStream -> new BigQueryInputPartition(this.bigQueryReadClientFactory, readStream.getName(), this.readSessionCreatorConfig.toReadRowsHelperOptions(), this.createConverter((ImmutableList<String>)immutableList, readSessionResponse, this.userProvidedSchema))).collect(Collectors.toList());
    }

    public List<InputPartition<ColumnarBatch>> planBatchInputPartitions() {
        ImmutableList immutableList;
        if (!this.enableBatchRead()) {
            throw new IllegalStateException("Batch reads should not be enabled");
        }
        ImmutableList immutableList2 = this.schema.map(structType -> ImmutableList.copyOf((Object[])structType.fieldNames())).orElse(ImmutableList.copyOf(this.fields.keySet()));
        Optional<String> optional = this.emptyIfNeeded(SparkFilterUtils.getCompiledFilter(this.readSessionCreatorConfig.getPushAllFilters(), this.readSessionCreatorConfig.getReadDataFormat(), this.globalFilter, this.pushedFilters));
        ReadSessionResponse readSessionResponse = this.readSessionCreator.create(this.tableId, (ImmutableList<String>)immutableList2, optional);
        ReadSession readSession = readSessionResponse.getReadSession();
        logger.info("Created read session for {}: {} for application id: {}", new Object[]{this.tableId.toString(), readSession.getName(), this.applicationId});
        if (immutableList2.isEmpty()) {
            immutableList = SchemaConverters.getSchemaWithPseudoColumns(readSessionResponse.getReadTableInfo());
            immutableList2 = (ImmutableList)immutableList.getFields().stream().map(Field::getName).collect(ImmutableList.toImmutableList());
        }
        immutableList = immutableList2;
        return Streams.stream((Iterable)Iterables.partition((Iterable)readSession.getStreamsList(), (int)this.readSessionCreatorConfig.streamsPerPartition())).map(list -> new ArrowInputPartition(this.bigQueryReadClientFactory, this.bigQueryTracerFactory, list.stream().map(ReadStream::getName).collect(Collectors.toCollection(ArrayList::new)), this.readSessionCreatorConfig.toReadRowsHelperOptions(), (ImmutableList<String>)immutableList, readSessionResponse, this.userProvidedSchema)).collect(Collectors.toList());
    }

    private boolean isEmptySchema() {
        return this.schema.map(StructType::isEmpty).orElse(false);
    }

    private ReadRowsResponseToInternalRowIteratorConverter createConverter(ImmutableList<String> immutableList, ReadSessionResponse readSessionResponse, Optional<StructType> optional) {
        DataFormat dataFormat = this.readSessionCreatorConfig.getReadDataFormat();
        if (dataFormat == DataFormat.AVRO) {
            Schema schema = SchemaConverters.getSchemaWithPseudoColumns(readSessionResponse.getReadTableInfo());
            if (immutableList.isEmpty()) {
                immutableList = (ImmutableList)schema.getFields().stream().map(Field::getName).collect(ImmutableList.toImmutableList());
            } else {
                ImmutableSet immutableSet = ImmutableSet.copyOf(immutableList);
                schema = Schema.of((Iterable)schema.getFields().stream().filter(arg_0 -> BigQueryDataSourceReader.lambda$createConverter$4((Set)immutableSet, arg_0)).collect(Collectors.toList()));
            }
            return ReadRowsResponseToInternalRowIteratorConverter.avro(schema, (List<String>)immutableList, readSessionResponse.getReadSession().getAvroSchema().getSchema(), optional);
        }
        throw new IllegalArgumentException("No known converted for " + this.readSessionCreatorConfig.getReadDataFormat());
    }

    List<InputPartition<InternalRow>> createEmptyProjectionPartitions() {
        long l = this.bigQueryClient.calculateTableSize(this.tableId, this.globalFilter);
        logger.info("Used optimized BQ count(*) path. Count: " + l);
        int n = this.readSessionCreatorConfig.getDefaultParallelism();
        int n3 = (int)(l / (long)n);
        Object[] objectArray = (InputPartition[])IntStream.range(0, n).mapToObj(n2 -> new BigQueryEmptyProjectionInputPartition(n3)).toArray(BigQueryEmptyProjectionInputPartition[]::new);
        int n4 = n3 + (int)(l % (long)n);
        objectArray[0] = new BigQueryEmptyProjectionInputPartition(n4);
        return ImmutableList.copyOf((Object[])objectArray);
    }

    public Filter[] pushFilters(Filter[] filterArray) {
        ArrayList<Filter> arrayList = new ArrayList<Filter>();
        ArrayList<Filter> arrayList2 = new ArrayList<Filter>();
        for (Filter filter : filterArray) {
            if (SparkFilterUtils.isTopLevelFieldHandled(this.readSessionCreatorConfig.getPushAllFilters(), filter, this.readSessionCreatorConfig.getReadDataFormat(), this.fields)) {
                arrayList.add(filter);
                continue;
            }
            arrayList2.add(filter);
        }
        this.pushedFilters = (Filter[])arrayList.stream().toArray(Filter[]::new);
        return (Filter[])arrayList2.stream().toArray(Filter[]::new);
    }

    public Filter[] pushedFilters() {
        return this.pushedFilters;
    }

    public void pruneColumns(StructType structType) {
        this.schema = Optional.ofNullable(structType);
    }

    Optional<String> emptyIfNeeded(String string) {
        return string == null || string.length() == 0 ? Optional.empty() : Optional.of(string);
    }

    public Statistics estimateStatistics() {
        return this.table.getDefinition().getType() == TableDefinition.Type.TABLE ? new StandardTableStatistics((StandardTableDefinition)this.table.getDefinition()) : UNKNOWN_STATISTICS;
    }

    private static /* synthetic */ boolean lambda$createConverter$4(Set set, Field field) {
        return set.contains(field.getName());
    }
}

