/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2;

import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.bigquery.connector.common.BigQueryClientModule;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.spark.bigquery.DataSourceVersion;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.v2.BigQueryDataSourceReader;
import com.google.cloud.spark.bigquery.v2.BigQueryDataSourceReaderModule;
import com.google.cloud.spark.bigquery.v2.BigQueryDataSourceWriterModule;
import com.google.cloud.spark.bigquery.v2.BigQueryIndirectDataSourceWriter;
import com.google.cloud.spark.bigquery.v2.SparkBigQueryConnectorModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Optional;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.DataSourceV2;
import org.apache.spark.sql.sources.v2.ReadSupport;
import org.apache.spark.sql.sources.v2.WriteSupport;
import org.apache.spark.sql.sources.v2.reader.DataSourceReader;
import org.apache.spark.sql.sources.v2.writer.DataSourceWriter;
import org.apache.spark.sql.types.StructType;
import scala.Option;

public class BigQueryDataSourceV2
implements DataSourceV2,
ReadSupport,
WriteSupport {
    public DataSourceReader createReader(StructType structType, DataSourceOptions dataSourceOptions) {
        Injector injector = this.createInjector(structType, dataSourceOptions, new BigQueryDataSourceReaderModule());
        BigQueryDataSourceReader bigQueryDataSourceReader = (BigQueryDataSourceReader)injector.getInstance(BigQueryDataSourceReader.class);
        return bigQueryDataSourceReader;
    }

    private Injector createInjector(StructType structType, DataSourceOptions dataSourceOptions, Module module) {
        SparkSession sparkSession = this.getDefaultSparkSessionOrCreate();
        return Guice.createInjector((Module[])new Module[]{new BigQueryClientModule(), new SparkBigQueryConnectorModule(sparkSession, dataSourceOptions.asMap(), Optional.ofNullable(structType), DataSourceVersion.V2), module});
    }

    private SparkSession getDefaultSparkSessionOrCreate() {
        Option option = SparkSession.getActiveSession();
        if (option.isDefined()) {
            return (SparkSession)option.get();
        }
        return SparkSession.builder().appName("spark-bigquery-connector").getOrCreate();
    }

    public DataSourceReader createReader(DataSourceOptions dataSourceOptions) {
        return this.createReader(null, dataSourceOptions);
    }

    public Optional<DataSourceWriter> createWriter(String string, StructType structType, SaveMode saveMode, DataSourceOptions dataSourceOptions) {
        SparkBigQueryConfig sparkBigQueryConfig;
        Injector injector = this.createInjector(structType, dataSourceOptions, new BigQueryDataSourceWriterModule(string, structType, saveMode));
        BigQueryClient bigQueryClient = (BigQueryClient)injector.getInstance(BigQueryClient.class);
        TableInfo tableInfo = bigQueryClient.getTable((sparkBigQueryConfig = (SparkBigQueryConfig)injector.getInstance(SparkBigQueryConfig.class)).getTableId());
        if (tableInfo != null) {
            if (saveMode == SaveMode.Ignore) {
                return Optional.empty();
            }
            if (saveMode == SaveMode.ErrorIfExists) {
                throw new IllegalArgumentException(String.format("SaveMode is set to ErrorIfExists and table '%s' already exists. Did you want to add data to the table by setting the SaveMode to Append? Example: df.write.format.options.mode(\"append\").save()", BigQueryUtil.friendlyTableName(tableInfo.getTableId())));
            }
        } else {
            boolean bl = sparkBigQueryConfig.getCreateDisposition().map(createDisposition -> createDisposition == JobInfo.CreateDisposition.CREATE_NEVER).orElse(false);
            if (bl) {
                throw new IllegalArgumentException(String.format("For table %s Create Disposition is CREATE_NEVER and the table does not exists. Aborting the insert", BigQueryUtil.friendlyTableName(sparkBigQueryConfig.getTableId())));
            }
        }
        BigQueryIndirectDataSourceWriter bigQueryIndirectDataSourceWriter = (BigQueryIndirectDataSourceWriter)injector.getInstance(BigQueryIndirectDataSourceWriter.class);
        return Optional.of(bigQueryIndirectDataSourceWriter);
    }
}

