/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2;

import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.v2.BigQueryIndirectDataSourceWriter;
import com.google.cloud.spark.bigquery.v2.IntermediateDataCleaner;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;

class BigQueryDataSourceWriterModule
implements Module {
    private final String writeUUID;
    private final StructType sparkSchema;
    private final SaveMode mode;

    BigQueryDataSourceWriterModule(String string, StructType structType, SaveMode saveMode) {
        this.writeUUID = string;
        this.sparkSchema = structType;
        this.mode = saveMode;
    }

    public void configure(Binder binder) {
    }

    @Singleton
    @Provides
    public BigQueryIndirectDataSourceWriter provideDataSourceWriter(BigQueryClient bigQueryClient, SparkBigQueryConfig sparkBigQueryConfig, SparkSession sparkSession) throws IOException {
        Path path = this.createGcsPath(sparkBigQueryConfig, sparkSession.sparkContext().hadoopConfiguration(), sparkSession.sparkContext().applicationId());
        Optional<IntermediateDataCleaner> optional = sparkBigQueryConfig.getTemporaryGcsBucket().map(string -> new IntermediateDataCleaner(path, sparkSession.sparkContext().hadoopConfiguration()));
        optional.ifPresent(intermediateDataCleaner -> Runtime.getRuntime().addShutdownHook((Thread)intermediateDataCleaner));
        return new BigQueryIndirectDataSourceWriter(bigQueryClient, sparkBigQueryConfig, sparkSession.sparkContext().hadoopConfiguration(), this.sparkSchema, this.writeUUID, this.mode, path, optional);
    }

    Path createGcsPath(SparkBigQueryConfig sparkBigQueryConfig, Configuration configuration, String string) throws IOException {
        Preconditions.checkArgument((sparkBigQueryConfig.getTemporaryGcsBucket().isPresent() || sparkBigQueryConfig.getPersistentGcsBucket().isPresent() ? 1 : 0) != 0, (Object)"Temporary or persistent GCS bucket must be informed.");
        boolean bl = true;
        Path path = null;
        while (bl) {
            String string3 = sparkBigQueryConfig.getTemporaryGcsBucket().map(string2 -> String.format("gs://%s/.spark-bigquery-%s-%s", string2, string, UUID.randomUUID())).orElseGet(() -> {
                String string2 = sparkBigQueryConfig.getPersistentGcsPath().orElse(String.format(".spark-bigquery-%s-%s", string, UUID.randomUUID()));
                return String.format("gs://%s/%s", sparkBigQueryConfig.getPersistentGcsBucket().get(), string2);
            });
            path = new Path(string3);
            FileSystem fileSystem = path.getFileSystem(configuration);
            bl = fileSystem.exists(path);
        }
        return path;
    }
}

