/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2;

import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.Clustering;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.LoadJobConfiguration;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.spark.bigquery.AvroSchemaConverter;
import com.google.cloud.spark.bigquery.SchemaConverters;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.SparkBigQueryUtil;
import com.google.cloud.spark.bigquery.SupportedCustomDataType;
import com.google.cloud.spark.bigquery.v2.BigQueryIndirectDataWriterFactory;
import com.google.cloud.spark.bigquery.v2.BigQueryIndirectWriterCommitMessage;
import com.google.cloud.spark.bigquery.v2.IntermediateDataCleaner;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.beam.sdk.io.hadoop.SerializableConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.v2.writer.DataSourceWriter;
import org.apache.spark.sql.sources.v2.writer.DataWriterFactory;
import org.apache.spark.sql.sources.v2.writer.WriterCommitMessage;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryIndirectDataSourceWriter
implements DataSourceWriter {
    private static final Logger logger = LoggerFactory.getLogger(BigQueryIndirectDataSourceWriter.class);
    private final BigQueryClient bigQueryClient;
    private final SparkBigQueryConfig config;
    private final Configuration hadoopConfiguration;
    private final StructType sparkSchema;
    private final String writeUUID;
    private final SaveMode saveMode;
    private final Path gcsPath;
    private final Optional<IntermediateDataCleaner> intermediateDataCleaner;

    public BigQueryIndirectDataSourceWriter(BigQueryClient bigQueryClient, SparkBigQueryConfig sparkBigQueryConfig, Configuration configuration, StructType structType, String string, SaveMode saveMode, Path path, Optional<IntermediateDataCleaner> optional) {
        this.bigQueryClient = bigQueryClient;
        this.config = sparkBigQueryConfig;
        this.hadoopConfiguration = configuration;
        this.sparkSchema = structType;
        this.writeUUID = string;
        this.saveMode = saveMode;
        this.gcsPath = path;
        this.intermediateDataCleaner = optional;
    }

    static <T> Iterable<T> wrap(final RemoteIterator<T> remoteIterator) {
        return () -> new Iterator<T>(){

            @Override
            public boolean hasNext() {
                try {
                    return remoteIterator.hasNext();
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException(iOException);
                }
            }

            @Override
            public T next() {
                try {
                    return remoteIterator.next();
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException(iOException);
                }
            }
        };
    }

    public DataWriterFactory<InternalRow> createWriterFactory() {
        org.apache.avro.Schema schema = AvroSchemaConverter.sparkSchemaToAvroSchema(this.sparkSchema);
        return new BigQueryIndirectDataWriterFactory(new SerializableConfiguration(this.hadoopConfiguration), this.gcsPath.toString(), this.sparkSchema, schema.toString());
    }

    public void commit(WriterCommitMessage[] writerCommitMessageArray) {
        logger.info("Data has been successfully written to GCS. Going to load {} files to BigQuery", (Object)writerCommitMessageArray.length);
        try {
            List<String> list = Stream.of(writerCommitMessageArray).map(writerCommitMessage -> ((BigQueryIndirectWriterCommitMessage)writerCommitMessage).getUri()).collect(Collectors.toList());
            this.loadDataToBigQuery(list);
            this.updateMetadataIfNeeded();
            logger.info("Data has been successfully loaded to BigQuery");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        finally {
            this.cleanTemporaryGcsPathIfNeeded();
        }
    }

    public void abort(WriterCommitMessage[] writerCommitMessageArray) {
        try {
            logger.warn("Aborting write {} for table {}", (Object)this.writeUUID, (Object)BigQueryUtil.friendlyTableName(this.config.getTableId()));
        }
        finally {
            this.cleanTemporaryGcsPathIfNeeded();
        }
    }

    void loadDataToBigQuery(List<String> list) throws IOException {
        TimePartitioning.Builder builder;
        List<String> list2 = SparkBigQueryUtil.optimizeLoadUriListForSpark(list);
        Schema schema = SchemaConverters.toBigQuerySchema(this.sparkSchema);
        LoadJobConfiguration.Builder builder2 = LoadJobConfiguration.newBuilder((TableId)this.config.getTableId(), list2, (FormatOptions)this.config.getIntermediateFormat().getFormatOptions()).setCreateDisposition(JobInfo.CreateDisposition.CREATE_IF_NEEDED).setWriteDisposition(this.saveModeToWriteDisposition(this.saveMode)).setSchema(schema).setAutodetect(Boolean.valueOf(true));
        this.config.getCreateDisposition().ifPresent(arg_0 -> ((LoadJobConfiguration.Builder)builder2).setCreateDisposition(arg_0));
        if (this.config.getPartitionField().isPresent() || this.config.getPartitionType().isPresent()) {
            builder = TimePartitioning.newBuilder((TimePartitioning.Type)this.config.getPartitionTypeOrDefault());
            this.config.getPartitionExpirationMs().ifPresent(arg_0 -> ((TimePartitioning.Builder)builder).setExpirationMs(arg_0));
            this.config.getPartitionRequireFilter().ifPresent(arg_0 -> ((TimePartitioning.Builder)builder).setRequirePartitionFilter(arg_0));
            this.config.getPartitionField().ifPresent(arg_0 -> ((TimePartitioning.Builder)builder).setField(arg_0));
            builder2.setTimePartitioning(builder.build());
        }
        this.config.getClusteredFields().ifPresent(immutableList -> {
            Clustering clustering = Clustering.newBuilder().setFields((List)immutableList).build();
            builder2.setClustering(clustering);
        });
        if (!this.config.getLoadSchemaUpdateOptions().isEmpty()) {
            builder2.setSchemaUpdateOptions(this.config.getLoadSchemaUpdateOptions());
        }
        if ((builder = this.bigQueryClient.createAndWaitFor((JobConfiguration.Builder)builder2)).getStatus().getError() != null) {
            throw new BigQueryException(0, String.format("Failed to load to %s in job %s. BigQuery error was '%s'", BigQueryUtil.friendlyTableName(this.config.getTableId()), builder.getJobId(), builder.getStatus().getError().getMessage()), builder.getStatus().getError());
        }
        logger.info("Done loading to {}. jobId: {}", (Object)BigQueryUtil.friendlyTableName(this.config.getTableId()), (Object)builder.getJobId());
    }

    JobInfo.WriteDisposition saveModeToWriteDisposition(SaveMode saveMode) {
        if (saveMode == SaveMode.ErrorIfExists) {
            return JobInfo.WriteDisposition.WRITE_EMPTY;
        }
        if (saveMode == SaveMode.Append || saveMode == SaveMode.Ignore) {
            return JobInfo.WriteDisposition.WRITE_APPEND;
        }
        if (saveMode == SaveMode.Overwrite) {
            return JobInfo.WriteDisposition.WRITE_TRUNCATE;
        }
        throw new UnsupportedOperationException("SaveMode " + saveMode + " is currently not supported.");
    }

    void updateMetadataIfNeeded() {
        Map map = Stream.of(this.sparkSchema.fields()).filter(structField -> SupportedCustomDataType.of(structField.dataType()).isPresent() || SchemaConverters.getDescriptionOrCommentOfField(structField).isPresent()).collect(Collectors.toMap(StructField::name, Function.identity()));
        if (!map.isEmpty()) {
            logger.debug("updating schema, found fields to update: {}", map.keySet());
            TableInfo tableInfo = this.bigQueryClient.getTable(this.config.getTableIdWithoutThePartition());
            TableDefinition tableDefinition = tableInfo.getDefinition();
            Schema schema = tableDefinition.getSchema();
            Schema schema2 = Schema.of((Iterable)schema.getFields().stream().map(field -> Optional.ofNullable(map.get(field.getName())).map(structField -> this.updatedField((Field)field, (StructField)structField)).orElse((Field)field)).collect(Collectors.toList()));
            TableInfo.Builder builder = tableInfo.toBuilder().setDefinition(tableDefinition.toBuilder().setSchema(schema2).build());
            this.bigQueryClient.update(builder.build());
        }
    }

    Field updatedField(Field field, StructField structField) {
        Field.Builder builder = field.toBuilder();
        Optional<String> optional = SchemaConverters.getDescriptionOrCommentOfField(structField);
        if (optional.isPresent()) {
            builder.setDescription(optional.get());
        } else {
            String string = field.getDescription();
            String string2 = SupportedCustomDataType.of(structField.dataType()).get().getTypeMarker();
            if (string == null) {
                builder.setDescription(string2);
            } else if (!string.endsWith(string2)) {
                builder.setDescription(string + " " + string2);
            }
        }
        return builder.build();
    }

    void cleanTemporaryGcsPathIfNeeded() {
        this.intermediateDataCleaner.ifPresent(intermediateDataCleaner -> intermediateDataCleaner.deletePath());
    }
}

