/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2;

import com.google.cloud.spark.bigquery.AvroSchemaConverter;
import com.google.cloud.spark.bigquery.v2.BigQueryIndirectWriterCommitMessage;
import com.google.cloud.spark.bigquery.v2.IntermediateRecordWriter;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.v2.writer.DataWriter;
import org.apache.spark.sql.sources.v2.writer.WriterCommitMessage;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BigQueryIndirectDataWriter
implements DataWriter<InternalRow> {
    private static final Logger logger = LoggerFactory.getLogger(BigQueryIndirectDataWriter.class);
    Path path;
    FileSystem fs;
    FSDataOutputStream outputStream;
    StructType sparkSchema;
    Schema avroSchema;
    IntermediateRecordWriter intermediateRecordWriter;
    private int partitionId;

    protected BigQueryIndirectDataWriter(int n, Path path, FileSystem fileSystem, StructType structType, Schema schema, IntermediateRecordWriter intermediateRecordWriter) {
        this.partitionId = n;
        this.path = path;
        this.fs = fileSystem;
        this.sparkSchema = structType;
        this.avroSchema = schema;
        this.intermediateRecordWriter = intermediateRecordWriter;
    }

    public void write(InternalRow internalRow) throws IOException {
        GenericData.Record record = AvroSchemaConverter.sparkRowToAvroGenericData(internalRow, this.sparkSchema, this.avroSchema);
        this.intermediateRecordWriter.write((GenericRecord)record);
    }

    public WriterCommitMessage commit() throws IOException {
        this.intermediateRecordWriter.close();
        return new BigQueryIndirectWriterCommitMessage(this.path.toString());
    }

    public void abort() throws IOException {
        logger.warn("Writing of partition {} has been aborted, attempting to delete {}", (Object)this.partitionId, (Object)this.path);
        this.fs.delete(this.path, false);
    }
}

