/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2;

import com.google.cloud.spark.bigquery.v2.AvroIntermediateRecordWriter;
import com.google.cloud.spark.bigquery.v2.BigQueryIndirectDataWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.beam.sdk.io.hadoop.SerializableConfiguration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.v2.writer.DataWriter;
import org.apache.spark.sql.sources.v2.writer.DataWriterFactory;
import org.apache.spark.sql.types.StructType;

class BigQueryIndirectDataWriterFactory
implements DataWriterFactory<InternalRow> {
    SerializableConfiguration conf;
    String gcsDirPath;
    StructType sparkSchema;
    String avroSchemaJson;

    public BigQueryIndirectDataWriterFactory(SerializableConfiguration serializableConfiguration, String string, StructType structType, String string2) {
        this.conf = serializableConfiguration;
        this.gcsDirPath = string;
        this.sparkSchema = structType;
        this.avroSchemaJson = string2;
    }

    public DataWriter<InternalRow> createDataWriter(int n, long l, long l2) {
        try {
            Schema schema = new Schema.Parser().parse(this.avroSchemaJson);
            UUID uUID = new UUID(l, l2);
            String string = String.format("%s/part-%06d-%s.avro", this.gcsDirPath, n, uUID);
            Path path = new Path(string);
            FileSystem fileSystem = path.getFileSystem(this.conf.get());
            AvroIntermediateRecordWriter avroIntermediateRecordWriter = new AvroIntermediateRecordWriter(schema, (OutputStream)fileSystem.create(path));
            return new BigQueryIndirectDataWriter(n, path, fileSystem, this.sparkSchema, schema, avroIntermediateRecordWriter);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }
}

