/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2;

import com.google.cloud.bigquery.connector.common.BigQueryReadClientFactory;
import com.google.cloud.bigquery.connector.common.ReadRowsHelper;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.spark.bigquery.ReadRowsResponseToInternalRowIteratorConverter;
import com.google.cloud.spark.bigquery.v2.BigQueryInputPartitionReader;
import java.util.Iterator;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.v2.reader.InputPartition;
import org.apache.spark.sql.sources.v2.reader.InputPartitionReader;

public class BigQueryInputPartition
implements InputPartition<InternalRow> {
    private final BigQueryReadClientFactory bigQueryReadClientFactory;
    private final String streamName;
    private final ReadRowsHelper.Options options;
    private final ReadRowsResponseToInternalRowIteratorConverter converter;

    public BigQueryInputPartition(BigQueryReadClientFactory bigQueryReadClientFactory, String string, ReadRowsHelper.Options options, ReadRowsResponseToInternalRowIteratorConverter readRowsResponseToInternalRowIteratorConverter) {
        this.bigQueryReadClientFactory = bigQueryReadClientFactory;
        this.streamName = string;
        this.options = options;
        this.converter = readRowsResponseToInternalRowIteratorConverter;
    }

    public InputPartitionReader<InternalRow> createPartitionReader() {
        ReadRowsRequest.Builder builder = ReadRowsRequest.newBuilder().setReadStream(this.streamName);
        ReadRowsHelper readRowsHelper = new ReadRowsHelper(this.bigQueryReadClientFactory, builder, this.options);
        Iterator<ReadRowsResponse> iterator = readRowsHelper.readRows();
        return new BigQueryInputPartitionReader(iterator, this.converter, readRowsHelper);
    }
}

