/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2;

import com.google.cloud.bigquery.connector.common.ReadRowsHelper;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.spark.bigquery.ReadRowsResponseToInternalRowIteratorConverter;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Iterator;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.v2.reader.InputPartitionReader;

class BigQueryInputPartitionReader
implements InputPartitionReader<InternalRow> {
    private Iterator<ReadRowsResponse> readRowsResponses;
    private ReadRowsResponseToInternalRowIteratorConverter converter;
    private ReadRowsHelper readRowsHelper;
    private Iterator<InternalRow> rows = ImmutableList.of().iterator();
    private InternalRow currentRow;

    BigQueryInputPartitionReader(Iterator<ReadRowsResponse> iterator, ReadRowsResponseToInternalRowIteratorConverter readRowsResponseToInternalRowIteratorConverter, ReadRowsHelper readRowsHelper) {
        this.readRowsResponses = iterator;
        this.converter = readRowsResponseToInternalRowIteratorConverter;
        this.readRowsHelper = readRowsHelper;
    }

    public boolean next() throws IOException {
        while (!this.rows.hasNext()) {
            if (!this.readRowsResponses.hasNext()) {
                return false;
            }
            ReadRowsResponse readRowsResponse = this.readRowsResponses.next();
            this.rows = this.converter.convert(readRowsResponse);
        }
        this.currentRow = this.rows.next();
        return true;
    }

    public InternalRow get() {
        return this.currentRow;
    }

    public void close() throws IOException {
        this.readRowsHelper.close();
    }
}

