/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IntermediateDataCleaner
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(IntermediateDataCleaner.class);
    private final Path path;
    private final Configuration conf;

    IntermediateDataCleaner(Path path, Configuration configuration) {
        this.path = path;
        this.conf = configuration;
    }

    @Override
    public void run() {
        this.deletePath();
    }

    void deletePath() {
        try {
            FileSystem fileSystem = this.path.getFileSystem(this.conf);
            if (this.pathExists(fileSystem, this.path)) {
                fileSystem.delete(this.path, true);
            }
        }
        catch (Exception exception) {
            logger.error("Failed to delete path " + this.path, (Throwable)exception);
        }
    }

    private boolean pathExists(FileSystem fileSystem, Path path) {
        try {
            return fileSystem.exists(path);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

