/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2;

import com.google.cloud.bigquery.connector.common.BigQueryConfig;
import com.google.cloud.bigquery.connector.common.UserAgentProvider;
import com.google.cloud.spark.bigquery.DataSourceVersion;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.SparkBigQueryConnectorUserAgentProvider;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.util.Optional;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import scala.collection.JavaConversions;
import scala.collection.Map;

public class SparkBigQueryConnectorModule
implements Module {
    private final SparkSession spark;
    private final java.util.Map<String, String> options;
    private final Optional<StructType> schema;
    private final DataSourceVersion dataSourceVersion;

    public SparkBigQueryConnectorModule(SparkSession sparkSession, java.util.Map<String, String> map, Optional<StructType> optional, DataSourceVersion dataSourceVersion) {
        this.spark = sparkSession;
        this.options = map;
        this.schema = optional;
        this.dataSourceVersion = dataSourceVersion;
    }

    public void configure(Binder binder) {
        binder.bind(BigQueryConfig.class).toProvider(this::provideSparkBigQueryConfig);
    }

    @Singleton
    @Provides
    public SparkSession provideSparkSession() {
        return this.spark;
    }

    @Singleton
    @Provides
    public SparkBigQueryConfig provideSparkBigQueryConfig() {
        java.util.Map<String, String> map = this.options;
        this.dataSourceVersion.updateOptionsMap(map);
        return SparkBigQueryConfig.from((java.util.Map<String, String>)ImmutableMap.copyOf(map), (ImmutableMap<String, String>)ImmutableMap.copyOf((java.util.Map)JavaConversions.mapAsJavaMap((Map)this.spark.conf().getAll())), this.spark.sparkContext().hadoopConfiguration(), this.spark.sparkContext().defaultParallelism(), this.spark.sqlContext().conf(), this.spark.version(), this.schema);
    }

    @Singleton
    @Provides
    public UserAgentProvider provideUserAgentProvider() {
        return new SparkBigQueryConnectorUserAgentProvider("v2");
    }
}

