/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.bigquery;

import java.math.BigDecimal;
import org.apache.spark.bigquery.BigNumeric;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.UTF8String;

public class BigNumericUDT
extends UserDefinedType<BigNumeric> {
    public DataType sqlType() {
        return DataTypes.StringType;
    }

    public UTF8String serialize(BigNumeric bigNumeric) {
        String string = bigNumeric.getNumber().toPlainString();
        return UTF8String.fromString((String)string);
    }

    public BigNumeric deserialize(Object object) {
        if (!(object instanceof UTF8String)) {
            throw new IllegalArgumentException("Failed to deserialize, was expecting an instance of UTF8String, instead got an instance of " + object.getClass());
        }
        UTF8String uTF8String = (UTF8String)object;
        BigNumeric bigNumeric = new BigNumeric(new BigDecimal(uTF8String.toString()));
        return bigNumeric;
    }

    public Class<BigNumeric> userClass() {
        return BigNumeric.class;
    }

    public String pyUDT() {
        return "google.cloud.spark.bigquery.big_numeric_support.BigNumericUDT";
    }
}

