/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.datastore;

import com.google.cloud.datastore.Key;
import com.google.cloud.spring.data.datastore.core.mapping.DatastoreDataException;
import com.google.cloud.spring.data.datastore.core.mapping.DatastoreMappingContext;
import com.google.cloud.spring.data.datastore.core.mapping.DatastorePersistentEntity;
import com.google.cloud.spring.data.datastore.core.mapping.DatastorePersistentProperty;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import org.springframework.data.rest.webmvc.spi.BackendIdConverter;

public class DatastoreKeyIdConverter
implements BackendIdConverter {
    private final DatastoreMappingContext datastoreMappingContext;

    public DatastoreKeyIdConverter(DatastoreMappingContext datastoreMappingContext) {
        this.datastoreMappingContext = datastoreMappingContext;
    }

    public Serializable fromRequestId(String s, Class<?> aClass) {
        try {
            return Key.fromUrlSafe((String)URLDecoder.decode(s, Charset.defaultCharset().name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new DatastoreDataException("Could not decode URL key param: " + s);
        }
    }

    public String toRequestId(Serializable serializable, Class<?> aClass) {
        return ((Key)serializable).toUrlSafe();
    }

    public boolean supports(Class<?> entityType) {
        return ((DatastorePersistentProperty)((DatastorePersistentEntity)this.datastoreMappingContext.getPersistentEntity(entityType)).getIdProperty()).getType().equals(Key.class);
    }
}

