/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.firestore;

import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.spring.autoconfigure.firestore.GcpFirestoreAutoConfiguration;
import com.google.cloud.spring.autoconfigure.firestore.GcpFirestoreProperties;
import com.google.cloud.spring.data.firestore.FirestoreTemplate;
import com.google.cloud.spring.data.firestore.mapping.FirestoreClassMapper;
import com.google.cloud.spring.data.firestore.mapping.FirestoreMappingContext;
import com.google.firestore.v1.FirestoreGrpc;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.auth.MoreCallCredentials;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Flux;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.cloud.gcp.firestore.emulator.enabled"})
@AutoConfigureBefore(value={GcpFirestoreAutoConfiguration.class})
@EnableConfigurationProperties(value={GcpFirestoreProperties.class})
public class GcpFirestoreEmulatorAutoConfiguration {
    private static final String EMULATOR_PROJECT_ID = "unused";
    private static final String ROOT_PATH = "projects/unused/databases/(default)";
    private final String hostPort;

    GcpFirestoreEmulatorAutoConfiguration(GcpFirestoreProperties properties) {
        this.hostPort = properties.getHostPort();
    }

    @Bean
    @ConditionalOnMissingBean
    public FirestoreOptions firestoreOptions() {
        return ((FirestoreOptions.Builder)((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setCredentials(this.emulatorCredentials())).setProjectId(EMULATOR_PROJECT_ID)).setChannelProvider((TransportChannelProvider)InstantiatingGrpcChannelProvider.newBuilder().setEndpoint(this.hostPort).setChannelConfigurator(input -> input.usePlaintext()).build()).build();
    }

    private Credentials emulatorCredentials() {
        final HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        headerMap.put("Authorization", Collections.singletonList("Bearer owner"));
        headerMap.put("google-cloud-resource-prefix", Collections.singletonList(ROOT_PATH));
        return new Credentials(){

            public String getAuthenticationType() {
                return null;
            }

            public Map<String, List<String>> getRequestMetadata(URI uri) {
                return headerMap;
            }

            public boolean hasRequestMetadata() {
                return true;
            }

            public boolean hasRequestMetadataOnly() {
                return true;
            }

            public void refresh() {
            }
        };
    }

    @ConditionalOnClass(value={FirestoreGrpc.FirestoreStub.class, Flux.class})
    @AutoConfigureBefore(value={GcpFirestoreAutoConfiguration.FirestoreReactiveAutoConfiguration.class})
    class ReactiveFirestoreEmulatorAutoConfiguration {
        ReactiveFirestoreEmulatorAutoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public FirestoreTemplate firestoreTemplate(FirestoreGrpc.FirestoreStub firestoreStub, FirestoreClassMapper classMapper, FirestoreMappingContext firestoreMappingContext) {
            FirestoreTemplate template = new FirestoreTemplate(firestoreStub, "projects/unused/databases/(default)/documents", classMapper, firestoreMappingContext);
            template.setUsingStreamTokens(false);
            return template;
        }

        @Bean
        @ConditionalOnMissingBean
        public FirestoreGrpc.FirestoreStub firestoreGrpcStub() throws IOException {
            ManagedChannel channel = ManagedChannelBuilder.forTarget((String)GcpFirestoreEmulatorAutoConfiguration.this.hostPort).usePlaintext().build();
            return (FirestoreGrpc.FirestoreStub)((FirestoreGrpc.FirestoreStub)FirestoreGrpc.newStub((Channel)channel).withCallCredentials(MoreCallCredentials.from((Credentials)GcpFirestoreEmulatorAutoConfiguration.this.emulatorCredentials()))).withExecutor(Runnable::run);
        }
    }
}

