/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.pubsub;

import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.spring.autoconfigure.pubsub.GcpPubSubAutoConfiguration;
import com.google.cloud.spring.autoconfigure.pubsub.GcpPubSubProperties;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import javax.annotation.PreDestroy;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="spring.cloud.gcp.pubsub", name={"emulator-host"})
@AutoConfigureBefore(value={GcpPubSubAutoConfiguration.class})
@EnableConfigurationProperties(value={GcpPubSubProperties.class})
public class GcpPubSubEmulatorAutoConfiguration {
    private ManagedChannel channel;

    @Bean(name={"subscriberTransportChannelProvider", "publisherTransportChannelProvider"})
    @ConditionalOnMissingBean(name={"subscriberTransportChannelProvider", "publisherTransportChannelProvider"})
    public TransportChannelProvider transportChannelProvider(GcpPubSubProperties gcpPubSubProperties) {
        this.channel = ManagedChannelBuilder.forTarget((String)("dns:///" + gcpPubSubProperties.getEmulatorHost())).usePlaintext().build();
        return FixedTransportChannelProvider.create((TransportChannel)GrpcTransportChannel.create((ManagedChannel)this.channel));
    }

    @PreDestroy
    public void closeManagedChannel() {
        if (this.channel != null) {
            this.channel.shutdown();
        }
    }
}

