/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.spanner;

import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spring.autoconfigure.spanner.GcpSpannerAutoConfiguration;
import com.google.cloud.spring.autoconfigure.spanner.GcpSpannerProperties;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={GcpSpannerAutoConfiguration.class})
@EnableConfigurationProperties(value={GcpSpannerProperties.class})
@ConditionalOnProperty(prefix="spring.cloud.gcp.spanner.emulator", name={"enabled"}, havingValue="true")
public class GcpSpannerEmulatorAutoConfiguration {
    private final GcpSpannerProperties properties;
    private final String projectId;

    public GcpSpannerEmulatorAutoConfiguration(GcpSpannerProperties properties, GcpProjectIdProvider projectIdProvider) {
        this.projectId = properties.getProjectId() != null ? properties.getProjectId() : projectIdProvider.getProjectId();
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public SpannerOptions spannerOptions() {
        Assert.notNull((Object)this.properties.getEmulatorHost(), (String)"`spring.cloud.gcp.spanner.emulator-host` must be set.");
        return ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(this.projectId)).setCredentials((Credentials)NoCredentials.getInstance())).setEmulatorHost(this.properties.getEmulatorHost()).build();
    }
}

