/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.sql;

import com.google.cloud.spring.autoconfigure.core.GcpProperties;
import com.google.cloud.spring.autoconfigure.sql.DatabaseType;
import com.google.cloud.spring.autoconfigure.sql.DefaultCloudSqlJdbcInfoProvider;
import com.google.cloud.spring.autoconfigure.sql.GcpCloudSqlProperties;
import com.google.cloud.spring.autoconfigure.sql.SqlCredentialFactory;
import com.google.cloud.spring.core.Credentials;
import com.google.cloud.sql.core.CoreSocketFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;

public class CloudSqlEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final Log LOGGER = LogFactory.getLog(CloudSqlEnvironmentPostProcessor.class);

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        DatabaseType databaseType = this.getEnabledDatabaseType(environment);
        if (databaseType != null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("post-processing Cloud SQL properties for + " + databaseType.name()));
            }
            Binder binder = Binder.get((Environment)environment);
            String cloudSqlPropertiesPrefix = GcpCloudSqlProperties.class.getAnnotation(ConfigurationProperties.class).value();
            String gcpPropertiesPrefix = GcpProperties.class.getAnnotation(ConfigurationProperties.class).value();
            GcpCloudSqlProperties sqlProperties = (GcpCloudSqlProperties)binder.bind(cloudSqlPropertiesPrefix, GcpCloudSqlProperties.class).orElse((Object)new GcpCloudSqlProperties());
            GcpProperties gcpProperties = (GcpProperties)binder.bind(cloudSqlPropertiesPrefix, GcpProperties.class).orElse((Object)new GcpProperties());
            DefaultCloudSqlJdbcInfoProvider cloudSqlJdbcInfoProvider = new DefaultCloudSqlJdbcInfoProvider(sqlProperties, databaseType);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Default " + databaseType.name() + " JdbcUrl provider. Connecting to " + cloudSqlJdbcInfoProvider.getJdbcUrl() + " with driver " + cloudSqlJdbcInfoProvider.getJdbcDriverClass()));
            }
            HashMap<String, String> fallbackMap = new HashMap<String, String>();
            fallbackMap.put("spring.datasource.username", databaseType.getDefaultUsername());
            fallbackMap.put("spring.datasource.driver-class-name", cloudSqlJdbcInfoProvider.getJdbcDriverClass());
            environment.getPropertySources().addLast((PropertySource)new MapPropertySource("CLOUD_SQL_DATA_SOURCE_FALLBACK", fallbackMap));
            HashMap<String, String> primaryMap = new HashMap<String, String>();
            primaryMap.put("spring.datasource.url", cloudSqlJdbcInfoProvider.getJdbcUrl());
            environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("CLOUD_SQL_DATA_SOURCE_URL", primaryMap));
            this.setCredentials(sqlProperties, gcpProperties);
            CoreSocketFactory.setApplicationName((String)("spring-cloud-gcp-sql/" + this.getClass().getPackage().getImplementationVersion()));
        }
    }

    private DatabaseType getEnabledDatabaseType(ConfigurableEnvironment environment) {
        if (Boolean.parseBoolean(environment.getProperty("spring.cloud.gcp.sql.enabled", "true")) && this.isOnClasspath("javax.sql.DataSource") && this.isOnClasspath("org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType") && this.isOnClasspath("com.google.cloud.sql.CredentialFactory")) {
            if (this.isOnClasspath("com.google.cloud.sql.mysql.SocketFactory") && this.isOnClasspath("com.mysql.cj.jdbc.Driver")) {
                return DatabaseType.MYSQL;
            }
            if (this.isOnClasspath("com.google.cloud.sql.postgres.SocketFactory") && this.isOnClasspath("org.postgresql.Driver")) {
                return DatabaseType.POSTGRESQL;
            }
        }
        return null;
    }

    private boolean isOnClasspath(String className) {
        return ClassUtils.isPresent((String)className, null);
    }

    private void setCredentials(GcpCloudSqlProperties sqlProperties, GcpProperties gcpProperties) {
        Credentials credentials = null;
        credentials = sqlProperties.getCredentials().hasKey() ? sqlProperties.getCredentials() : gcpProperties.getCredentials();
        if (credentials.getEncodedKey() != null) {
            this.setCredentialsEncodedKeyProperty(credentials.getEncodedKey());
        } else if (credentials.getLocation() != null) {
            this.setCredentialsFileProperty(credentials.getLocation());
        }
    }

    private void setCredentialsEncodedKeyProperty(String encodedKey) {
        System.setProperty("GOOGLE_CLOUD_SQL_ENCODED_KEY", encodedKey);
        System.setProperty("cloudSql.socketFactory.credentialFactory", SqlCredentialFactory.class.getName());
    }

    private void setCredentialsFileProperty(Resource credentialsLocation) {
        try {
            File credentialsLocationFile = credentialsLocation.getFile();
            if (credentialsLocationFile == null) {
                LOGGER.info((Object)"The private key of the Google Cloud SQL credential must be in a file on the filesystem.");
                return;
            }
            System.setProperty("GOOGLE_CLOUD_SQL_CREDS_LOCATION", credentialsLocationFile.getAbsolutePath());
            System.setProperty("cloudSql.socketFactory.credentialFactory", SqlCredentialFactory.class.getName());
        }
        catch (IOException ioe) {
            LOGGER.info((Object)"Error reading Cloud SQL credentials file.", (Throwable)ioe);
        }
    }
}

