/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.secretmanager;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretManagerServiceSettings;
import com.google.cloud.spring.autoconfigure.secretmanager.GcpSecretManagerProperties;
import com.google.cloud.spring.core.CredentialsSupplier;
import com.google.cloud.spring.core.DefaultCredentialsProvider;
import com.google.cloud.spring.core.DefaultGcpProjectIdProvider;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.core.UserAgentHeaderProvider;
import com.google.cloud.spring.secretmanager.SecretManagerPropertySourceLocator;
import com.google.cloud.spring.secretmanager.SecretManagerTemplate;
import java.io.IOException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={GcpSecretManagerProperties.class})
@ConditionalOnClass(value={SecretManagerServiceClient.class, SecretManagerTemplate.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.secretmanager.enabled"}, matchIfMissing=true)
public class GcpSecretManagerBootstrapConfiguration {
    private final GcpProjectIdProvider gcpProjectIdProvider;

    public GcpSecretManagerBootstrapConfiguration(GcpSecretManagerProperties properties, ConfigurableEnvironment configurableEnvironment) {
        this.gcpProjectIdProvider = properties.getProjectId() != null ? properties::getProjectId : new DefaultGcpProjectIdProvider();
    }

    @Bean
    @ConditionalOnMissingBean
    public CredentialsProvider googleCredentials(GcpSecretManagerProperties secretManagerProperties) throws IOException {
        return new DefaultCredentialsProvider((CredentialsSupplier)secretManagerProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public SecretManagerServiceClient secretManagerClient(CredentialsProvider googleCredentials) throws IOException {
        SecretManagerServiceSettings settings = ((SecretManagerServiceSettings.Builder)((SecretManagerServiceSettings.Builder)SecretManagerServiceSettings.newBuilder().setCredentialsProvider(googleCredentials)).setHeaderProvider((HeaderProvider)new UserAgentHeaderProvider(GcpSecretManagerBootstrapConfiguration.class))).build();
        return SecretManagerServiceClient.create((SecretManagerServiceSettings)settings);
    }

    @Bean
    @ConditionalOnMissingBean
    public SecretManagerTemplate secretManagerTemplate(SecretManagerServiceClient client) {
        return new SecretManagerTemplate(client, this.gcpProjectIdProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    public SecretManagerPropertySourceLocator secretManagerPropertySourceLocator(SecretManagerTemplate secretManagerTemplate) {
        return new SecretManagerPropertySourceLocator(secretManagerTemplate, this.gcpProjectIdProvider);
    }
}

