/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.trace.pubsub;

import brave.Span;
import brave.messaging.MessagingRequest;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import com.google.api.core.ApiFuture;
import com.google.cloud.pubsub.v1.PublisherInterface;
import com.google.cloud.spring.autoconfigure.trace.pubsub.PubSubProducerRequest;
import com.google.cloud.spring.autoconfigure.trace.pubsub.PubSubTracing;
import com.google.pubsub.v1.PubsubMessage;

final class TracingPublisher
implements PublisherInterface {
    private final PublisherInterface delegate;
    private final PubSubTracing pubSubTracing;
    private final String topic;

    TracingPublisher(PublisherInterface delegate, PubSubTracing pubSubTracing, String topic) {
        this.delegate = delegate;
        this.pubSubTracing = pubSubTracing;
        this.topic = topic;
    }

    public ApiFuture<String> publish(PubsubMessage message) {
        PubsubMessage.Builder builder = message.toBuilder();
        this.postProcessMessageForPublishing(builder);
        PubsubMessage tracedMessage = builder.build();
        return this.delegate.publish(tracedMessage);
    }

    private void postProcessMessageForPublishing(PubsubMessage.Builder messageBuilder) {
        Span span;
        PubSubProducerRequest request = new PubSubProducerRequest(messageBuilder, this.topic);
        TraceContext maybeParent = this.pubSubTracing.tracing.currentTraceContext().get();
        if (maybeParent == null) {
            TraceContextOrSamplingFlags extracted = this.pubSubTracing.extractAndClearTraceIdHeaders(this.pubSubTracing.producerExtractor, request, messageBuilder);
            span = this.pubSubTracing.nextMessagingSpan(this.pubSubTracing.producerSampler, (MessagingRequest)request, extracted);
        } else {
            span = this.pubSubTracing.tracer.newChild(maybeParent);
        }
        if (!span.isNoop()) {
            span.kind(Span.Kind.PRODUCER).name("publish");
            if (this.topic != null) {
                span.tag("pubsub.topic", this.topic);
            }
            if (this.pubSubTracing.remoteServiceName != null) {
                span.remoteServiceName(this.pubSubTracing.remoteServiceName);
            }
            long timestamp = this.pubSubTracing.tracing.clock(span.context()).currentTimeMicroseconds();
            span.start(timestamp).finish(timestamp);
        }
        this.pubSubTracing.producerInjector.inject(span.context(), (Object)request);
    }
}

