/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.pubsub.health;

import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.spring.pubsub.core.PubSubTemplate;
import com.google.cloud.spring.pubsub.support.BasicAcknowledgeablePubsubMessage;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.concurrent.ListenableFuture;

public class PubSubHealthIndicator
extends AbstractHealthIndicator {
    private final PubSubTemplate pubSubTemplate;
    private final boolean specifiedSubscription;
    private final String subscription;
    private final long timeoutMillis;
    private final boolean acknowledgeMessages;

    public PubSubHealthIndicator(PubSubTemplate pubSubTemplate, String healthCheckSubscription, long timeoutMillis, boolean acknowledgeMessages) {
        super("Failed to connect to Pub/Sub APIs. Check your credentials and verify you have proper access to the service.");
        Assert.notNull((Object)pubSubTemplate, (String)"pubSubTemplate can't be null");
        this.pubSubTemplate = pubSubTemplate;
        this.specifiedSubscription = StringUtils.hasText((String)healthCheckSubscription);
        this.subscription = this.specifiedSubscription ? healthCheckSubscription : "spring-cloud-gcp-healthcheck-" + UUID.randomUUID().toString();
        this.timeoutMillis = timeoutMillis;
        this.acknowledgeMessages = acknowledgeMessages;
    }

    void validateHealthCheck() {
        this.doHealthCheck(() -> {}, this::validationFailed, this::validationFailed);
    }

    protected void doHealthCheck(Health.Builder builder) {
        this.doHealthCheck(() -> ((Health.Builder)builder).up(), arg_0 -> ((Health.Builder)builder).down(arg_0), e -> builder.withException(e).unknown());
    }

    private void doHealthCheck(Runnable up, Consumer<Throwable> down, Consumer<Throwable> unknown) {
        try {
            this.pullMessage();
            up.run();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            unknown.accept(e);
        }
        catch (ExecutionException e) {
            if (this.isHealthyException(e)) {
                up.run();
            } else {
                down.accept(e);
            }
        }
        catch (TimeoutException e) {
            unknown.accept(e);
        }
        catch (Exception e) {
            down.accept(e);
        }
    }

    private void pullMessage() throws InterruptedException, ExecutionException, TimeoutException {
        ListenableFuture future = this.pubSubTemplate.pullAsync(this.subscription, Integer.valueOf(1), Boolean.valueOf(true));
        List messages = (List)future.get(this.timeoutMillis, TimeUnit.MILLISECONDS);
        if (this.acknowledgeMessages) {
            messages.forEach(BasicAcknowledgeablePubsubMessage::ack);
        }
    }

    boolean isHealthyException(ExecutionException e) {
        return !this.specifiedSubscription && this.isHealthyResponseForUnspecifiedSubscription(e);
    }

    private boolean isHealthyResponseForUnspecifiedSubscription(ExecutionException e) {
        Throwable t = e.getCause();
        if (t instanceof ApiException) {
            ApiException aex = (ApiException)t;
            StatusCode.Code errorCode = aex.getStatusCode().getCode();
            return errorCode == StatusCode.Code.NOT_FOUND || errorCode == StatusCode.Code.PERMISSION_DENIED;
        }
        return false;
    }

    private void validationFailed(Throwable e) {
        throw new BeanInitializationException("Validation of health indicator failed", e);
    }

    boolean isSpecifiedSubscription() {
        return this.specifiedSubscription;
    }

    String getSubscription() {
        return this.subscription;
    }

    long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    boolean isAcknowledgeMessages() {
        return this.acknowledgeMessages;
    }
}

