/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.core.environment;

import com.google.cloud.spring.autoconfigure.core.environment.ConditionalOnGcpEnvironment;
import com.google.cloud.spring.core.GcpEnvironment;
import com.google.cloud.spring.core.GcpEnvironmentProvider;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.Assert;

public class OnGcpEnvironmentCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Assert.notNull((Object)context, (String)"Application context cannot be null.");
        Assert.notNull((Object)metadata, (String)"AnnotationTypeMetadata cannot be null.");
        Assert.notNull((Object)context.getBeanFactory(), (String)"Bean factory cannot be null.");
        Map attributes = metadata.getAnnotationAttributes(ConditionalOnGcpEnvironment.class.getName());
        Assert.notNull((Object)attributes, (String)"@ConditionalOnGcpEnvironment annotation not declared on type.");
        GcpEnvironment[] targetEnvironments = (GcpEnvironment[])attributes.get("value");
        Assert.notNull((Object)targetEnvironments, (String)"Value attribute of ConditionalOnGcpEnvironment cannot be null.");
        GcpEnvironmentProvider environmentProvider = (GcpEnvironmentProvider)context.getBeanFactory().getBean(GcpEnvironmentProvider.class);
        Assert.notNull((Object)environmentProvider, (String)"GcpEnvironmentProvider not found in context.");
        GcpEnvironment currentEnvironment = environmentProvider.getCurrentEnvironment();
        if (Arrays.stream(targetEnvironments).noneMatch(env -> env == currentEnvironment)) {
            return new ConditionOutcome(false, "Application is not running on any of " + Arrays.stream(targetEnvironments).map(Enum::toString).collect(Collectors.joining(", ")));
        }
        return new ConditionOutcome(true, "Application is running on " + currentEnvironment);
    }
}

