/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.pubsub;

import com.google.api.core.ApiClock;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.cloud.pubsub.v1.stub.PublisherStubSettings;
import com.google.cloud.pubsub.v1.stub.SubscriberStubSettings;
import com.google.cloud.spring.autoconfigure.core.GcpContextAutoConfiguration;
import com.google.cloud.spring.autoconfigure.pubsub.GcpPubSubProperties;
import com.google.cloud.spring.core.CredentialsSupplier;
import com.google.cloud.spring.core.DefaultCredentialsProvider;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.core.UserAgentHeaderProvider;
import com.google.cloud.spring.pubsub.PubSubAdmin;
import com.google.cloud.spring.pubsub.core.PubSubException;
import com.google.cloud.spring.pubsub.core.PubSubTemplate;
import com.google.cloud.spring.pubsub.core.publisher.PubSubPublisherTemplate;
import com.google.cloud.spring.pubsub.core.subscriber.PubSubSubscriberTemplate;
import com.google.cloud.spring.pubsub.support.CachingPublisherFactory;
import com.google.cloud.spring.pubsub.support.DefaultPublisherFactory;
import com.google.cloud.spring.pubsub.support.DefaultSubscriberFactory;
import com.google.cloud.spring.pubsub.support.PublisherFactory;
import com.google.cloud.spring.pubsub.support.SubscriberFactory;
import com.google.cloud.spring.pubsub.support.converter.PubSubMessageConverter;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.threeten.bp.Duration;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={GcpContextAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.pubsub.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={PubSubTemplate.class})
@EnableConfigurationProperties(value={GcpPubSubProperties.class})
public class GcpPubSubAutoConfiguration {
    private final GcpPubSubProperties gcpPubSubProperties;
    private final GcpProjectIdProvider finalProjectIdProvider;
    private final CredentialsProvider finalCredentialsProvider;
    private final HeaderProvider headerProvider = new UserAgentHeaderProvider(this.getClass());

    public GcpPubSubAutoConfiguration(GcpPubSubProperties gcpPubSubProperties, GcpProjectIdProvider gcpProjectIdProvider, CredentialsProvider credentialsProvider) throws IOException {
        this.gcpPubSubProperties = gcpPubSubProperties;
        GcpProjectIdProvider gcpProjectIdProvider2 = gcpPubSubProperties.getProjectId() != null ? gcpPubSubProperties::getProjectId : (this.finalProjectIdProvider = gcpProjectIdProvider);
        this.finalCredentialsProvider = gcpPubSubProperties.getEmulatorHost() == null || "false".equals(gcpPubSubProperties.getEmulatorHost()) ? (gcpPubSubProperties.getCredentials().hasKey() ? new DefaultCredentialsProvider((CredentialsSupplier)gcpPubSubProperties) : credentialsProvider) : NoCredentialsProvider.create();
    }

    @Bean
    @ConditionalOnMissingBean(name={"pubsubPublisherThreadPool"})
    public ThreadPoolTaskScheduler pubsubPublisherThreadPool() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(this.gcpPubSubProperties.getPublisher().getExecutorThreads());
        scheduler.setThreadNamePrefix("gcp-pubsub-publisher");
        scheduler.setDaemon(true);
        return scheduler;
    }

    @Bean
    @ConditionalOnMissingBean(name={"publisherExecutorProvider"})
    public ExecutorProvider publisherExecutorProvider(@Qualifier(value="pubsubPublisherThreadPool") ThreadPoolTaskScheduler scheduler) {
        return FixedExecutorProvider.create((ScheduledExecutorService)scheduler.getScheduledExecutor());
    }

    @Bean
    @ConditionalOnMissingBean(name={"pubsubSubscriberThreadPool"})
    public ThreadPoolTaskScheduler pubsubSubscriberThreadPool() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(this.gcpPubSubProperties.getSubscriber().getExecutorThreads());
        scheduler.setThreadNamePrefix("gcp-pubsub-subscriber");
        scheduler.setDaemon(true);
        return scheduler;
    }

    @Bean
    @ConditionalOnMissingBean(name={"subscriberExecutorProvider"})
    public ExecutorProvider subscriberExecutorProvider(@Qualifier(value="pubsubSubscriberThreadPool") ThreadPoolTaskScheduler scheduler) {
        return FixedExecutorProvider.create((ScheduledExecutorService)scheduler.getScheduledExecutor());
    }

    @Bean
    @ConditionalOnMissingBean
    public PubSubPublisherTemplate pubSubPublisherTemplate(PublisherFactory publisherFactory, ObjectProvider<PubSubMessageConverter> pubSubMessageConverter) {
        PubSubPublisherTemplate pubSubPublisherTemplate = new PubSubPublisherTemplate(publisherFactory);
        pubSubMessageConverter.ifUnique(arg_0 -> ((PubSubPublisherTemplate)pubSubPublisherTemplate).setMessageConverter(arg_0));
        return pubSubPublisherTemplate;
    }

    @Bean
    @ConditionalOnMissingBean(name={"pubSubAcknowledgementExecutor"})
    public Executor pubSubAcknowledgementExecutor() {
        ThreadPoolTaskExecutor ackExecutor = new ThreadPoolTaskExecutor();
        ackExecutor.setMaxPoolSize(this.gcpPubSubProperties.getSubscriber().getMaxAcknowledgementThreads());
        ackExecutor.setThreadNamePrefix("gcp-pubsub-ack-executor");
        ackExecutor.setDaemon(true);
        return ackExecutor;
    }

    @Bean
    @ConditionalOnMissingBean
    public PubSubSubscriberTemplate pubSubSubscriberTemplate(SubscriberFactory subscriberFactory, ObjectProvider<PubSubMessageConverter> pubSubMessageConverter, @Qualifier(value="pubSubAsynchronousPullExecutor") ObjectProvider<Executor> asyncPullExecutor, @Qualifier(value="pubSubAcknowledgementExecutor") Executor ackExecutor) {
        PubSubSubscriberTemplate pubSubSubscriberTemplate = new PubSubSubscriberTemplate(subscriberFactory);
        pubSubMessageConverter.ifUnique(arg_0 -> ((PubSubSubscriberTemplate)pubSubSubscriberTemplate).setMessageConverter(arg_0));
        pubSubSubscriberTemplate.setAckExecutor(ackExecutor);
        asyncPullExecutor.ifAvailable(arg_0 -> ((PubSubSubscriberTemplate)pubSubSubscriberTemplate).setAsyncPullExecutor(arg_0));
        return pubSubSubscriberTemplate;
    }

    @Bean
    @ConditionalOnMissingBean
    public PubSubTemplate pubSubTemplate(PubSubPublisherTemplate pubSubPublisherTemplate, PubSubSubscriberTemplate pubSubSubscriberTemplate) {
        return new PubSubTemplate(pubSubPublisherTemplate, pubSubSubscriberTemplate);
    }

    @Bean
    @ConditionalOnMissingBean(name={"subscriberRetrySettings"})
    public RetrySettings subscriberRetrySettings() {
        return this.buildRetrySettings(this.gcpPubSubProperties.getSubscriber().getRetry());
    }

    @Bean
    @ConditionalOnMissingBean(name={"subscriberFlowControlSettings"})
    public FlowControlSettings subscriberFlowControlSettings() {
        return this.buildFlowControlSettings(this.gcpPubSubProperties.getSubscriber().getFlowControl());
    }

    private FlowControlSettings buildFlowControlSettings(GcpPubSubProperties.FlowControl flowControl) {
        FlowControlSettings.Builder builder = FlowControlSettings.newBuilder();
        boolean shouldBuild = this.ifSet(flowControl.getLimitExceededBehavior(), arg_0 -> ((FlowControlSettings.Builder)builder).setLimitExceededBehavior(arg_0));
        shouldBuild |= this.ifSet(flowControl.getMaxOutstandingElementCount(), arg_0 -> ((FlowControlSettings.Builder)builder).setMaxOutstandingElementCount(arg_0));
        return (shouldBuild |= this.ifSet(flowControl.getMaxOutstandingRequestBytes(), arg_0 -> ((FlowControlSettings.Builder)builder).setMaxOutstandingRequestBytes(arg_0))) ? builder.build() : null;
    }

    @Bean
    @ConditionalOnMissingBean
    public SubscriberFactory defaultSubscriberFactory(@Qualifier(value="subscriberExecutorProvider") ExecutorProvider executorProvider, @Qualifier(value="subscriberSystemExecutorProvider") ObjectProvider<ExecutorProvider> systemExecutorProvider, @Qualifier(value="subscriberFlowControlSettings") ObjectProvider<FlowControlSettings> flowControlSettings, @Qualifier(value="subscriberApiClock") ObjectProvider<ApiClock> apiClock, @Qualifier(value="subscriberRetrySettings") ObjectProvider<RetrySettings> retrySettings, @Qualifier(value="subscriberTransportChannelProvider") TransportChannelProvider subscriberTransportChannelProvider) {
        DefaultSubscriberFactory factory = new DefaultSubscriberFactory(this.finalProjectIdProvider);
        factory.setExecutorProvider(executorProvider);
        factory.setCredentialsProvider(this.finalCredentialsProvider);
        factory.setHeaderProvider(this.headerProvider);
        factory.setChannelProvider(subscriberTransportChannelProvider);
        systemExecutorProvider.ifAvailable(arg_0 -> ((DefaultSubscriberFactory)factory).setSystemExecutorProvider(arg_0));
        flowControlSettings.ifAvailable(arg_0 -> ((DefaultSubscriberFactory)factory).setFlowControlSettings(arg_0));
        apiClock.ifAvailable(arg_0 -> ((DefaultSubscriberFactory)factory).setApiClock(arg_0));
        retrySettings.ifAvailable(arg_0 -> ((DefaultSubscriberFactory)factory).setSubscriberStubRetrySettings(arg_0));
        if (this.gcpPubSubProperties.getSubscriber().getMaxAckExtensionPeriod() != null) {
            factory.setMaxAckExtensionPeriod(Duration.ofSeconds((long)this.gcpPubSubProperties.getSubscriber().getMaxAckExtensionPeriod()));
        }
        if (this.gcpPubSubProperties.getSubscriber().getParallelPullCount() != null) {
            factory.setParallelPullCount(this.gcpPubSubProperties.getSubscriber().getParallelPullCount());
        }
        if (this.gcpPubSubProperties.getSubscriber().getPullEndpoint() != null) {
            factory.setPullEndpoint(this.gcpPubSubProperties.getSubscriber().getPullEndpoint());
        }
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean(name={"publisherBatchSettings"})
    public BatchingSettings publisherBatchSettings() {
        BatchingSettings.Builder builder = BatchingSettings.newBuilder();
        GcpPubSubProperties.Batching batching = this.gcpPubSubProperties.getPublisher().getBatching();
        FlowControlSettings flowControlSettings = this.buildFlowControlSettings(batching.getFlowControl());
        if (flowControlSettings != null) {
            builder.setFlowControlSettings(flowControlSettings);
        }
        boolean shouldBuild = this.ifSet(batching.getDelayThresholdSeconds(), x -> builder.setDelayThreshold(Duration.ofSeconds((long)x)));
        shouldBuild |= this.ifSet(batching.getElementCountThreshold(), arg_0 -> ((BatchingSettings.Builder)builder).setElementCountThreshold(arg_0));
        shouldBuild |= this.ifSet(batching.getEnabled(), arg_0 -> ((BatchingSettings.Builder)builder).setIsEnabled(arg_0));
        return (shouldBuild |= this.ifSet(batching.getRequestByteThreshold(), arg_0 -> ((BatchingSettings.Builder)builder).setRequestByteThreshold(arg_0))) ? builder.build() : null;
    }

    @Bean
    @ConditionalOnMissingBean(name={"publisherRetrySettings"})
    public RetrySettings publisherRetrySettings() {
        return this.buildRetrySettings(this.gcpPubSubProperties.getPublisher().getRetry());
    }

    private RetrySettings buildRetrySettings(GcpPubSubProperties.Retry retryProperties) {
        RetrySettings.Builder builder = RetrySettings.newBuilder();
        boolean shouldBuild = this.ifSet(retryProperties.getInitialRetryDelaySeconds(), x -> builder.setInitialRetryDelay(Duration.ofSeconds((long)x)));
        shouldBuild |= this.ifSet(retryProperties.getInitialRpcTimeoutSeconds(), x -> builder.setInitialRpcTimeout(Duration.ofSeconds((long)x)));
        shouldBuild |= this.ifSet(retryProperties.getJittered(), arg_0 -> ((RetrySettings.Builder)builder).setJittered(arg_0));
        shouldBuild |= this.ifSet(retryProperties.getMaxAttempts(), arg_0 -> ((RetrySettings.Builder)builder).setMaxAttempts(arg_0));
        shouldBuild |= this.ifSet(retryProperties.getMaxRetryDelaySeconds(), x -> builder.setMaxRetryDelay(Duration.ofSeconds((long)x)));
        shouldBuild |= this.ifSet(retryProperties.getMaxRpcTimeoutSeconds(), x -> builder.setMaxRpcTimeout(Duration.ofSeconds((long)x)));
        shouldBuild |= this.ifSet(retryProperties.getRetryDelayMultiplier(), arg_0 -> ((RetrySettings.Builder)builder).setRetryDelayMultiplier(arg_0));
        shouldBuild |= this.ifSet(retryProperties.getTotalTimeoutSeconds(), x -> builder.setTotalTimeout(Duration.ofSeconds((long)x)));
        return (shouldBuild |= this.ifSet(retryProperties.getRpcTimeoutMultiplier(), arg_0 -> ((RetrySettings.Builder)builder).setRpcTimeoutMultiplier(arg_0))) ? builder.build() : null;
    }

    private <T> boolean ifSet(T property, Consumer<T> consumer) {
        if (property != null) {
            consumer.accept(property);
            return true;
        }
        return false;
    }

    @Bean
    @ConditionalOnMissingBean
    public PublisherFactory defaultPublisherFactory(@Qualifier(value="publisherExecutorProvider") ExecutorProvider executorProvider, @Qualifier(value="publisherBatchSettings") ObjectProvider<BatchingSettings> batchingSettings, @Qualifier(value="publisherRetrySettings") ObjectProvider<RetrySettings> retrySettings, @Qualifier(value="publisherTransportChannelProvider") TransportChannelProvider publisherTransportChannelProvider) {
        DefaultPublisherFactory factory = new DefaultPublisherFactory(this.finalProjectIdProvider);
        factory.setExecutorProvider(executorProvider);
        factory.setCredentialsProvider(this.finalCredentialsProvider);
        factory.setHeaderProvider(this.headerProvider);
        factory.setChannelProvider(publisherTransportChannelProvider);
        retrySettings.ifAvailable(arg_0 -> ((DefaultPublisherFactory)factory).setRetrySettings(arg_0));
        batchingSettings.ifAvailable(arg_0 -> ((DefaultPublisherFactory)factory).setBatchingSettings(arg_0));
        factory.setEnableMessageOrdering(this.gcpPubSubProperties.getPublisher().getEnableMessageOrdering());
        factory.setEndpoint(this.gcpPubSubProperties.getPublisher().getEndpoint());
        return new CachingPublisherFactory((PublisherFactory)factory);
    }

    @Bean
    @ConditionalOnMissingBean
    public PubSubAdmin pubSubAdmin(TopicAdminClient topicAdminClient, SubscriptionAdminClient subscriptionAdminClient) {
        return new PubSubAdmin(this.finalProjectIdProvider, topicAdminClient, subscriptionAdminClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public TopicAdminClient topicAdminClient(TopicAdminSettings topicAdminSettings) {
        try {
            return TopicAdminClient.create((TopicAdminSettings)topicAdminSettings);
        }
        catch (IOException ioe) {
            throw new PubSubException("An error occurred while creating TopicAdminClient.", (Throwable)ioe);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public TopicAdminSettings topicAdminSettings(@Qualifier(value="publisherTransportChannelProvider") TransportChannelProvider publisherTransportChannelProvider) {
        try {
            return ((TopicAdminSettings.Builder)((TopicAdminSettings.Builder)((TopicAdminSettings.Builder)TopicAdminSettings.newBuilder().setCredentialsProvider(this.finalCredentialsProvider)).setHeaderProvider(this.headerProvider)).setTransportChannelProvider(publisherTransportChannelProvider)).build();
        }
        catch (IOException ioe) {
            throw new PubSubException("An error occurred while creating TopicAdminSettings.", (Throwable)ioe);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public SubscriptionAdminClient subscriptionAdminClient(@Qualifier(value="subscriberTransportChannelProvider") TransportChannelProvider subscriberTransportChannelProvider) {
        try {
            return SubscriptionAdminClient.create((SubscriptionAdminSettings)((SubscriptionAdminSettings.Builder)((SubscriptionAdminSettings.Builder)((SubscriptionAdminSettings.Builder)SubscriptionAdminSettings.newBuilder().setCredentialsProvider(this.finalCredentialsProvider)).setHeaderProvider(this.headerProvider)).setTransportChannelProvider(subscriberTransportChannelProvider)).build());
        }
        catch (IOException ioe) {
            throw new PubSubException("An error occurred while creating SubscriptionAdminClient.", (Throwable)ioe);
        }
    }

    @Bean
    @ConditionalOnMissingBean(name={"subscriberTransportChannelProvider"})
    public TransportChannelProvider subscriberTransportChannelProvider() {
        return SubscriberStubSettings.defaultGrpcTransportProviderBuilder().setKeepAliveTime(Duration.ofMinutes((long)this.gcpPubSubProperties.getKeepAliveIntervalMinutes())).build();
    }

    @Bean
    @ConditionalOnMissingBean(name={"publisherTransportChannelProvider"})
    public TransportChannelProvider publisherTransportChannelProvider() {
        return PublisherStubSettings.defaultGrpcTransportProviderBuilder().setKeepAliveTime(Duration.ofMinutes((long)this.gcpPubSubProperties.getKeepAliveIntervalMinutes())).build();
    }
}

