/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.trace.pubsub;

import brave.Tracing;
import brave.messaging.MessagingTracing;
import com.google.cloud.spring.autoconfigure.trace.pubsub.PubSubTracing;
import com.google.cloud.spring.autoconfigure.trace.pubsub.TracePubSubBeanPostProcessor;
import com.google.cloud.spring.pubsub.support.PublisherFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.brave.instrument.messaging.BraveMessagingAutoConfiguration;
import org.springframework.cloud.sleuth.brave.instrument.messaging.ConditionalOnMessagingEnabled;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMessagingEnabled
@ConditionalOnBean(value={Tracing.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.trace.pubsub.enabled"}, matchIfMissing=false)
@ConditionalOnClass(value={PublisherFactory.class, MessagingTracing.class})
@AutoConfigureAfter(value={BraveAutoConfiguration.class, BraveMessagingAutoConfiguration.class})
class TracePubSubAutoConfiguration {
    TracePubSubAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    static TracePubSubBeanPostProcessor tracePubSubBeanPostProcessor(BeanFactory beanFactory) {
        return new TracePubSubBeanPostProcessor(beanFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    PubSubTracing pubSubTracing(MessagingTracing messagingTracing) {
        return PubSubTracing.newBuilder(messagingTracing).build();
    }
}

