/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.secretmanager;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretManagerServiceSettings;
import com.google.cloud.spring.autoconfigure.secretmanager.GcpSecretManagerProperties;
import com.google.cloud.spring.autoconfigure.secretmanager.SecretManagerConfigDataLoader;
import com.google.cloud.spring.autoconfigure.secretmanager.SecretManagerConfigDataResource;
import com.google.cloud.spring.core.CredentialsSupplier;
import com.google.cloud.spring.core.DefaultCredentialsProvider;
import com.google.cloud.spring.core.DefaultGcpProjectIdProvider;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.core.UserAgentHeaderProvider;
import com.google.cloud.spring.secretmanager.SecretManagerTemplate;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.util.VisibleForTesting;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;

public class SecretManagerConfigDataLocationResolver
implements ConfigDataLocationResolver<SecretManagerConfigDataResource> {
    public static final String PREFIX = "sm://";
    private static SecretManagerServiceClient secretManagerServiceClient;

    public boolean isResolvable(ConfigDataLocationResolverContext context, ConfigDataLocation location) {
        return location.hasPrefix(PREFIX);
    }

    public List<SecretManagerConfigDataResource> resolve(ConfigDataLocationResolverContext context, ConfigDataLocation location) throws ConfigDataLocationNotFoundException, ConfigDataResourceNotFoundException {
        SecretManagerConfigDataLocationResolver.registerSecretManagerBeans(context);
        return Collections.singletonList(new SecretManagerConfigDataResource(location));
    }

    private static void registerSecretManagerBeans(ConfigDataLocationResolverContext context) {
        SecretManagerConfigDataLocationResolver.registerBean(context, GcpSecretManagerProperties.class, SecretManagerConfigDataLocationResolver.getSecretManagerProperties(context));
        SecretManagerConfigDataLocationResolver.registerAndPromoteBean(context, SecretManagerServiceClient.class, BootstrapRegistry.InstanceSupplier.from(() -> SecretManagerConfigDataLocationResolver.createSecretManagerClient(context)));
        SecretManagerConfigDataLocationResolver.registerAndPromoteBean(context, GcpProjectIdProvider.class, BootstrapRegistry.InstanceSupplier.of((Object)SecretManagerConfigDataLocationResolver.createProjectIdProvider(context)));
        SecretManagerConfigDataLocationResolver.registerAndPromoteBean(context, SecretManagerTemplate.class, BootstrapRegistry.InstanceSupplier.of((Object)SecretManagerConfigDataLocationResolver.createSecretManagerTemplate(context)));
    }

    private static GcpSecretManagerProperties getSecretManagerProperties(ConfigDataLocationResolverContext context) {
        return (GcpSecretManagerProperties)context.getBinder().bind("spring.cloud.gcp.secretmanager", GcpSecretManagerProperties.class).orElse((Object)new GcpSecretManagerProperties());
    }

    private static GcpProjectIdProvider createProjectIdProvider(ConfigDataLocationResolverContext context) {
        GcpSecretManagerProperties properties = (GcpSecretManagerProperties)context.getBootstrapContext().get(GcpSecretManagerProperties.class);
        return properties.getProjectId() != null ? properties::getProjectId : new DefaultGcpProjectIdProvider();
    }

    @VisibleForTesting
    static synchronized SecretManagerServiceClient createSecretManagerClient(ConfigDataLocationResolverContext context) {
        if (secretManagerServiceClient != null && !secretManagerServiceClient.isTerminated()) {
            return secretManagerServiceClient;
        }
        try {
            GcpSecretManagerProperties properties = (GcpSecretManagerProperties)context.getBootstrapContext().get(GcpSecretManagerProperties.class);
            DefaultCredentialsProvider credentialsProvider = new DefaultCredentialsProvider((CredentialsSupplier)properties);
            SecretManagerServiceSettings settings = ((SecretManagerServiceSettings.Builder)((SecretManagerServiceSettings.Builder)SecretManagerServiceSettings.newBuilder().setCredentialsProvider((CredentialsProvider)credentialsProvider)).setHeaderProvider((HeaderProvider)new UserAgentHeaderProvider(SecretManagerConfigDataLoader.class))).build();
            secretManagerServiceClient = SecretManagerServiceClient.create((SecretManagerServiceSettings)settings);
            return secretManagerServiceClient;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create the Secret Manager Client for ConfigData loading.");
        }
    }

    private static SecretManagerTemplate createSecretManagerTemplate(ConfigDataLocationResolverContext context) {
        SecretManagerServiceClient client = (SecretManagerServiceClient)context.getBootstrapContext().get(SecretManagerServiceClient.class);
        GcpProjectIdProvider projectIdProvider = (GcpProjectIdProvider)context.getBootstrapContext().get(GcpProjectIdProvider.class);
        GcpSecretManagerProperties properties = (GcpSecretManagerProperties)context.getBootstrapContext().get(GcpSecretManagerProperties.class);
        return new SecretManagerTemplate(client, projectIdProvider).setAllowDefaultSecretValue(properties.isAllowDefaultSecret());
    }

    private static <T> void registerBean(ConfigDataLocationResolverContext context, Class<T> type, T instance) {
        context.getBootstrapContext().registerIfAbsent(type, BootstrapRegistry.InstanceSupplier.of(instance));
    }

    private static <T> void registerAndPromoteBean(ConfigDataLocationResolverContext context, Class<T> type, BootstrapRegistry.InstanceSupplier<T> supplier) {
        context.getBootstrapContext().registerIfAbsent(type, supplier);
        context.getBootstrapContext().addCloseListener(event -> {
            Object instance = event.getBootstrapContext().get(type);
            String beanName = "gcp-secretmanager-config-data-" + type.getSimpleName();
            ConfigurableListableBeanFactory factory = event.getApplicationContext().getBeanFactory();
            if (!factory.containsSingleton(beanName)) {
                factory.registerSingleton(beanName, instance);
            }
        });
    }

    @VisibleForTesting
    static void setSecretManagerServiceClient(SecretManagerServiceClient client) {
        secretManagerServiceClient = client;
    }
}

