/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.firestore;

import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.spring.autoconfigure.firestore.GcpFirestoreAutoConfiguration;
import com.google.cloud.spring.autoconfigure.firestore.GcpFirestoreProperties;
import com.google.cloud.spring.data.firestore.FirestoreTemplate;
import com.google.cloud.spring.data.firestore.mapping.FirestoreClassMapper;
import com.google.cloud.spring.data.firestore.mapping.FirestoreMappingContext;
import com.google.firestore.v1.FirestoreGrpc;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.auth.MoreCallCredentials;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Flux;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.cloud.gcp.firestore.emulator.enabled"})
@AutoConfigureBefore(value={GcpFirestoreAutoConfiguration.class})
@EnableConfigurationProperties(value={GcpFirestoreProperties.class})
public class GcpFirestoreEmulatorAutoConfiguration {
    private final String hostPort;
    private final String projectId;
    private final String rootPath;

    GcpFirestoreEmulatorAutoConfiguration(GcpFirestoreProperties properties) {
        this.hostPort = properties.getHostPort();
        this.projectId = (String)StringUtils.defaultIfEmpty((CharSequence)properties.getProjectId(), (CharSequence)"unused");
        this.rootPath = properties.getFirestoreRootPath(() -> this.projectId);
    }

    @Bean
    @ConditionalOnMissingBean
    public FirestoreOptions firestoreOptions() {
        return ((FirestoreOptions.Builder)((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setCredentials(this.emulatorCredentials())).setProjectId(this.projectId)).setChannelProvider((TransportChannelProvider)InstantiatingGrpcChannelProvider.newBuilder().setEndpoint(this.hostPort).setChannelConfigurator(ManagedChannelBuilder::usePlaintext).build()).build();
    }

    private Credentials emulatorCredentials() {
        final HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        headerMap.put("Authorization", Collections.singletonList("Bearer owner"));
        headerMap.put("google-cloud-resource-prefix", Collections.singletonList(this.rootPath));
        return new Credentials(){

            public String getAuthenticationType() {
                return null;
            }

            public Map<String, List<String>> getRequestMetadata(URI uri) {
                return headerMap;
            }

            public boolean hasRequestMetadata() {
                return true;
            }

            public boolean hasRequestMetadataOnly() {
                return true;
            }

            public void refresh() {
            }
        };
    }

    @ConditionalOnClass(value={FirestoreGrpc.FirestoreStub.class, Flux.class})
    @AutoConfigureBefore(value={GcpFirestoreAutoConfiguration.FirestoreReactiveAutoConfiguration.class})
    class ReactiveFirestoreEmulatorAutoConfiguration {
        ReactiveFirestoreEmulatorAutoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public FirestoreTemplate firestoreTemplate(FirestoreGrpc.FirestoreStub firestoreStub, FirestoreClassMapper classMapper, FirestoreMappingContext firestoreMappingContext) {
            return new FirestoreTemplate(firestoreStub, GcpFirestoreEmulatorAutoConfiguration.this.rootPath + "/documents", classMapper, firestoreMappingContext);
        }

        @Bean
        @ConditionalOnMissingBean
        public FirestoreGrpc.FirestoreStub firestoreGrpcStub() {
            ManagedChannel channel = ManagedChannelBuilder.forTarget((String)GcpFirestoreEmulatorAutoConfiguration.this.hostPort).usePlaintext().build();
            return (FirestoreGrpc.FirestoreStub)((FirestoreGrpc.FirestoreStub)FirestoreGrpc.newStub((Channel)channel).withCallCredentials(MoreCallCredentials.from((Credentials)GcpFirestoreEmulatorAutoConfiguration.this.emulatorCredentials()))).withExecutor(Runnable::run);
        }
    }
}

