/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.sql;

import com.google.cloud.spring.autoconfigure.sql.CredentialsPropertiesSetter;
import com.google.cloud.spring.autoconfigure.sql.DatabaseType;
import com.google.cloud.spring.autoconfigure.sql.DefaultCloudSqlJdbcInfoProvider;
import com.google.cloud.spring.autoconfigure.sql.GcpCloudSqlProperties;
import com.google.cloud.spring.autoconfigure.sql.PropertiesRetriever;
import com.google.cloud.sql.core.CoreSocketFactory;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;

public class CloudSqlEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final Log LOGGER = LogFactory.getLog(CloudSqlEnvironmentPostProcessor.class);

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (environment.getPropertySources().contains("bootstrap")) {
            return;
        }
        DatabaseType databaseType = this.getEnabledDatabaseType(environment);
        if (databaseType != null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("post-processing Cloud SQL properties for + " + databaseType.name()));
            }
            PropertiesRetriever propertiesRetriever = new PropertiesRetriever((Environment)environment);
            GcpCloudSqlProperties sqlProperties = propertiesRetriever.getCloudSqlProperties();
            DefaultCloudSqlJdbcInfoProvider cloudSqlJdbcInfoProvider = new DefaultCloudSqlJdbcInfoProvider(sqlProperties, databaseType);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Default " + databaseType.name() + " JdbcUrl provider. Connecting to " + cloudSqlJdbcInfoProvider.getJdbcUrl() + " with driver " + cloudSqlJdbcInfoProvider.getJdbcDriverClass()));
            }
            HashMap<String, String> fallbackMap = new HashMap<String, String>();
            fallbackMap.put("spring.datasource.username", databaseType.getDefaultUsername());
            fallbackMap.put("spring.datasource.driver-class-name", cloudSqlJdbcInfoProvider.getJdbcDriverClass());
            environment.getPropertySources().addLast((PropertySource)new MapPropertySource("CLOUD_SQL_DATA_SOURCE_FALLBACK", fallbackMap));
            HashMap<String, String> primaryMap = new HashMap<String, String>();
            primaryMap.put("spring.datasource.url", cloudSqlJdbcInfoProvider.getJdbcUrl());
            environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("CLOUD_SQL_DATA_SOURCE_URL", primaryMap));
            CredentialsPropertiesSetter.setCredentials(sqlProperties, propertiesRetriever.getGcpProperties());
            CoreSocketFactory.setApplicationName((String)("spring-cloud-gcp-sql/" + this.getClass().getPackage().getImplementationVersion()));
        }
    }

    private DatabaseType getEnabledDatabaseType(ConfigurableEnvironment environment) {
        if (this.isJdbcEnabled(environment) && this.isOnClasspath("javax.sql.DataSource") && this.isOnClasspath("org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType") && this.isOnClasspath("com.google.cloud.sql.CredentialFactory")) {
            if (this.isOnClasspath("com.google.cloud.sql.mysql.SocketFactory") && this.isOnClasspath("com.mysql.cj.jdbc.Driver")) {
                return DatabaseType.MYSQL;
            }
            if (this.isOnClasspath("com.google.cloud.sql.postgres.SocketFactory") && this.isOnClasspath("org.postgresql.Driver")) {
                return DatabaseType.POSTGRESQL;
            }
        }
        return null;
    }

    private boolean isJdbcEnabled(ConfigurableEnvironment environment) {
        return Boolean.parseBoolean(environment.getProperty("spring.cloud.gcp.sql.enabled", "true")) && Boolean.parseBoolean(environment.getProperty("spring.cloud.gcp.sql.jdbc.enabled", "true"));
    }

    private boolean isOnClasspath(String className) {
        return ClassUtils.isPresent((String)className, null);
    }
}

