/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.pubsub;

import com.google.api.core.ApiClock;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.cloud.pubsub.v1.stub.PublisherStubSettings;
import com.google.cloud.pubsub.v1.stub.SubscriberStubSettings;
import com.google.cloud.spring.autoconfigure.core.GcpContextAutoConfiguration;
import com.google.cloud.spring.autoconfigure.pubsub.GcpPubSubProperties;
import com.google.cloud.spring.autoconfigure.pubsub.SelectiveSchedulerThreadNameProvider;
import com.google.cloud.spring.core.CredentialsSupplier;
import com.google.cloud.spring.core.DefaultCredentialsProvider;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.core.UserAgentHeaderProvider;
import com.google.cloud.spring.pubsub.PubSubAdmin;
import com.google.cloud.spring.pubsub.core.PubSubConfiguration;
import com.google.cloud.spring.pubsub.core.PubSubException;
import com.google.cloud.spring.pubsub.core.PubSubTemplate;
import com.google.cloud.spring.pubsub.core.health.HealthTrackerRegistry;
import com.google.cloud.spring.pubsub.core.publisher.PubSubPublisherTemplate;
import com.google.cloud.spring.pubsub.core.publisher.PublisherCustomizer;
import com.google.cloud.spring.pubsub.core.subscriber.PubSubSubscriberTemplate;
import com.google.cloud.spring.pubsub.support.CachingPublisherFactory;
import com.google.cloud.spring.pubsub.support.DefaultPublisherFactory;
import com.google.cloud.spring.pubsub.support.DefaultSubscriberFactory;
import com.google.cloud.spring.pubsub.support.PublisherFactory;
import com.google.cloud.spring.pubsub.support.SubscriberFactory;
import com.google.cloud.spring.pubsub.support.converter.PubSubMessageConverter;
import com.google.pubsub.v1.ProjectSubscriptionName;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.threeten.bp.Duration;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={GcpContextAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.pubsub.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={PubSubTemplate.class})
@EnableConfigurationProperties(value={GcpPubSubProperties.class})
public class GcpPubSubAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(GcpPubSubAutoConfiguration.class);
    private final GcpPubSubProperties gcpPubSubProperties;
    private final GcpProjectIdProvider finalProjectIdProvider;
    private final CredentialsProvider finalCredentialsProvider;
    private final HeaderProvider headerProvider = new UserAgentHeaderProvider(this.getClass());
    private final Map<ProjectSubscriptionName, ThreadPoolTaskScheduler> threadPoolTaskSchedulerMap = new HashMap<ProjectSubscriptionName, ThreadPoolTaskScheduler>();
    private final Map<ProjectSubscriptionName, FlowControlSettings> subscriberFlowControlSettingsMap = new HashMap<ProjectSubscriptionName, FlowControlSettings>();
    private final Map<ProjectSubscriptionName, RetrySettings> subscriberRetrySettingsMap = new HashMap<ProjectSubscriptionName, RetrySettings>();
    private final Map<ProjectSubscriptionName, ExecutorProvider> executorProviderMap = new HashMap<ProjectSubscriptionName, ExecutorProvider>();
    private final ApplicationContext applicationContext;
    private ThreadPoolTaskScheduler globalScheduler;
    private FlowControlSettings globalFlowControlSettings;
    private RetrySettings globalRetrySettings;
    private ExecutorProvider globalExecutorProvider;
    private ObjectProvider<SelectiveSchedulerThreadNameProvider> selectiveSchedulerThreadNameProvider;

    public GcpPubSubAutoConfiguration(GcpPubSubProperties gcpPubSubProperties, GcpProjectIdProvider gcpProjectIdProvider, CredentialsProvider credentialsProvider, ObjectProvider<SelectiveSchedulerThreadNameProvider> selectiveSchedulerThreadNameProvider, ApplicationContext applicationContext) throws IOException {
        this.gcpPubSubProperties = gcpPubSubProperties;
        this.applicationContext = applicationContext;
        this.selectiveSchedulerThreadNameProvider = selectiveSchedulerThreadNameProvider;
        GcpProjectIdProvider gcpProjectIdProvider2 = gcpPubSubProperties.getProjectId() != null ? gcpPubSubProperties::getProjectId : (this.finalProjectIdProvider = gcpProjectIdProvider);
        this.finalCredentialsProvider = gcpPubSubProperties.getEmulatorHost() == null || "false".equals(gcpPubSubProperties.getEmulatorHost()) ? (gcpPubSubProperties.getCredentials().hasKey() ? new DefaultCredentialsProvider((CredentialsSupplier)gcpPubSubProperties) : credentialsProvider) : NoCredentialsProvider.create();
        this.gcpPubSubProperties.initialize(this.finalProjectIdProvider.getProjectId());
    }

    @Bean
    @ConditionalOnMissingBean(name={"pubsubPublisherThreadPool"})
    public ThreadPoolTaskScheduler pubsubPublisherThreadPool() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(this.gcpPubSubProperties.getPublisher().getExecutorThreads());
        scheduler.setThreadNamePrefix("gcp-pubsub-publisher");
        scheduler.setDaemon(true);
        return scheduler;
    }

    @Bean
    @ConditionalOnMissingBean(name={"publisherExecutorProvider"})
    public ExecutorProvider publisherExecutorProvider(@Qualifier(value="pubsubPublisherThreadPool") ThreadPoolTaskScheduler scheduler) {
        return FixedExecutorProvider.create((ScheduledExecutorService)scheduler.getScheduledExecutor());
    }

    @Bean
    @ConditionalOnMissingBean
    public PubSubPublisherTemplate pubSubPublisherTemplate(PublisherFactory publisherFactory, ObjectProvider<PubSubMessageConverter> pubSubMessageConverter) {
        PubSubPublisherTemplate pubSubPublisherTemplate = new PubSubPublisherTemplate(publisherFactory);
        pubSubMessageConverter.ifUnique(arg_0 -> ((PubSubPublisherTemplate)pubSubPublisherTemplate).setMessageConverter(arg_0));
        return pubSubPublisherTemplate;
    }

    @Bean
    @ConditionalOnMissingBean(name={"pubSubAcknowledgementExecutor"})
    public Executor pubSubAcknowledgementExecutor() {
        ThreadPoolTaskExecutor ackExecutor = new ThreadPoolTaskExecutor();
        ackExecutor.setMaxPoolSize(this.gcpPubSubProperties.getSubscriber().getMaxAcknowledgementThreads());
        ackExecutor.setThreadNamePrefix("gcp-pubsub-ack-executor");
        ackExecutor.setDaemon(true);
        return ackExecutor;
    }

    @Bean
    @ConditionalOnMissingBean
    public PubSubSubscriberTemplate pubSubSubscriberTemplate(SubscriberFactory subscriberFactory, ObjectProvider<PubSubMessageConverter> pubSubMessageConverter, @Qualifier(value="pubSubAsynchronousPullExecutor") ObjectProvider<Executor> asyncPullExecutor, @Qualifier(value="pubSubAcknowledgementExecutor") Executor ackExecutor) {
        PubSubSubscriberTemplate pubSubSubscriberTemplate = new PubSubSubscriberTemplate(subscriberFactory);
        pubSubMessageConverter.ifUnique(arg_0 -> ((PubSubSubscriberTemplate)pubSubSubscriberTemplate).setMessageConverter(arg_0));
        pubSubSubscriberTemplate.setAckExecutor(ackExecutor);
        asyncPullExecutor.ifAvailable(arg_0 -> ((PubSubSubscriberTemplate)pubSubSubscriberTemplate).setAsyncPullExecutor(arg_0));
        return pubSubSubscriberTemplate;
    }

    @Bean
    @ConditionalOnMissingBean
    public PubSubTemplate pubSubTemplate(PubSubPublisherTemplate pubSubPublisherTemplate, PubSubSubscriberTemplate pubSubSubscriberTemplate) {
        return new PubSubTemplate(pubSubPublisherTemplate, pubSubSubscriberTemplate);
    }

    private FlowControlSettings buildFlowControlSettings(PubSubConfiguration.FlowControl flowControl) {
        FlowControlSettings.Builder builder = FlowControlSettings.newBuilder();
        boolean shouldBuild = this.ifSet(flowControl.getLimitExceededBehavior(), arg_0 -> ((FlowControlSettings.Builder)builder).setLimitExceededBehavior(arg_0));
        shouldBuild |= this.ifSet(flowControl.getMaxOutstandingElementCount(), arg_0 -> ((FlowControlSettings.Builder)builder).setMaxOutstandingElementCount(arg_0));
        return (shouldBuild |= this.ifSet(flowControl.getMaxOutstandingRequestBytes(), arg_0 -> ((FlowControlSettings.Builder)builder).setMaxOutstandingRequestBytes(arg_0))) ? builder.build() : null;
    }

    @Bean
    @ConditionalOnMissingBean
    public SubscriberFactory defaultSubscriberFactory(@Qualifier(value="subscriberExecutorProvider") Optional<ExecutorProvider> executorProvider, @Qualifier(value="subscriberSystemExecutorProvider") ObjectProvider<ExecutorProvider> systemExecutorProvider, @Qualifier(value="subscriberFlowControlSettings") ObjectProvider<FlowControlSettings> flowControlSettings, @Qualifier(value="subscriberApiClock") ObjectProvider<ApiClock> apiClock, @Qualifier(value="subscriberRetrySettings") ObjectProvider<RetrySettings> retrySettings, @Qualifier(value="healthTrackerRegistry") ObjectProvider<HealthTrackerRegistry> healthTrackerRegistry, @Qualifier(value="subscriberTransportChannelProvider") TransportChannelProvider subscriberTransportChannelProvider) {
        DefaultSubscriberFactory factory = new DefaultSubscriberFactory(this.finalProjectIdProvider, (PubSubConfiguration)this.gcpPubSubProperties);
        if (executorProvider.isPresent()) {
            logger.warn("The subscriberExecutorProvider bean is being deprecated. Please use application.properties to configure properties");
            factory.setExecutorProvider(executorProvider.get());
        }
        factory.setExecutorProviderMap(this.executorProviderMap);
        factory.setGlobalExecutorProvider(this.globalExecutorProvider);
        factory.setCredentialsProvider(this.finalCredentialsProvider);
        factory.setHeaderProvider(this.headerProvider);
        factory.setChannelProvider(subscriberTransportChannelProvider);
        systemExecutorProvider.ifAvailable(arg_0 -> ((DefaultSubscriberFactory)factory).setSystemExecutorProvider(arg_0));
        if (flowControlSettings.getIfAvailable() != null) {
            logger.warn("The subscriberFlowControlSettings bean is being deprecated. Please use application.properties to configure properties");
            factory.setFlowControlSettings((FlowControlSettings)flowControlSettings.getIfAvailable());
        }
        factory.setFlowControlSettingsMap(this.subscriberFlowControlSettingsMap);
        factory.setGlobalFlowControlSettings(this.globalFlowControlSettings);
        apiClock.ifAvailable(arg_0 -> ((DefaultSubscriberFactory)factory).setApiClock(arg_0));
        if (retrySettings.getIfAvailable() != null) {
            logger.warn("The subscriberRetrySettings bean is being deprecated. Please use application.properties to configure properties");
            factory.setSubscriberStubRetrySettings((RetrySettings)retrySettings.getIfAvailable());
        }
        factory.setRetrySettingsMap(this.subscriberRetrySettingsMap);
        factory.setGlobalRetrySettings(this.globalRetrySettings);
        healthTrackerRegistry.ifAvailable(arg_0 -> ((DefaultSubscriberFactory)factory).setHealthTrackerRegistry(arg_0));
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean(name={"publisherBatchSettings"})
    public BatchingSettings publisherBatchSettings() {
        BatchingSettings.Builder builder = BatchingSettings.newBuilder();
        PubSubConfiguration.Batching batching = this.gcpPubSubProperties.getPublisher().getBatching();
        FlowControlSettings flowControlSettings = this.buildFlowControlSettings(batching.getFlowControl());
        if (flowControlSettings != null) {
            builder.setFlowControlSettings(flowControlSettings);
        }
        boolean shouldBuild = this.ifSet(batching.getDelayThresholdSeconds(), x -> builder.setDelayThreshold(Duration.ofSeconds((long)x)));
        shouldBuild |= this.ifSet(batching.getElementCountThreshold(), arg_0 -> ((BatchingSettings.Builder)builder).setElementCountThreshold(arg_0));
        shouldBuild |= this.ifSet(batching.getEnabled(), arg_0 -> ((BatchingSettings.Builder)builder).setIsEnabled(arg_0));
        return (shouldBuild |= this.ifSet(batching.getRequestByteThreshold(), arg_0 -> ((BatchingSettings.Builder)builder).setRequestByteThreshold(arg_0))) ? builder.build() : null;
    }

    @Bean
    @ConditionalOnMissingBean(name={"publisherRetrySettings"})
    public RetrySettings publisherRetrySettings() {
        return this.buildRetrySettings(this.gcpPubSubProperties.getPublisher().getRetry());
    }

    private RetrySettings buildRetrySettings(PubSubConfiguration.Retry retryProperties) {
        RetrySettings.Builder builder = RetrySettings.newBuilder();
        boolean shouldBuild = this.ifSet(retryProperties.getInitialRetryDelaySeconds(), x -> builder.setInitialRetryDelay(Duration.ofSeconds((long)x)));
        shouldBuild |= this.ifSet(retryProperties.getInitialRpcTimeoutSeconds(), x -> builder.setInitialRpcTimeout(Duration.ofSeconds((long)x)));
        shouldBuild |= this.ifSet(retryProperties.getJittered(), arg_0 -> ((RetrySettings.Builder)builder).setJittered(arg_0));
        shouldBuild |= this.ifSet(retryProperties.getMaxAttempts(), arg_0 -> ((RetrySettings.Builder)builder).setMaxAttempts(arg_0));
        shouldBuild |= this.ifSet(retryProperties.getMaxRetryDelaySeconds(), x -> builder.setMaxRetryDelay(Duration.ofSeconds((long)x)));
        shouldBuild |= this.ifSet(retryProperties.getMaxRpcTimeoutSeconds(), x -> builder.setMaxRpcTimeout(Duration.ofSeconds((long)x)));
        shouldBuild |= this.ifSet(retryProperties.getRetryDelayMultiplier(), arg_0 -> ((RetrySettings.Builder)builder).setRetryDelayMultiplier(arg_0));
        shouldBuild |= this.ifSet(retryProperties.getTotalTimeoutSeconds(), x -> builder.setTotalTimeout(Duration.ofSeconds((long)x)));
        return (shouldBuild |= this.ifSet(retryProperties.getRpcTimeoutMultiplier(), arg_0 -> ((RetrySettings.Builder)builder).setRpcTimeoutMultiplier(arg_0))) ? builder.build() : null;
    }

    private <T> boolean ifSet(T property, Consumer<T> consumer) {
        if (property != null) {
            consumer.accept(property);
            return true;
        }
        return false;
    }

    @Bean
    @ConditionalOnMissingBean
    public PublisherFactory defaultPublisherFactory(@Qualifier(value="publisherExecutorProvider") ExecutorProvider executorProvider, @Qualifier(value="publisherBatchSettings") ObjectProvider<BatchingSettings> batchingSettings, @Qualifier(value="publisherRetrySettings") ObjectProvider<RetrySettings> retrySettings, @Qualifier(value="publisherTransportChannelProvider") TransportChannelProvider publisherTransportChannelProvider, ObjectProvider<PublisherCustomizer> customizersProvider) {
        DefaultPublisherFactory factory = new DefaultPublisherFactory(this.finalProjectIdProvider);
        factory.setExecutorProvider(executorProvider);
        factory.setCredentialsProvider(this.finalCredentialsProvider);
        factory.setHeaderProvider(this.headerProvider);
        factory.setChannelProvider(publisherTransportChannelProvider);
        retrySettings.ifAvailable(arg_0 -> ((DefaultPublisherFactory)factory).setRetrySettings(arg_0));
        batchingSettings.ifAvailable(arg_0 -> ((DefaultPublisherFactory)factory).setBatchingSettings(arg_0));
        factory.setEnableMessageOrdering(this.gcpPubSubProperties.getPublisher().getEnableMessageOrdering());
        factory.setEndpoint(this.gcpPubSubProperties.getPublisher().getEndpoint());
        List customizers = customizersProvider.orderedStream().collect(Collectors.toList());
        Collections.reverse(customizers);
        factory.setCustomizers(customizers);
        return new CachingPublisherFactory((PublisherFactory)factory);
    }

    @Bean
    @ConditionalOnMissingBean
    public PubSubAdmin pubSubAdmin(TopicAdminClient topicAdminClient, SubscriptionAdminClient subscriptionAdminClient) {
        return new PubSubAdmin(this.finalProjectIdProvider, topicAdminClient, subscriptionAdminClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public TopicAdminClient topicAdminClient(TopicAdminSettings topicAdminSettings) {
        try {
            return TopicAdminClient.create((TopicAdminSettings)topicAdminSettings);
        }
        catch (IOException ioe) {
            throw new PubSubException("An error occurred while creating TopicAdminClient.", (Throwable)ioe);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public TopicAdminSettings topicAdminSettings(@Qualifier(value="publisherTransportChannelProvider") TransportChannelProvider publisherTransportChannelProvider) {
        try {
            return ((TopicAdminSettings.Builder)((TopicAdminSettings.Builder)((TopicAdminSettings.Builder)TopicAdminSettings.newBuilder().setCredentialsProvider(this.finalCredentialsProvider)).setHeaderProvider(this.headerProvider)).setTransportChannelProvider(publisherTransportChannelProvider)).build();
        }
        catch (IOException ioe) {
            throw new PubSubException("An error occurred while creating TopicAdminSettings.", (Throwable)ioe);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public SubscriptionAdminClient subscriptionAdminClient(@Qualifier(value="subscriberTransportChannelProvider") TransportChannelProvider subscriberTransportChannelProvider) {
        try {
            return SubscriptionAdminClient.create((SubscriptionAdminSettings)((SubscriptionAdminSettings.Builder)((SubscriptionAdminSettings.Builder)((SubscriptionAdminSettings.Builder)SubscriptionAdminSettings.newBuilder().setCredentialsProvider(this.finalCredentialsProvider)).setHeaderProvider(this.headerProvider)).setTransportChannelProvider(subscriberTransportChannelProvider)).build());
        }
        catch (IOException ioe) {
            throw new PubSubException("An error occurred while creating SubscriptionAdminClient.", (Throwable)ioe);
        }
    }

    @Bean
    @ConditionalOnMissingBean(name={"subscriberTransportChannelProvider"})
    public TransportChannelProvider subscriberTransportChannelProvider() {
        return SubscriberStubSettings.defaultGrpcTransportProviderBuilder().setKeepAliveTime(Duration.ofMinutes((long)this.gcpPubSubProperties.getKeepAliveIntervalMinutes())).build();
    }

    @Bean
    @ConditionalOnMissingBean(name={"publisherTransportChannelProvider"})
    public TransportChannelProvider publisherTransportChannelProvider() {
        return PublisherStubSettings.defaultGrpcTransportProviderBuilder().setKeepAliveTime(Duration.ofMinutes((long)this.gcpPubSubProperties.getKeepAliveIntervalMinutes())).build();
    }

    @PostConstruct
    public void registerSubscriberSettings() {
        GenericApplicationContext context = (GenericApplicationContext)this.applicationContext;
        this.registerSubscriberThreadPoolSchedulerBeans(context);
        this.registerExecutorProviderBeans(context);
        this.registerSubscriberFlowControlSettingsBeans(context);
        this.registerSubscriberRetrySettingsBeans(context);
    }

    private void registerSubscriberThreadPoolSchedulerBeans(GenericApplicationContext context) {
        Integer numThreads = this.getGlobalExecutorThreads();
        this.globalScheduler = this.createAndRegisterSchedulerBean(numThreads, "global-gcp-pubsub-subscriber", "globalPubSubSubscriberThreadPoolScheduler", context);
        this.registerSelectiveSchedulerBeans(context);
    }

    private void registerSubscriberFlowControlSettingsBeans(GenericApplicationContext context) {
        if (context.containsBean("subscriberFlowControlSettings")) {
            return;
        }
        this.globalFlowControlSettings = this.buildFlowControlSettings(this.gcpPubSubProperties.getSubscriber().getFlowControl());
        if (this.globalFlowControlSettings != null) {
            context.registerBeanDefinition("globalSubscriberFlowControlSettings", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(FlowControlSettings.class, () -> this.globalFlowControlSettings).getBeanDefinition());
        }
        this.createAndRegisterSelectiveFlowControlSettings(context);
    }

    private void registerExecutorProviderBeans(GenericApplicationContext context) {
        if (context.containsBean("subscriberExecutorProvider")) {
            return;
        }
        if (this.globalScheduler != null) {
            this.globalExecutorProvider = this.createAndRegisterExecutorProvider("globalSubscriberExecutorProvider", this.globalScheduler, context);
        }
        this.createAndRegisterSelectiveExecutorProvider(context);
    }

    private void registerSubscriberRetrySettingsBeans(GenericApplicationContext context) {
        if (context.containsBean("subscriberRetrySettings")) {
            return;
        }
        this.globalRetrySettings = this.buildRetrySettings(this.gcpPubSubProperties.getSubscriber().getRetry());
        if (this.globalRetrySettings != null) {
            context.registerBeanDefinition("globalSubscriberRetrySettings", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(RetrySettings.class, () -> this.globalRetrySettings).getBeanDefinition());
        }
        this.createAndRegisterSelectiveRetrySettings(context);
    }

    private void registerSelectiveSchedulerBeans(GenericApplicationContext context) {
        Map subscriberMap = this.gcpPubSubProperties.getFullyQualifiedSubscriberProperties();
        for (Map.Entry subscription : subscriberMap.entrySet()) {
            ProjectSubscriptionName fullSubscriptionName = (ProjectSubscriptionName)subscription.getKey();
            PubSubConfiguration.Subscriber selectiveSubscriber = (PubSubConfiguration.Subscriber)subscription.getValue();
            Integer selectiveExecutorThreads = selectiveSubscriber.getExecutorThreads();
            if (selectiveExecutorThreads == null) continue;
            String qualifiedName = fullSubscriptionName.toString();
            String threadName = ((SelectiveSchedulerThreadNameProvider)this.selectiveSchedulerThreadNameProvider.getIfAvailable(() -> subscriptionName -> "gcp-pubsub-subscriber-" + subscriptionName.toString())).getThreadName(fullSubscriptionName);
            String beanName = "threadPoolScheduler_" + qualifiedName;
            ThreadPoolTaskScheduler selectiveScheduler = this.createAndRegisterSchedulerBean(selectiveExecutorThreads, threadName, beanName, context);
            this.threadPoolTaskSchedulerMap.putIfAbsent(fullSubscriptionName, selectiveScheduler);
        }
    }

    private ThreadPoolTaskScheduler createAndRegisterSchedulerBean(Integer executorThreads, String threadName, String beanName, GenericApplicationContext context) {
        ThreadPoolTaskScheduler scheduler = this.createThreadPoolTaskScheduler(executorThreads, threadName);
        context.registerBeanDefinition(beanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(ThreadPoolTaskScheduler.class, () -> scheduler).getBeanDefinition());
        return scheduler;
    }

    private ThreadPoolTaskScheduler createThreadPoolTaskScheduler(Integer executorThreads, String threadName) {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(executorThreads.intValue());
        scheduler.setThreadNamePrefix(threadName);
        scheduler.setDaemon(true);
        return scheduler;
    }

    private void createAndRegisterSelectiveFlowControlSettings(GenericApplicationContext context) {
        Map subscriberMap = this.gcpPubSubProperties.getFullyQualifiedSubscriberProperties();
        for (Map.Entry subscription : subscriberMap.entrySet()) {
            ProjectSubscriptionName fullSubscriptionName = (ProjectSubscriptionName)subscription.getKey();
            String qualifiedName = fullSubscriptionName.toString();
            PubSubConfiguration.FlowControl flowControl = this.gcpPubSubProperties.computeSubscriberFlowControlSettings(fullSubscriptionName);
            FlowControlSettings flowControlSettings = this.buildFlowControlSettings(flowControl);
            if (flowControlSettings == null || flowControlSettings.equals(this.globalFlowControlSettings)) continue;
            this.subscriberFlowControlSettingsMap.putIfAbsent(fullSubscriptionName, flowControlSettings);
            String beanName = "subscriberFlowControlSettings-" + qualifiedName;
            context.registerBeanDefinition(beanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(FlowControlSettings.class, () -> flowControlSettings).getBeanDefinition());
        }
    }

    private void createAndRegisterSelectiveExecutorProvider(GenericApplicationContext context) {
        for (Map.Entry<ProjectSubscriptionName, ThreadPoolTaskScheduler> schedulerSet : this.threadPoolTaskSchedulerMap.entrySet()) {
            ProjectSubscriptionName fullSubscriptionName = schedulerSet.getKey();
            String qualifiedName = fullSubscriptionName.toString();
            if (this.executorProviderMap.containsKey(fullSubscriptionName)) continue;
            ThreadPoolTaskScheduler scheduler = schedulerSet.getValue();
            ExecutorProvider executorProvider = this.createAndRegisterExecutorProvider("subscriberExecutorProvider-" + qualifiedName, scheduler, context);
            this.executorProviderMap.putIfAbsent(fullSubscriptionName, executorProvider);
        }
    }

    private ExecutorProvider createAndRegisterExecutorProvider(String beanName, ThreadPoolTaskScheduler scheduler, GenericApplicationContext context) {
        scheduler.initialize();
        FixedExecutorProvider executor = FixedExecutorProvider.create((ScheduledExecutorService)scheduler.getScheduledExecutor());
        context.registerBeanDefinition(beanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(ExecutorProvider.class, () -> GcpPubSubAutoConfiguration.lambda$createAndRegisterExecutorProvider$12((ExecutorProvider)executor)).getBeanDefinition());
        return executor;
    }

    private void createAndRegisterSelectiveRetrySettings(GenericApplicationContext context) {
        Map subscriberMap = this.gcpPubSubProperties.getFullyQualifiedSubscriberProperties();
        for (Map.Entry subscription : subscriberMap.entrySet()) {
            ProjectSubscriptionName qualifiedName = (ProjectSubscriptionName)subscription.getKey();
            PubSubConfiguration.Retry retry = this.gcpPubSubProperties.computeSubscriberRetrySettings(qualifiedName);
            RetrySettings retrySettings = this.buildRetrySettings(retry);
            if (retrySettings == null || retrySettings.equals(this.globalRetrySettings)) continue;
            this.subscriberRetrySettingsMap.putIfAbsent(qualifiedName, retrySettings);
            String beanName = "subscriberRetrySettings-" + qualifiedName.toString();
            context.registerBeanDefinition(beanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(RetrySettings.class, () -> retrySettings).getBeanDefinition());
        }
    }

    private Integer getGlobalExecutorThreads() {
        Integer numThreads = this.gcpPubSubProperties.getSubscriber().getExecutorThreads();
        return numThreads != null ? numThreads : 4;
    }

    private static /* synthetic */ ExecutorProvider lambda$createAndRegisterExecutorProvider$12(ExecutorProvider executor) {
        return executor;
    }
}

