/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.trace.pubsub;

import com.google.cloud.spring.autoconfigure.trace.pubsub.PubSubTracing;
import com.google.cloud.spring.autoconfigure.trace.pubsub.TracingSubscriberFactory;
import com.google.cloud.spring.pubsub.support.SubscriberFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;

class TracePubSubBeanPostProcessor
implements BeanPostProcessor {
    private final BeanFactory beanFactory;
    private PubSubTracing tracing;

    TracePubSubBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof SubscriberFactory) {
            return new TracingSubscriberFactory(this.pubSubTracing(), (SubscriberFactory)bean);
        }
        return bean;
    }

    PubSubTracing pubSubTracing() {
        if (this.tracing == null) {
            this.tracing = (PubSubTracing)this.beanFactory.getBean(PubSubTracing.class);
        }
        return this.tracing;
    }
}

