/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.trace.pubsub;

import brave.Span;
import brave.internal.Nullable;
import brave.messaging.ProducerRequest;
import brave.propagation.Propagation;
import com.google.pubsub.v1.PubsubMessage;

final class PubSubProducerRequest
extends ProducerRequest {
    static final Propagation.RemoteGetter<PubSubProducerRequest> GETTER = new Propagation.RemoteGetter<PubSubProducerRequest>(){

        public Span.Kind spanKind() {
            return Span.Kind.PRODUCER;
        }

        public String get(PubSubProducerRequest request, String name) {
            return request.delegate.getAttributesOrDefault(name, null);
        }

        public String toString() {
            return "PubsubMessage.Builder::getAttribute";
        }
    };
    static final Propagation.RemoteSetter<PubSubProducerRequest> SETTER = new Propagation.RemoteSetter<PubSubProducerRequest>(){

        public Span.Kind spanKind() {
            return Span.Kind.PRODUCER;
        }

        public void put(PubSubProducerRequest request, String name, String value) {
            request.delegate.putAttributes(name, value);
        }

        public String toString() {
            return "PubsubMessage.Builder::putAttributes";
        }
    };
    final PubsubMessage.Builder delegate;
    final String topic;

    PubSubProducerRequest(PubsubMessage.Builder delegate, @Nullable String topic) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        this.delegate = delegate;
        this.topic = topic;
    }

    public String operation() {
        return "send";
    }

    public String channelKind() {
        return "topic";
    }

    public String channelName() {
        return this.topic;
    }

    public Span.Kind spanKind() {
        return Span.Kind.PRODUCER;
    }

    public Object unwrap() {
        return this.delegate;
    }
}

