/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.pubsub.health;

import com.google.cloud.spring.pubsub.core.health.HealthTracker;
import com.google.cloud.spring.pubsub.core.health.HealthTrackerRegistry;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class PubSubSubscriptionHealthIndicator
extends AbstractHealthIndicator {
    private final HealthTrackerRegistry healthTrackerRegistry;

    public PubSubSubscriptionHealthIndicator(HealthTrackerRegistry healthTrackerRegistry) {
        this.healthTrackerRegistry = healthTrackerRegistry;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        builder.up();
        for (HealthTracker healthTracker : this.healthTrackerRegistry.healthTrackers()) {
            long messagesOverThreshold = healthTracker.messagesOverThreshold();
            if (messagesOverThreshold <= 0L) continue;
            builder.down();
            builder.withDetail(healthTracker.subscription().toString(), (Object)messagesOverThreshold);
        }
    }
}

