/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.parameter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.gax.core.CredentialsProvider;
import com.google.auth.Credentials;
import com.google.cloud.parametermanager.v1.ParameterManagerClient;
import com.google.cloud.parametermanager.v1.ParameterVersionName;
import com.google.cloud.parametermanager.v1.RenderParameterVersionResponse;
import com.google.cloud.spring.autoconfigure.parameter.GcpParameterProperties;
import com.google.cloud.spring.core.CredentialsSupplier;
import com.google.cloud.spring.core.DefaultCredentialsProvider;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.http.HttpStatusCode;
import org.springframework.util.Assert;
import org.springframework.web.client.HttpClientErrorException;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class GoogleParameterPropertySourceLocator
implements PropertySourceLocator {
    private static final String PROPERTY_SOURCE_NAME = "spring-cloud-gcp";
    private final ParameterManagerClient parameterManagerClient;
    private String projectId;
    private Credentials credentials;
    private String name;
    private String profile;
    private String location;
    private boolean enabled;

    public GoogleParameterPropertySourceLocator(GcpProjectIdProvider projectIdProvider, CredentialsProvider credentialsProvider, GcpParameterProperties gcpParameterProperties, ParameterManagerClient parameterManagerClient) throws IOException {
        this.parameterManagerClient = parameterManagerClient;
        Assert.notNull((Object)gcpParameterProperties, (String)"Google Parameter properties must not be null");
        if (gcpParameterProperties.isEnabled()) {
            Assert.notNull((Object)credentialsProvider, (String)"Credentials provider cannot be null");
            Assert.notNull((Object)projectIdProvider, (String)"Project ID provider cannot be null");
            this.credentials = gcpParameterProperties.getCredentials().hasKey() ? new DefaultCredentialsProvider((CredentialsSupplier)gcpParameterProperties).getCredentials() : credentialsProvider.getCredentials();
            this.projectId = gcpParameterProperties.getProjectId() != null ? gcpParameterProperties.getProjectId() : projectIdProvider.getProjectId();
            Assert.notNull((Object)this.credentials, (String)"Credentials must not be null");
            Assert.notNull((Object)this.projectId, (String)"Project ID must not be null");
            this.name = gcpParameterProperties.getName();
            this.profile = gcpParameterProperties.getProfile();
            this.location = gcpParameterProperties.getLocation();
            this.enabled = gcpParameterProperties.isEnabled();
            Assert.notNull((Object)this.name, (String)"Parameter name must not be null");
            Assert.notNull((Object)this.profile, (String)"Parameter version must not be null");
        }
    }

    RenderParameterVersionResponse getRemoteEnvironment() throws Exception {
        try {
            ParameterVersionName parameterVersionName = ParameterVersionName.of((String)this.projectId, (String)this.location, (String)this.name, (String)this.profile);
            RenderParameterVersionResponse response = this.parameterManagerClient.renderParameterVersion(parameterVersionName.toString());
            if (response == null) {
                throw new HttpClientErrorException(HttpStatusCode.valueOf((int)500), "Invalid response from Parameter Manager API");
            }
            return response;
        }
        catch (Exception ex) {
            throw new Exception("Unable to load the configuration", ex);
        }
    }

    public PropertySource<?> locate(Environment environment) {
        Map<String, Object> config;
        if (!this.enabled) {
            return new MapPropertySource(PROPERTY_SOURCE_NAME, Collections.emptyMap());
        }
        try {
            RenderParameterVersionResponse googleParameterEnvironment = this.getRemoteEnvironment();
            config = GoogleParameterPropertySourceLocator.convertStringToMap(googleParameterEnvironment.getRenderedPayload().toStringUtf8());
            Assert.notNull((Object)googleParameterEnvironment, (String)"Configuration not in expected format.");
        }
        catch (Exception ex) {
            String message = "Error loading configuration";
            throw new RuntimeException(message, ex);
        }
        return new MapPropertySource(PROPERTY_SOURCE_NAME, config);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public static Map<String, Object> convertStringToMap(String data) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return (Map)objectMapper.readValue(data, Map.class);
        }
        catch (Exception e) {
            try {
                Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
                return (Map)yaml.load(data);
            }
            catch (Exception ex) {
                ex.addSuppressed(e);
                throw new RuntimeException("Error parsing Properties", ex);
            }
        }
    }
}

