/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.secretmanager;

import java.util.List;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.ConfigDataResource;

public class SecretManagerConfigDataLocationResolverLoader
implements ConfigDataLocationResolver<ConfigDataResource> {
    private static final boolean SECRET_MANAGER_PRESENT = SecretManagerConfigDataLocationResolverLoader.isClassPresent("com.google.cloud.spring.secretmanager.SecretManagerSyntaxUtils");
    private final ConfigDataLocationResolver<ConfigDataResource> delegate = SECRET_MANAGER_PRESENT ? this.instantiateRealResolver() : null;

    private ConfigDataLocationResolver<ConfigDataResource> instantiateRealResolver() {
        try {
            Class<?> clazz = Class.forName("com.google.cloud.spring.autoconfigure.secretmanager.SecretManagerConfigDataLocationResolver");
            return (ConfigDataLocationResolver)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to instantiate SecretManagerConfigDataLocationResolver", ex);
        }
    }

    public boolean isResolvable(ConfigDataLocationResolverContext context, ConfigDataLocation location) {
        return this.delegate != null && this.delegate.isResolvable(context, location);
    }

    private static boolean isClassPresent(String clazzFullName) {
        try {
            Class.forName(clazzFullName);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public List<ConfigDataResource> resolve(ConfigDataLocationResolverContext context, ConfigDataLocation location) {
        if (this.delegate == null) {
            throw new IllegalStateException("Secret Manager support is not available on the classpath.");
        }
        return this.delegate.resolve(context, location);
    }
}

