/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.parametermanager;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.parametermanager.v1.ParameterManagerClient;
import com.google.cloud.parametermanager.v1.ParameterManagerSettings;
import com.google.cloud.spring.autoconfigure.core.GcpContextAutoConfiguration;
import com.google.cloud.spring.autoconfigure.parametermanager.DefaultParameterManagerClientFactory;
import com.google.cloud.spring.autoconfigure.parametermanager.GcpParameterManagerProperties;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.core.UserAgentHeaderProvider;
import com.google.cloud.spring.parametermanager.ParameterManagerClientFactory;
import com.google.cloud.spring.parametermanager.ParameterManagerTemplate;
import java.io.IOException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={GcpParameterManagerProperties.class})
@ConditionalOnClass(value={ParameterManagerTemplate.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.parametermanager.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={GcpContextAutoConfiguration.class})
public class GcpParameterManagerAutoConfiguration {
    private final GcpProjectIdProvider gcpProjectIdProvider;
    private final GcpParameterManagerProperties properties;
    private final CredentialsProvider credentialsProvider;

    public GcpParameterManagerAutoConfiguration(CredentialsProvider credentialsProvider, GcpParameterManagerProperties properties, GcpProjectIdProvider projectIdProvider) {
        this.credentialsProvider = credentialsProvider;
        this.properties = properties;
        this.gcpProjectIdProvider = properties.getProjectId() != null ? properties::getProjectId : projectIdProvider;
    }

    @Bean
    @ConditionalOnMissingBean
    public ParameterManagerClient parameterManagerClient() throws IOException {
        ParameterManagerSettings settings = ((ParameterManagerSettings.Builder)((ParameterManagerSettings.Builder)ParameterManagerSettings.newBuilder().setCredentialsProvider(this.credentialsProvider)).setHeaderProvider((HeaderProvider)new UserAgentHeaderProvider(GcpParameterManagerAutoConfiguration.class))).build();
        return ParameterManagerClient.create((ParameterManagerSettings)settings);
    }

    @Bean
    @ConditionalOnMissingBean
    public ParameterManagerClientFactory clientFactory(ParameterManagerClient client) {
        return new DefaultParameterManagerClientFactory(this.credentialsProvider, client);
    }

    @Bean
    @ConditionalOnMissingBean
    public ParameterManagerTemplate parameterManagerTemplate(ParameterManagerClient client, ObjectProvider<ParameterManagerClientFactory> clientFactoryProvider) {
        ParameterManagerClientFactory clientFactory = (ParameterManagerClientFactory)clientFactoryProvider.getIfAvailable();
        if (clientFactory != null) {
            return new ParameterManagerTemplate(clientFactory, this.gcpProjectIdProvider).setAllowDefaultParameterValue(this.properties.isAllowDefaultParameter());
        }
        return new ParameterManagerTemplate(client, this.gcpProjectIdProvider).setAllowDefaultParameterValue(this.properties.isAllowDefaultParameter());
    }
}

