/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.datastore.core;

import com.google.cloud.datastore.Value;
import com.google.cloud.spring.data.datastore.core.mapping.DatastoreDataException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.Supplier;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.Factory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.objenesis.ObjenesisStd;
import org.springframework.util.Assert;

final class LazyUtil {
    private static final ObjenesisStd objenesis = new ObjenesisStd();

    private LazyUtil() {
    }

    static <T> T wrapSimpleLazyProxy(Supplier<T> supplierFunc, Class<T> type, Value keys) {
        if (type.isInterface()) {
            return (T)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new SimpleLazyDynamicInvocationHandler(supplierFunc, keys));
        }
        Factory factory = (Factory)objenesis.newInstance(LazyUtil.getEnhancedTypeFor(type));
        factory.setCallbacks(new Callback[]{new SimpleLazyDynamicInvocationHandler(supplierFunc, keys)});
        return (T)factory;
    }

    private static Class<?> getEnhancedTypeFor(Class<?> type) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(type);
        enhancer.setCallbackType(MethodInterceptor.class);
        return enhancer.createClass();
    }

    public static boolean isLazyAndNotLoaded(Object object) {
        SimpleLazyDynamicInvocationHandler handler = LazyUtil.getProxy(object);
        if (handler != null) {
            return !handler.isEvaluated() && handler.getKeys() != null;
        }
        return false;
    }

    public static Value getKeys(Object object) {
        SimpleLazyDynamicInvocationHandler handler = LazyUtil.getProxy(object);
        if (handler != null && !handler.isEvaluated()) {
            return handler.getKeys();
        }
        return null;
    }

    private static SimpleLazyDynamicInvocationHandler getProxy(Object object) {
        Callback[] callbacks;
        if (Proxy.isProxyClass(object.getClass()) && Proxy.getInvocationHandler(object) instanceof SimpleLazyDynamicInvocationHandler) {
            return (SimpleLazyDynamicInvocationHandler)Proxy.getInvocationHandler(object);
        }
        if (object instanceof Factory && (callbacks = ((Factory)object).getCallbacks()) != null && callbacks.length == 1 && callbacks[0] instanceof SimpleLazyDynamicInvocationHandler) {
            return (SimpleLazyDynamicInvocationHandler)callbacks[0];
        }
        return null;
    }

    public static final class SimpleLazyDynamicInvocationHandler<T>
    implements InvocationHandler,
    MethodInterceptor {
        private final Supplier<T> supplierFunc;
        private final Value keys;
        private boolean isEvaluated = false;
        private T value;

        private SimpleLazyDynamicInvocationHandler(Supplier<T> supplierFunc, Value keys) {
            Assert.notNull(supplierFunc, (String)"A non-null supplier function is required for a lazy proxy.");
            this.supplierFunc = supplierFunc;
            this.keys = keys;
        }

        private boolean isEvaluated() {
            return this.isEvaluated;
        }

        public Value getKeys() {
            return this.keys;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (!this.isEvaluated) {
                T value = this.supplierFunc.get();
                if (value == null) {
                    throw new DatastoreDataException("Can't load referenced entity");
                }
                this.value = value;
                this.isEvaluated = true;
            }
            return method.invoke(this.value, args);
        }

        public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
            return this.invoke(o, method, objects);
        }
    }
}

