/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.datastore.core.mapping;

import com.google.cloud.spring.data.datastore.core.mapping.DatastorePersistentEntity;
import com.google.cloud.spring.data.datastore.core.mapping.DatastorePersistentEntityImpl;
import com.google.cloud.spring.data.datastore.core.mapping.DatastorePersistentProperty;
import com.google.cloud.spring.data.datastore.core.mapping.DatastorePersistentPropertyImpl;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.TypeInformation;

public class DatastoreMappingContext
extends AbstractMappingContext<DatastorePersistentEntity<?>, DatastorePersistentProperty>
implements ApplicationContextAware {
    private static final FieldNamingStrategy DEFAULT_NAMING_STRATEGY = PropertyNameFieldNamingStrategy.INSTANCE;
    private final FieldNamingStrategy fieldNamingStrategy = DEFAULT_NAMING_STRATEGY;
    private ApplicationContext applicationContext;
    private static final Map<Class, Set<Class>> discriminationFamilies = new ConcurrentHashMap<Class, Set<Class>>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public static void addDiscriminationClassConnection(Class parentClass, Class subClass) {
        Set setParent = discriminationFamilies.computeIfAbsent(parentClass, unused -> new HashSet());
        Set setSubClass = discriminationFamilies.computeIfAbsent(subClass, unused -> new HashSet());
        setParent.add(subClass);
        setSubClass.forEach(x -> {
            if (!discriminationFamilies.get(parentClass).contains(x)) {
                DatastoreMappingContext.addDiscriminationClassConnection(parentClass, x);
            }
        });
        Class grandParent = parentClass.getSuperclass();
        if (grandParent != null) {
            DatastoreMappingContext.addDiscriminationClassConnection(grandParent, subClass);
        }
    }

    public static Set<Class> getDiscriminationFamily(Class aClass) {
        return discriminationFamilies.get(aClass);
    }

    protected <T> DatastorePersistentEntityImpl<T> constructPersistentEntity(TypeInformation<T> typeInformation) {
        return new DatastorePersistentEntityImpl<T>(typeInformation, this);
    }

    protected <T> DatastorePersistentEntity<?> createPersistentEntity(TypeInformation<T> typeInformation) {
        DatastorePersistentEntityImpl<T> persistentEntity = this.constructPersistentEntity(typeInformation);
        if (this.applicationContext != null) {
            persistentEntity.setApplicationContext(this.applicationContext);
        }
        return persistentEntity;
    }

    protected DatastorePersistentProperty createPersistentProperty(Property property, DatastorePersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        return new DatastorePersistentPropertyImpl(property, (PersistentEntity<?, DatastorePersistentProperty>)owner, simpleTypeHolder, this.fieldNamingStrategy);
    }
}

