/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.datastore.core.mapping;

import com.google.cloud.spring.data.datastore.core.mapping.DatastoreDataException;
import com.google.cloud.spring.data.datastore.core.mapping.DatastorePersistentProperty;
import com.google.cloud.spring.data.datastore.core.mapping.Descendants;
import com.google.cloud.spring.data.datastore.core.mapping.EmbeddedType;
import com.google.cloud.spring.data.datastore.core.mapping.Entity;
import com.google.cloud.spring.data.datastore.core.mapping.Field;
import com.google.cloud.spring.data.datastore.core.mapping.LazyReference;
import com.google.cloud.spring.data.datastore.core.mapping.Unindexed;
import java.util.stream.Collectors;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.StreamUtils;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.StringUtils;

public class DatastorePersistentPropertyImpl
extends AnnotationBasedPersistentProperty<DatastorePersistentProperty>
implements DatastorePersistentProperty {
    private static final String KEY_FIELD_NAME = "__key__";
    private final FieldNamingStrategy fieldNamingStrategy;

    DatastorePersistentPropertyImpl(Property property, PersistentEntity<?, DatastorePersistentProperty> owner, SimpleTypeHolder simpleTypeHolder, FieldNamingStrategy fieldNamingStrategy) {
        super(property, owner, simpleTypeHolder);
        this.fieldNamingStrategy = fieldNamingStrategy != null ? fieldNamingStrategy : PropertyNameFieldNamingStrategy.INSTANCE;
        this.verify();
    }

    private void verify() {
        if (this.hasFieldAnnotation() && (this.isDescendants() || this.isAssociation())) {
            throw new DatastoreDataException("Property cannot be annotated as @Field if it is annotated @Descendants or @Reference: " + this.getFieldName());
        }
        if (this.isDescendants() && this.isAssociation()) {
            throw new DatastoreDataException("Property cannot be annotated both @Descendants and @Reference: " + this.getFieldName());
        }
        if (this.isDescendants() && !this.isCollectionLike()) {
            throw new DatastoreDataException("Only collection-like properties can contain the descendant entity objects can be annotated @Descendants.");
        }
    }

    @Override
    public String getFieldName() {
        if (this.isIdProperty()) {
            return KEY_FIELD_NAME;
        }
        if (StringUtils.hasText((String)this.getAnnotatedFieldName())) {
            return this.getAnnotatedFieldName();
        }
        return this.fieldNamingStrategy.getFieldName((PersistentProperty)this);
    }

    private boolean hasFieldAnnotation() {
        return this.findAnnotation(Field.class) != null;
    }

    @Override
    public boolean isDescendants() {
        return this.findAnnotation(Descendants.class) != null;
    }

    @Override
    public boolean isUnindexed() {
        return this.findAnnotation(Unindexed.class) != null;
    }

    @Override
    public boolean isColumnBacked() {
        return !this.isDescendants() && !this.isAssociation();
    }

    @Override
    public EmbeddedType getEmbeddedType() {
        return EmbeddedType.of(this.getTypeInformation());
    }

    protected Association<DatastorePersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    private String getAnnotatedFieldName() {
        Field annotation = (Field)this.findAnnotation(Field.class);
        if (annotation != null && StringUtils.hasText((String)annotation.name())) {
            return annotation.name();
        }
        return null;
    }

    public Iterable<? extends TypeInformation<?>> getPersistentEntityTypes() {
        return StreamUtils.createStreamFromIterator(super.getPersistentEntityTypes().iterator()).filter(typeInfo -> typeInfo.getType().isAnnotationPresent(Entity.class)).collect(Collectors.toList());
    }

    @Override
    public boolean isLazyLoaded() {
        return this.findAnnotation(LazyReference.class) != null;
    }
}

