/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.datastore.core.util;

import java.lang.reflect.Array;
import org.springframework.util.CollectionUtils;

public final class ValueUtil {
    private ValueUtil() {
    }

    public static Object toListIfArray(Object val) {
        if (val != null && ValueUtil.isArrayOfItems(val.getClass())) {
            return CollectionUtils.arrayToList((Object)val);
        }
        return val;
    }

    public static Class boxIfNeeded(Class propertyType) {
        if (propertyType == null) {
            return null;
        }
        return propertyType.isPrimitive() ? Array.get(Array.newInstance(propertyType, 1), 0).getClass() : propertyType;
    }

    public static boolean isCollectionLike(Class type) {
        return Iterable.class.isAssignableFrom(type) || ValueUtil.isArrayOfItems(type);
    }

    private static boolean isArrayOfItems(Class type) {
        return type.isArray() && type != byte[].class;
    }
}

